/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.admincenter;

import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class IFrameHelper {
    public static final String WE_IFRAME_URL_PATTERN = "/site/connectClient";
    public static final int NBTRY = 10;

    public static boolean focusOnWEIFrame(WebDriver driver) {
        return IFrameHelper.focusOnWEIFrame(driver, 10);
    }

    protected static void sleep(long nbSeconds) {
        try {
            Thread.sleep(nbSeconds * 1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private static boolean focusOnWEIFrame(WebDriver driver, int nbTry) {
        if (!driver.getCurrentUrl().contains(WE_IFRAME_URL_PATTERN)) {
            if (nbTry > 0) {
                try {
                    WebElement iFrame = driver.findElement(By.id((String)"connectIframe"));
                    if (iFrame != null) {
                        driver.switchTo().frame(iFrame);
                        return true;
                    }
                    IFrameHelper.sleep(2L);
                    return IFrameHelper.focusOnWEIFrame(driver, nbTry - 1);
                }
                catch (Throwable e) {
                    System.out.println("Retry to find IFrame on page " + driver.getCurrentUrl());
                    IFrameHelper.sleep(2L);
                    return IFrameHelper.focusOnWEIFrame(driver, nbTry - 1);
                }
            }
            return false;
        }
        return true;
    }
}

