/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.admincenter;

import org.nuxeo.functionaltests.pages.AbstractPage;
import org.nuxeo.functionaltests.pages.admincenter.PackageInstallationScreen;
import org.nuxeo.functionaltests.pages.admincenter.UpdateCenterPage;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class PackageListingPage
extends AbstractPage {
    public PackageListingPage(WebDriver driver) {
        super(driver);
    }

    public WebElement getPackageLink(String packageId) {
        String xpath = "id('row_" + packageId + "')//a[contains(@class ,'button')]";
        return this.findElementWithTimeout(By.xpath((String)xpath), 20000);
    }

    public WebElement getPackageDownloadLink(String packageId) {
        WebElement link = this.getPackageLink(packageId);
        if (link != null && link.getText().trim().toLowerCase().startsWith("download")) {
            return link;
        }
        return null;
    }

    public WebElement getPackageInstallLink(String packageId) {
        WebElement link = this.getPackageLink(packageId);
        if (link != null && link.getText().trim().toLowerCase().startsWith("install")) {
            return link;
        }
        return null;
    }

    public WebElement download(String packageId) {
        System.out.println(this.driver.getCurrentUrl());
        WebElement downloadLink = this.getPackageDownloadLink(packageId);
        if (downloadLink != null) {
            downloadLink.click();
            return this.getPackageInstallLink(packageId);
        }
        return null;
    }

    public PackageInstallationScreen getInstallationScreen(String packageId) {
        WebElement installLink = this.getPackageInstallLink(packageId);
        if (installLink == null) {
            return null;
        }
        installLink.click();
        return this.asPage(PackageInstallationScreen.class);
    }

    public UpdateCenterPage exit() {
        this.driver.switchTo().defaultContent();
        return this.asPage(UpdateCenterPage.class);
    }
}

