/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.admincenter;

import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.pages.admincenter.AdminCenterBasePage;
import org.nuxeo.functionaltests.pages.admincenter.IFrameHelper;
import org.nuxeo.functionaltests.pages.admincenter.PackageListingPage;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class UpdateCenterPage
extends AdminCenterBasePage {
    @Required
    @FindBy(linkText="Packages from Nuxeo Marketplace")
    WebElement packagesFromNuxeoMarketPlaceLink;
    @Required
    @FindBy(linkText="Nuxeo Studio")
    WebElement packagesFromNuxeoStudioLink;

    public UpdateCenterPage(WebDriver driver) {
        super(driver);
    }

    protected static void sleep(long nbSeconds) {
        try {
            Thread.sleep(nbSeconds * 1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public PackageListingPage getPackageListingPage() {
        boolean iframeFound = IFrameHelper.focusOnWEIFrame(this.driver);
        assert (iframeFound);
        WebElement body = UpdateCenterPage.findElementWithTimeout(By.tagName((String)"body"));
        assert (body != null);
        PackageListingPage page = this.asPage(PackageListingPage.class);
        WebElement listing = UpdateCenterPage.findElementWithTimeout(By.xpath((String)"//table[@class='packageListing']"));
        assert (listing != null);
        return page;
    }

    public UpdateCenterPage getPackagesFromNuxeoMarketPlace() {
        this.packagesFromNuxeoMarketPlaceLink.click();
        UpdateCenterPage.sleep(1L);
        return this.asPage(UpdateCenterPage.class);
    }

    public UpdateCenterPage getPackagesFromNuxeoStudio() {
        this.packagesFromNuxeoStudioLink.click();
        UpdateCenterPage.sleep(1L);
        return this.asPage(UpdateCenterPage.class);
    }

    public boolean removePlatformFilterOnMarketPlacePage() {
        WebElement chk = UpdateCenterPage.findElementWithTimeout(By.xpath((String)"(.//*/input[@type='checkbox'])[2]"));
        if (chk == null) {
            return false;
        }
        if ("true".equals(chk.getAttribute("checked"))) {
            chk.click();
            UpdateCenterPage.sleep(2L);
        }
        return true;
    }
}

