/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.search;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.nuxeo.functionaltests.AjaxRequestManager;
import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.forms.Select2WidgetElement;
import org.nuxeo.functionaltests.forms.WidgetElement;
import org.nuxeo.functionaltests.pages.AbstractPage;
import org.nuxeo.functionaltests.pages.search.AbstractSearchSubPage;
import org.nuxeo.functionaltests.pages.search.SearchPage;
import org.nuxeo.functionaltests.pages.search.aggregates.CheckBoxAggregateElements;
import org.nuxeo.functionaltests.pages.search.aggregates.Select2AggregateElement;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class DefaultSearchSubPage
extends AbstractSearchSubPage {
    private static final String S2_COLLECTION_XPATH = "//*[@id='s2id_nxl_gridSearchLayout:nxw_searchLayout_form:nxl_default_search_layout:nxw_visible_collection_select2']";
    public static final String TREE_PATH_ID = "nxl_gridSearchLayout:nxw_searchLayout_form:nxl_default_search_layout:nxw_ecm_path_treeId";
    @FindBy(id="nxl_gridSearchLayout:nxw_searchLayout_form:nxl_default_search_layout:nxw_ecm_fulltext")
    protected WebElement fulltext;
    @FindBy(id="s2id_nxl_gridSearchLayout:nxw_searchLayout_form:nxl_default_search_layout:nxw_dc_creator_agg")
    protected WebElement authorAggregate;
    @FindBy(id="nxl_gridSearchLayout:nxw_searchLayout_form:nxl_default_search_layout:nxw_dc_coverage_agg")
    protected WebElement coverageAggregate;
    @FindBy(id="nxl_gridSearchLayout:nxw_searchLayout_form:nxl_default_search_layout:nxw_dc_created_agg")
    protected WebElement createdAggregate;
    @FindBy(id="nxl_gridSearchLayout:nxw_searchLayout_form:nxl_default_search_layout:nxw_dc_modified_agg")
    protected WebElement modifiedAggregate;
    @FindBy(id="nxl_gridSearchLayout:nxw_searchLayout_form:nxl_default_search_layout:nxw_common_size_agg")
    protected WebElement sizeAggregate;
    @FindBy(id="nxl_gridSearchLayout:nxw_searchLayout_form:nxl_default_search_layout:nxw_dc_subjects_agg")
    protected WebElement subjectsAggregate;
    @FindBy(id="nxw_ecm_path_openPopup")
    @Required
    protected WebElement openPathPopupButton;
    @FindBy(id="nxw_ecm_path")
    @Required
    protected WebElement selectPathDiv;
    public static final String PATH_REGEX = "(.*) \\((.*)\\)";
    protected static final String EXPAND_XPATH = "ancestor::div[@class='rf-trn']/span[contains(@class,'rf-trn-hnd')]";

    public DefaultSearchSubPage(WebDriver driver) {
        super(driver);
    }

    public WidgetElement getFullTextElement() {
        return new WidgetElement(this.driver, this.fulltext);
    }

    public Map<String, Integer> getAvailableCoverageAggregate() {
        return new CheckBoxAggregateElements(this.coverageAggregate).getAggregates();
    }

    public Map<String, Integer> getAvailableCreatedAggregate() {
        return new CheckBoxAggregateElements(this.createdAggregate).getAggregates();
    }

    public Map<String, Integer> getAvailableModifiedAggregate() {
        return new CheckBoxAggregateElements(this.modifiedAggregate).getAggregates();
    }

    public Map<String, Integer> getAvailableSizeAggregate() {
        return new CheckBoxAggregateElements(this.sizeAggregate).getAggregates();
    }

    public Map<String, Integer> getAvailableSubjectsAggregate() {
        return new CheckBoxAggregateElements(this.subjectsAggregate).getAggregates();
    }

    public WebElement getCoverageAggregate() {
        return this.coverageAggregate;
    }

    public WebElement getCreatedAggregate() {
        return this.createdAggregate;
    }

    public WebElement getModifiedAggregate() {
        return this.modifiedAggregate;
    }

    public WebElement getSizeAggregate() {
        return this.sizeAggregate;
    }

    public WebElement getSubjectsAggregate() {
        return this.subjectsAggregate;
    }

    public Map<String, Integer> getAvailableAuthorAggregate() {
        Select2AggregateElement s2AuthorAggregate = new Select2AggregateElement(this.driver, this.authorAggregate, true);
        return s2AuthorAggregate.getAggregates();
    }

    public SearchPage selectCoverageAggregate(String label) {
        new CheckBoxAggregateElements(this.driver, this.coverageAggregate).selectOrUnselect(label);
        return this.asPage(SearchPage.class);
    }

    public SearchPage selectCreatedAggregate(String label) {
        new CheckBoxAggregateElements(this.driver, this.createdAggregate).selectOrUnselect(label);
        return this.asPage(SearchPage.class);
    }

    public SearchPage selectModifiedAggregate(String label) {
        new CheckBoxAggregateElements(this.driver, this.modifiedAggregate).selectOrUnselect(label);
        return this.asPage(SearchPage.class);
    }

    public SearchPage selectSizeAggregate(String label) {
        new CheckBoxAggregateElements(this.driver, this.sizeAggregate).selectOrUnselect(label);
        return this.asPage(SearchPage.class);
    }

    public SearchPage selectSubjectsAggregate(String label) {
        new CheckBoxAggregateElements(this.driver, this.subjectsAggregate).selectOrUnselect(label);
        return this.asPage(SearchPage.class);
    }

    public void selectPath(String path) {
        AjaxRequestManager a;
        int i;
        assert (path != null && !path.isEmpty() && path.charAt(0) == '/');
        this.openPathPopupButton.click();
        Locator.waitUntilGivenFunction(new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver driver) {
                try {
                    WebElement tree = driver.findElement(By.id((String)DefaultSearchSubPage.TREE_PATH_ID));
                    return tree.isDisplayed();
                }
                catch (NoSuchElementException e) {
                    return false;
                }
            }
        });
        if (path.length() == 1) {
            AjaxRequestManager a2 = new AjaxRequestManager(this.driver);
            a2.watchAjaxRequests();
            this.driver.findElement(By.id((String)TREE_PATH_ID)).findElement(By.linkText((String)"/")).click();
            a2.waitForAjaxRequests();
            return;
        }
        AjaxRequestManager a3 = new AjaxRequestManager(this.driver);
        a3.watchAjaxRequests();
        this.driver.findElement(By.id((String)TREE_PATH_ID)).findElement(By.linkText((String)"/")).findElement(By.xpath((String)EXPAND_XPATH)).click();
        a3.waitForAjaxRequests();
        String[] pathArray = path.substring(1).split("/");
        for (i = 0; i < pathArray.length - 1; ++i) {
            a = new AjaxRequestManager(this.driver);
            a.watchAjaxRequests();
            this.driver.findElement(By.id((String)TREE_PATH_ID)).findElement(By.linkText((String)pathArray[i])).findElement(By.xpath((String)EXPAND_XPATH)).click();
            a.waitForAjaxRequests();
        }
        a = new AjaxRequestManager(this.driver);
        a.watchAjaxRequests();
        this.driver.findElement(By.id((String)TREE_PATH_ID)).findElement(By.linkText((String)pathArray[i])).click();
        a.waitForAjaxRequests();
        AbstractPage.closeFancyBox();
        Locator.waitUntilGivenFunction(new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver driver) {
                try {
                    WebElement btn = driver.findElement(By.id((String)"fancybox-overlay"));
                    return !btn.isDisplayed() || !btn.isEnabled();
                }
                catch (NoSuchElementException e) {
                    return false;
                }
            }
        });
    }

    public void deselectPath(String path) {
        assert (path != null && !path.isEmpty());
        int lastPartIndex = path.lastIndexOf(47);
        String folderName = path.substring(lastPartIndex + 1);
        AjaxRequestManager a = new AjaxRequestManager(this.driver);
        a.watchAjaxRequests();
        DefaultSearchSubPage.findElementWaitUntilEnabledAndClick(this.selectPathDiv, By.xpath((String)("descendant::label[contains(text(),'" + folderName + "')]/ancestor::span[@class='sticker']/a")));
        a.waitForAjaxRequests();
    }

    public void selectCollections(String[] collections) {
        Select2WidgetElement collectionsWidget = new Select2WidgetElement(this.driver, this.driver.findElement(By.xpath((String)S2_COLLECTION_XPATH)), true);
        collectionsWidget.selectValues(collections);
    }

    public List<String> getSelectedCollections() {
        Select2WidgetElement collectionsWidget = new Select2WidgetElement(this.driver, this.driver.findElement(By.xpath((String)S2_COLLECTION_XPATH)), true);
        ArrayList<String> result = new ArrayList<String>();
        for (WebElement el : collectionsWidget.getSelectedValues()) {
            result.add(el.getText());
        }
        return result;
    }
}

