/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.tabs;

import java.util.List;
import org.nuxeo.functionaltests.AbstractTest;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.contentView.ContentViewElement;
import org.nuxeo.functionaltests.pages.DocumentBasePage;
import org.nuxeo.functionaltests.pages.forms.TopicCreationFormPage;
import org.nuxeo.functionaltests.pages.tabs.TopicTabSubPage;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class ForumTabSubPage
extends DocumentBasePage {
    @FindBy(xpath="//a[@id='nxw_newForumThread_form:nxw_newForumThread']")
    public WebElement newTopicButtonLink;
    @Required
    @FindBy(id="forum_content")
    WebElement forumContentForm;

    public ForumTabSubPage(WebDriver driver) {
        super(driver);
    }

    protected ContentViewElement getElement() {
        return AbstractTest.getWebFragment(By.id((String)"cv_forum_content_0_panel"), ContentViewElement.class);
    }

    public List<WebElement> getChildTopicRows() {
        return this.getElement().getItems();
    }

    public TopicCreationFormPage getTopicCreatePage() {
        this.newTopicButtonLink.click();
        return this.asPage(TopicCreationFormPage.class);
    }

    public TopicTabSubPage createTopic(String topicTitle, String topicDescription, Boolean moderated, String ... usersOrGroups) {
        return this.getTopicCreatePage().createTopicDocument(topicTitle, topicDescription, moderated, usersOrGroups);
    }

    public boolean hasTopicLink(String title) {
        try {
            WebElement element = this.forumContentForm.findElement(By.linkText((String)title));
            return element != null;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public boolean hasNewTopicButton() {
        try {
            return this.newTopicButtonLink.isDisplayed();
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }
}

