/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.tabs;

import com.google.common.base.Function;
import java.io.File;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.functionaltests.AjaxRequestManager;
import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.ScreenshotTaker;
import org.nuxeo.functionaltests.WaitForJQueryAjaxOnLoading;
import org.nuxeo.functionaltests.forms.Select2WidgetElement;
import org.nuxeo.functionaltests.pages.AbstractPage;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

@WaitForJQueryAjaxOnLoading
public class PermissionsSubPage
extends AbstractPage {
    private static final Log log = LogFactory.getLog(PermissionsSubPage.class);
    @Required
    @FindBy(xpath="//div[contains(@class, 'jsLocalPermissions')]")
    WebElement localPermissions;
    @FindBy(xpath="//div[contains(@class, 'jsLocalPermissions')]/*/paper-button")
    WebElement newPermission;
    @FindBy(xpath="//paper-button[@id='block']")
    WebElement blockPermissions;
    @FindBy(xpath="//paper-button[@id='unblock']")
    WebElement unblockPermissions;

    public PermissionsSubPage(WebDriver driver) {
        super(driver);
    }

    @Deprecated
    public boolean hasPermissionForUser(String permission, String username) {
        return this.hasPermission(permission, username);
    }

    public boolean hasPermission(String permission, String userOrGroupName) {
        List elements = this.driver.findElements(By.xpath((String)"//div[contains(@class, 'acl-table-row effective')]"));
        boolean hasPermission = false;
        for (WebElement element : elements) {
            List names = element.findElements(By.xpath((String)".//span[contains(@class, 'tag')]"));
            List perms = element.findElements(By.className((String)"label"));
            if (names.size() <= 0 || perms.size() <= 0) continue;
            String title = ((WebElement)names.get(0)).getAttribute("title");
            String perm = ((WebElement)perms.get(0)).getText();
            if (!title.startsWith(userOrGroupName) || !permission.equalsIgnoreCase(perm)) continue;
            hasPermission = true;
            break;
        }
        return hasPermission;
    }

    @Deprecated
    public PermissionsSubPage grantPermissionForUser(String permission, String username) {
        return this.grantPermission(permission, username);
    }

    public PermissionsSubPage grantPermission(String permission, String userOrGroupName) {
        PermissionsSubPage.waitUntilEnabledAndClick(this.newPermission);
        WebElement addPermissionH2 = PermissionsSubPage.findElementWithTimeout(By.xpath((String)"//h2[text()='Add a Permission']"));
        WebElement popup = addPermissionH2.findElement(By.xpath((String)".."));
        Select2WidgetElement userSelection = new Select2WidgetElement(this.driver, popup.findElement(By.className((String)"select2-container")), false);
        userSelection.selectValue(userOrGroupName);
        popup.findElement(By.tagName((String)"iron-icon")).click();
        Locator.waitUntilGivenFunction((Function<WebDriver, Boolean>)((Function)input -> {
            try {
                WebElement el = popup.findElement(By.tagName((String)"paper-item"));
                return el.isDisplayed();
            }
            catch (NoSuchElementException e) {
                return false;
            }
        }));
        List elements = popup.findElements(By.tagName((String)"paper-item"));
        for (WebElement element : elements) {
            if (!permission.equalsIgnoreCase(element.getText())) continue;
            element.click();
            break;
        }
        ScreenshotTaker taker = new ScreenshotTaker();
        File screenShot = taker.takeScreenshot(this.driver, "PermissionSubPage-add-permission-");
        log.warn((Object)("Screenshot taken : " + screenShot.getAbsolutePath()));
        Locator.findElementWaitUntilEnabledAndClick(popup, By.xpath((String)".//paper-button[text()='Create']"));
        this.waitForPermissionAdded(permission, userOrGroupName);
        return this.asPage(PermissionsSubPage.class);
    }

    protected void waitForPermissionAdded(String permission, String userOrGroupName) {
        new AjaxRequestManager(this.driver).waitForJQueryRequests();
        Locator.waitUntilGivenFunction((Function<WebDriver, Boolean>)((Function)input -> this.hasPermission(permission, userOrGroupName)));
    }

    public PermissionsSubPage blockPermissions() {
        PermissionsSubPage.waitUntilEnabledAndClick(this.blockPermissions);
        Locator.waitUntilElementPresent(By.xpath((String)"//paper-button[@id='unblock']"));
        return this.asPage(PermissionsSubPage.class);
    }

    public PermissionsSubPage unblockPermissions() {
        PermissionsSubPage.waitUntilEnabledAndClick(this.unblockPermissions);
        Locator.waitUntilElementPresent(By.xpath((String)"//paper-button[@id='block']"));
        return this.asPage(PermissionsSubPage.class);
    }

    public PermissionsSubPage deletePermission(String permission, String userOrGroupName) {
        WebElement deleteButton = this.findDeleteButton(permission, userOrGroupName);
        if (deleteButton != null) {
            Locator.waitUntilEnabledAndClick(deleteButton);
            Locator.waitUntilElementPresent(By.xpath((String)"//h2[contains(text(), 'The following permission will be deleted')]"));
            PermissionsSubPage.findElementWaitUntilEnabledAndClick(By.xpath((String)"//paper-button[text()='Delete']"));
            Locator.waitUntilElementPresent(By.xpath((String)"//span[text()='Permission deleted.']"));
        }
        return this.asPage(PermissionsSubPage.class);
    }

    private WebElement findDeleteButton(String permission, String userOrGroupName) {
        List elements = this.driver.findElements(By.xpath((String)"//div[contains(@class, 'acl-table-row effective')]"));
        for (WebElement element : elements) {
            List names = element.findElements(By.xpath((String)".//span[contains(@class, 'tag')]"));
            List perms = element.findElements(By.className((String)"label"));
            if (names.size() <= 0 || perms.size() <= 0) continue;
            String title = ((WebElement)names.get(0)).getAttribute("title");
            String perm = ((WebElement)perms.get(0)).getText();
            if (!title.startsWith(userOrGroupName) || !permission.equalsIgnoreCase(perm)) continue;
            return element.findElement(By.xpath((String)".//paper-icon-button[@icon='delete']"));
        }
        return null;
    }

    public boolean hasNewPermissionButton() {
        try {
            PermissionsSubPage.waitUntilEnabled(this.newPermission);
            return true;
        }
        catch (NotFoundException e) {
            return false;
        }
    }
}

