/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.tabs;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.functionaltests.AjaxRequestManager;
import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.pages.AbstractPage;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class PublishTabSubPage
extends AbstractPage {
    @FindBy(xpath="//select[@id='publishTreeForm:publishSelectTreeName']")
    public WebElement selectTree;
    @FindBy(xpath="//select[contains(@id, 'publishTreeForm:j')]")
    public WebElement selectRendition;
    @FindBy(xpath="//div[@id='publishTreeForm:publishingInfoList']/table/tbody/tr")
    List<WebElement> publishingInfos;

    public PublishTabSubPage(WebDriver driver) {
        super(driver);
    }

    public PublishTabSubPage publish(String sectionTree, String rendtion, String sectionName) {
        this.selectItemInDropDownMenu(this.selectTree, sectionTree);
        this.selectItemInDropDownMenu(this.selectRendition, rendtion);
        int index = this.findTreeNodeIndex(sectionName);
        this.publishIemInPublishTreeForm(index);
        return this.asPage(PublishTabSubPage.class);
    }

    public List<WebElement> getPublishingInfos() {
        return this.publishingInfos;
    }

    public PublishTabSubPage unpublish(String sectionName, String version) {
        for (WebElement publishRow : this.getPublishingInfos()) {
            if (!StringUtils.isBlank((CharSequence)sectionName) && !this.matchSectionName(publishRow, sectionName) || !StringUtils.isBlank((CharSequence)version) && !this.matchVersion(publishRow, version)) continue;
            publishRow.findElement(By.linkText((String)"Unpublish")).click();
            return this.asPage(PublishTabSubPage.class);
        }
        return this;
    }

    public List<WebElement> getTreeNode() {
        return PublishTabSubPage.findElementsWithTimeout(By.xpath((String)"//div[@id='publishTreeForm:sectionTree'] //div[@class='rf-trn'] //span[@class='tipsyShow tipsyGravityS']"));
    }

    public void expandAll() {
        List<WebElement> expanders = this.getItemExpanderInPublishTreeForm();
        if (expanders.isEmpty()) {
            return;
        }
        for (WebElement expander : expanders) {
            Locator.waitUntilEnabledAndClick(expander);
        }
    }

    public void refreshPublicationTree() {
        AjaxRequestManager arm = new AjaxRequestManager(this.driver);
        arm.begin();
        PublishTabSubPage.findElementWaitUntilEnabledAndClick(By.xpath((String)"//a[contains(@id, 'publishTreeForm:j')]"));
        arm.end();
    }

    private boolean matchSectionName(WebElement publishRow, String sectionName) {
        String sectionNameXpath = String.format("./td/a[contains(text(),'%s')]", sectionName);
        try {
            return publishRow.findElement(By.xpath((String)sectionNameXpath)) != null;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    private boolean matchVersion(WebElement publishRow, String version) {
        String versionXpath = String.format("./td[text()='%s']", version);
        try {
            return publishRow.findElement(By.xpath((String)versionXpath)) != null;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    private int findTreeNodeIndex(String itemName) {
        List<WebElement> elements = this.getTreeNode();
        int index = 0;
        for (WebElement sub : elements) {
            if (sub.getText().equals(itemName)) {
                return index - 1;
            }
            ++index;
        }
        List<WebElement> expanders = this.getItemExpanderInPublishTreeForm();
        if (expanders.size() == 0) {
            return -1;
        }
        for (WebElement expander : expanders) {
            Locator.waitUntilEnabledAndClick(expander);
        }
        return this.findTreeNodeIndex(itemName);
    }

    private List<WebElement> getItemExpanderInPublishTreeForm() {
        return PublishTabSubPage.findElementsWithTimeout(By.xpath((String)"//div[@id='publishTreeForm:sectionTree'] //span[@class='rf-trn-hnd-colps rf-trn-hnd']"));
    }

    private void publishIemInPublishTreeForm(int index) {
        AjaxRequestManager arm = new AjaxRequestManager(this.driver);
        arm.begin();
        PublishTabSubPage.findElementWaitUntilEnabledAndClick(By.xpath((String)("//div[@id='publishTreeForm:sectionTree'] //a[contains(@id, 'publishRecursiveAdaptor." + index + ":publishCommandLink')]")));
        arm.end();
    }
}

