/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.tabs;

import com.google.common.base.Function;
import org.junit.Assert;
import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.contentView.ContentViewElement;
import org.nuxeo.functionaltests.fragment.AddAllToCollectionForm;
import org.nuxeo.functionaltests.pages.AbstractPage;
import org.nuxeo.functionaltests.pages.tabs.AbstractContentTabSubPage;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class ContentTabSubPage
extends AbstractContentTabSubPage {
    public static final String COPY = "Copy";
    public static final String PASTE = "Paste";
    @Deprecated
    public static final String DELETE = "Delete";
    public static final String ADD_TO_WORKLIST = "Add to Worklist";
    public static final String ADD_TO_COLLECTION = "Add to collection";
    @Required
    @FindBy(id="document_content")
    WebElement documentContentForm;
    @Required
    @FindBy(id="cv_document_content_0_panel")
    WebElement contentView;
    @FindBy(linkText="New")
    WebElement newButton;

    public ContentTabSubPage(WebDriver driver) {
        super(driver);
    }

    @Override
    protected WebElement getContentViewElement() {
        return this.contentView;
    }

    @Deprecated
    protected ContentViewElement getElement() {
        return this.getContentView();
    }

    public <T> T getDocumentCreatePage(String docType, Class<T> pageClassToProxy) {
        ContentTabSubPage.waitUntilEnabledAndClick(this.newButton);
        WebElement fancyBox = AbstractPage.getFancyBoxContent();
        WebElement link = fancyBox.findElement(By.linkText((String)docType));
        Assert.assertNotNull((Object)link);
        link.click();
        return this.asPage(pageClassToProxy);
    }

    @Deprecated
    protected void deleteSelectedDocuments() {
        this.getContentView().getSelectionActions().delete();
    }

    public ContentTabSubPage addToWorkList(String documentTitle) {
        return this.getContentView().selectByTitle(documentTitle).clickOnActionByTitle(ADD_TO_WORKLIST, ContentTabSubPage.class);
    }

    @Override
    public ContentTabSubPage removeAllDocuments() {
        return this.removeAllDocuments(ContentTabSubPage.class);
    }

    @Deprecated
    public ContentTabSubPage filterDocument(String filter, int expectedNbOfDisplayedResult, int timeout) {
        this.filterDocument(filter);
        Assert.assertEquals((long)expectedNbOfDisplayedResult, (long)this.getChildDocumentRows().size());
        return this.asPage(ContentTabSubPage.class);
    }

    @Override
    public ContentTabSubPage filterDocument(String filter) {
        return this.filterDocument(filter, ContentTabSubPage.class);
    }

    @Override
    public ContentTabSubPage clearFilter() {
        return this.clearFilter(ContentTabSubPage.class);
    }

    @Deprecated
    public ContentTabSubPage clearFilter(int expectedNbOfDisplayedResult, int timeout) {
        Locator.waitUntilEnabledAndClick(this.clearFilterButton);
        Locator.waitUntilGivenFunction((Function<WebDriver, Boolean>)((Function)driver -> {
            try {
                return this.getChildDocumentRows().size() == expectedNbOfDisplayedResult;
            }
            catch (NoSuchElementException | StaleElementReferenceException e) {
                return false;
            }
        }));
        return this.asPage(ContentTabSubPage.class);
    }

    public ContentTabSubPage selectByIndex(int ... indexes) {
        this.getContentView().selectByIndex(indexes);
        return this.asPage(ContentTabSubPage.class);
    }

    @Deprecated
    public ContentTabSubPage selectDocumentByTitles(String ... titles) {
        return this.selectByTitle(titles);
    }

    public ContentTabSubPage selectByTitle(String ... titles) {
        this.getContentView().selectByTitle(titles);
        return this.asPage(ContentTabSubPage.class);
    }

    public ContentTabSubPage copyByIndex(int ... indexes) {
        return this.getContentView().selectByIndex(indexes).clickOnActionByTitle(COPY, ContentTabSubPage.class);
    }

    public ContentTabSubPage copyByTitle(String ... titles) {
        return this.getContentView().selectByTitle(titles).clickOnActionByTitle(COPY, ContentTabSubPage.class);
    }

    public ContentTabSubPage paste() {
        return this.getContentView().getSelectionActions().clickOnActionByTitle(PASTE, ContentTabSubPage.class);
    }

    public AddAllToCollectionForm addToCollectionByIndex(int ... indexes) {
        this.getContentView().selectByIndex(indexes).clickOnActionByTitle(ADD_TO_COLLECTION);
        WebElement elt = AbstractPage.getFancyBoxContent();
        return this.getWebFragment(elt, AddAllToCollectionForm.class);
    }

    public boolean hasNewButton() {
        try {
            return this.newButton.isDisplayed();
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }
}

