/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.tabs;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.functionaltests.AjaxRequestManager;
import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.pages.AbstractPage;
import org.nuxeo.functionaltests.pages.tabs.WorkflowTabSubPage;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class SummaryTabSubPage
extends AbstractPage {
    private static final String COLLECTIONS_FORM_ID = "nxl_grid_summary_layout:nxw_summary_current_document_collections_form";
    public static final String WORKFLOW_START_BUTTON_XPATH = "//input[contains(@id, 'nxw_start_route_widget_start_route')]";
    public static final String WORKFLOW_SELECTOR_XPATH = "//select[contains(@id, 'nxw_start_route_widget')]";
    @FindBy(xpath="//input[contains(@id, 'nxw_start_route_widget_start_route')]")
    public WebElement startWorkflowBtn;
    @FindBy(xpath="//select[contains(@id, 'nxw_start_route_widget')]")
    public WebElement workflowSelector;
    @FindBy(xpath="//form[contains(@id, 'nxl_grid_summary_layout:nxw_summary_current_document_single_tasks')]")
    public WebElement workflowTasksForm;
    @FindBy(xpath="//div[@class='nxw_lastContributor']")
    public WebElement lastContributor;
    @FindBy(xpath="//div[@class='nxw_author']")
    public WebElement creator;
    @FindBy(xpath="//span[@id='nxl_grid_summary_layout:nxw_summary_current_document_dublincore_form:nxl_dublincore:nxw_created']")
    public WebElement createdAt;
    @FindBy(xpath="//span[@id='nxl_grid_summary_layout:nxw_summary_current_document_dublincore_form:nxl_dublincore:nxw_modified']")
    public WebElement lastModifiedAt;
    @FindBy(xpath="//span[@class[starts-with(.,'nxw_contributors_')]]")
    public List<WebElement> contributors;
    @FindBy(xpath="//form[@id='nxl_grid_summary_layout:nxw_summary_current_document_states_form']")
    public WebElement lifeCycleState;
    @Required
    @FindBy(xpath="//div[@class='publication_block']")
    public WebElement publicationBlock;
    @FindBy(xpath="//span[@class=\"versionNumber\"]")
    public WebElement versionNumberField;

    public SummaryTabSubPage(WebDriver driver) {
        super(driver);
    }

    public SummaryTabSubPage startDefaultWorkflow() {
        AjaxRequestManager a = new AjaxRequestManager(this.driver);
        a.watchAjaxRequests();
        this.selectItemInDropDownMenu(this.workflowSelector, "Serial document review");
        a.waitForAjaxRequests();
        Locator.waitUntilEnabledAndClick(this.startWorkflowBtn);
        return this.asPage(SummaryTabSubPage.class);
    }

    public SummaryTabSubPage startDefaultParallelWorkflow() {
        this.selectItemInDropDownMenu(this.workflowSelector, "Parallel document review");
        Locator.waitUntilEnabledAndClick(this.startWorkflowBtn);
        return this.asPage(SummaryTabSubPage.class);
    }

    public boolean workflowAlreadyStarted() {
        return SummaryTabSubPage.findElementWithTimeout(By.xpath((String)"//*[@id='nxl_grid_summary_layout:nxw_summary_document_route_form']")).getText().contains("review has been started");
    }

    public boolean openTaskForCurrentUser() {
        return SummaryTabSubPage.findElementWithTimeout(By.xpath((String)"//form[contains(@id, 'nxl_grid_summary_layout:nxw_summary_current_document_single_tasks')]")).getText().contains("Please accept or reject the document");
    }

    public boolean parallelOpenTaskForCurrentUser() {
        return SummaryTabSubPage.findElementWithTimeout(By.xpath((String)"//form[contains(@id, 'nxl_grid_summary_layout:nxw_summary_current_document_single_tasks')]")).getText().contains("Please give your opinion. Click on N/A if you have no advice.");
    }

    public WorkflowTabSubPage getWorkflow() {
        this.clickOnTabIfNotSelected("nxw_documentTabs_panel", "nxw_TAB_ROUTE_WORKFLOW");
        return this.asPage(WorkflowTabSubPage.class);
    }

    public boolean cantStartWorkflow() {
        return SummaryTabSubPage.findElementWithTimeout(By.xpath((String)"//form[contains(@id, 'nxl_grid_summary_layout:nxw_summary_document_route_form')]")).getText().contains("No workflow process can be started on this document.");
    }

    public String getCreator() {
        return this.creator.getText();
    }

    public String getLastContributor() {
        return this.lastContributor.getText();
    }

    public List<String> getContributors() {
        ArrayList<String> result = new ArrayList<String>();
        for (WebElement contributor : this.contributors) {
            result.add(contributor.getText());
        }
        return result;
    }

    public String getCurrentLifeCycleState() {
        return this.lifeCycleState.findElement(By.className((String)"sticker")).getText();
    }

    public boolean isCollectionsFormDisplayed() {
        try {
            this.driver.findElement(By.id((String)COLLECTIONS_FORM_ID));
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public int getCollectionCount() {
        return this.driver.findElement(By.id((String)COLLECTIONS_FORM_ID)).findElements(By.xpath((String)"div/span[@id='nxl_grid_summary_layout:nxw_summary_current_document_collections_form:collections']/span[@class='tag tagLink']")).size();
    }

    public boolean isPublished() {
        try {
            return this.publicationBlock.getText().contains("This document is published.");
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public boolean isAwaitingPublication() {
        try {
            return this.publicationBlock.getText().contains("This document is waiting for a publication approval.");
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public boolean hasApprovePublicationButton() {
        try {
            return this.publicationBlock.findElement(By.xpath((String)".//input[@value='Approve']")) != null;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public SummaryTabSubPage approvePublication() {
        Locator.findElementWaitUntilEnabledAndClick(this.publicationBlock, By.xpath((String)".//input[@value='Approve']"));
        return this.asPage(SummaryTabSubPage.class);
    }

    public boolean hasRejectPublicationComment() {
        try {
            return this.publicationBlock.findElement(By.xpath((String)".//*[contains(@name, 'rejectPublishingComment')]")) != null;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public boolean hasRejectPublicationButton() {
        try {
            return this.publicationBlock.findElement(By.xpath((String)".//input[@value='Reject']")) != null;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public void rejectPublication(String comment) {
        WebElement text = this.publicationBlock.findElement(By.xpath((String)".//*[contains(@name, 'rejectPublishingComment')]"));
        text.sendKeys(new CharSequence[]{comment});
        Locator.findElementWaitUntilEnabledAndClick(this.publicationBlock, By.xpath((String)".//input[@value='Reject']"));
    }

    public String getVersionNumberText() {
        return this.versionNumberField.getText();
    }
}

