/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.tabs;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import org.junit.Assert;
import org.nuxeo.functionaltests.AjaxRequestManager;
import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.forms.Select2WidgetElement;
import org.nuxeo.functionaltests.pages.AbstractPage;
import org.nuxeo.functionaltests.pages.DocumentBasePage;
import org.nuxeo.functionaltests.pages.tabs.SummaryTabSubPage;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class WorkflowTabSubPage
extends DocumentBasePage {
    @FindBy(xpath="//form[contains(@id, 'nxl_tasks_form')]")
    public WebElement workflowTasksForm;
    @FindBy(xpath="//select[contains(@id, 'nxw_validationOrReview')]")
    public WebElement reviewSelector;

    public WorkflowTabSubPage(WebDriver driver) {
        super(driver);
    }

    public void addWorkflowReviewer(String username) {
        Select2WidgetElement particpants = new Select2WidgetElement(this.driver, this.driver.findElement(By.xpath((String)"//div[contains(@id, 'nxw_participants_select2')]")), true);
        particpants.selectValue(username);
        this.selectItemInDropDownMenu(this.reviewSelector, "Simple Review");
    }

    public void addParallelWorkflowReviewer(String user) {
        Select2WidgetElement particpants = new Select2WidgetElement(this.driver, this.driver.findElement(By.xpath((String)"//div[contains(@id, 'nxw_participants_select2')]")), true);
        particpants.selectValue(user);
    }

    public void addParallelWorkflowEndDate() {
        DateFormat sdf = DateFormat.getDateInstance(2, Locale.ENGLISH);
        WebElement endDate = this.driver.findElement(By.xpath((String)"//input[contains(@id, 'nxw_end_dateInputDate')]"));
        endDate.sendKeys(new CharSequence[]{sdf.format(new Date())});
        Assert.assertTrue((boolean)endDate.getAttribute("value").equals(sdf.format(new Date())));
    }

    public void showGraphView() {
        AjaxRequestManager arm = new AjaxRequestManager(this.driver);
        arm.begin();
        WorkflowTabSubPage.findElementWaitUntilEnabledAndClick(By.linkText((String)"Show Graph View"));
        arm.end();
        AbstractPage.getFancyBoxContent();
        Locator.waitUntilElementPresent(By.id((String)"fancybox-close"));
        Locator.waitUntilElementPresent(By.id((String)"jsPlumb_1_6"));
    }

    public void closeGraphView() {
        AbstractPage.closeFancyBox();
    }

    public void startWorkflow() {
        WorkflowTabSubPage.findElementWaitUntilEnabledAndClick(By.xpath((String)"//input[@value='Start the Review']"));
    }

    public void endTask(String taskName, String comment) {
        WorkflowTabSubPage.findElementAndWaitUntilEnabled(By.tagName((String)"textarea")).sendKeys(new CharSequence[]{comment});
        WorkflowTabSubPage.findElementWaitUntilEnabledAndClick(By.xpath((String)String.format("//input[@value='%s']", taskName)));
    }

    public void endTask(String taskName) {
        WorkflowTabSubPage.findElementWaitUntilEnabledAndClick(By.xpath((String)String.format("//input[@value='%s']", taskName)));
    }

    public <T> T endTask(String taskName, Class<T> pageClassToProxy) {
        this.endTask(taskName);
        return this.asPage(pageClassToProxy);
    }

    public WebElement getTaskLayoutNode() {
        return WorkflowTabSubPage.findElementWithTimeout(By.xpath((String)"//div[starts-with(@id, 'nxl_current_route_layout:nxw_current_route_user_tasks_panel')]"));
    }

    @Override
    public SummaryTabSubPage getSummaryTab() {
        this.clickOnDocumentTabLink(this.summaryTabLink);
        return this.asPage(SummaryTabSubPage.class);
    }
}

