/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update;

import java.util.EnumSet;

public enum PackageState {
    UNKNOWN(-1, "unknown"),
    REMOTE(0, "remote"),
    DOWNLOADING(1, "downloading"),
    DOWNLOADED(2, "downloaded"),
    INSTALLING(3, "installing"),
    INSTALLED(4, "installed"),
    STARTED(5, "started");

    private final int value;
    private final String label;

    private PackageState(int value, String label) {
        this.value = value;
        this.label = label;
    }

    @Deprecated
    public int getValue() {
        return this.value;
    }

    public String getLabel() {
        return this.label;
    }

    public static PackageState getByValue(int value) {
        for (PackageState element : EnumSet.allOf(PackageState.class)) {
            if (element.value != value) continue;
            return element;
        }
        return UNKNOWN;
    }

    public static PackageState getByValue(String value) throws NumberFormatException {
        return PackageState.getByValue(Integer.valueOf(value));
    }

    public static PackageState getByLabel(String label) {
        for (PackageState element : EnumSet.allOf(PackageState.class)) {
            if (!element.label.equals(label)) continue;
            return element;
        }
        return UNKNOWN;
    }

    public boolean isInstalled() {
        return this == INSTALLING || this == INSTALLED || this == STARTED;
    }

    public String toString() {
        return this.getLabel();
    }
}

