/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCLogger;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.TableImpl;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;
import org.nuxeo.ecm.directory.DirectoryException;

public class SQLHelper {
    private static final Log log = LogFactory.getLog(SQLHelper.class);
    private static final Object DIRECTORY_INIT_LOCK = new Object();
    private final Table table;
    private final String tableName;
    private final Connection connection;
    private final String policy;
    private JDBCLogger logger = new JDBCLogger("SQLDirectory");

    public SQLHelper(Connection connection, Table table, String policy) {
        this.table = table;
        this.connection = connection;
        this.policy = policy;
        this.tableName = table.getPhysicalName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setupTable() {
        log.debug((Object)String.format("setting up table '%s', policy='%s'", this.tableName, this.policy));
        if (this.policy.equals("never")) {
            log.debug((Object)"policy='never', skipping setup");
            return false;
        }
        Object object = DIRECTORY_INIT_LOCK;
        synchronized (object) {
            boolean tableExists = this.tableExists();
            if (this.policy.equals("on_missing_columns") && tableExists) {
                if (this.hasMatchingColumns()) {
                    log.debug((Object)"policy='on_missing_columns' and all column matched, skipping data load");
                } else {
                    log.debug((Object)"policy='on_missing_columns' and some columns are missing");
                    this.addMissingColumns();
                }
                return false;
            }
            this.createTable(tableExists);
            return true;
        }
    }

    private void addMissingColumns() {
        try (Statement stmt = this.connection.createStatement();){
            for (Column column : this.getMissingColumns(false)) {
                String alter = this.table.getAddColumnSql(column);
                if (this.logger.isLogEnabled()) {
                    this.logger.log(alter);
                }
                stmt.execute(alter);
            }
        }
        catch (SQLException e) {
            throw new DirectoryException(String.format("Table '%s' alteration failed: %s", this.table, e.getMessage()), (Throwable)e);
        }
    }

    private void createTable(boolean drop) {
        try (Statement stmt = this.connection.createStatement();){
            if (drop) {
                String dropSql = this.table.getDropSql();
                if (this.logger.isLogEnabled()) {
                    this.logger.log(dropSql);
                }
                stmt.execute(dropSql);
            }
            String createSql = this.table.getCreateSql();
            if (this.logger.isLogEnabled()) {
                this.logger.log(createSql);
            }
            stmt.execute(createSql);
            for (String sql : this.table.getPostCreateSqls(null)) {
                if (this.logger.isLogEnabled()) {
                    this.logger.log(sql);
                }
                stmt.execute(sql);
            }
        }
        catch (SQLException e) {
            throw new DirectoryException(String.format("Table '%s' creation failed: %s", this.table, e.getMessage()), (Throwable)e);
        }
    }

    public boolean hasMatchingColumns() {
        Set<Column> missingColumns = this.getMissingColumns(true);
        if (missingColumns == null || missingColumns.size() > 0) {
            return false;
        }
        log.debug((Object)String.format("all fields matched for table '%s'", this.tableName));
        return true;
    }

    public Set<Column> getMissingColumns(Boolean breakAtFirstMissing) {
        try {
            HashSet<Column> missingColumns = new HashSet<Column>();
            Set<String> columnNames = this.getPhysicalColumns();
            for (Column column : this.table.getColumns()) {
                String fieldName = column.getPhysicalName();
                if (columnNames.contains(fieldName)) continue;
                log.debug((Object)String.format("required field: %s is missing", fieldName));
                missingColumns.add(column);
                if (!breakAtFirstMissing.booleanValue()) continue;
                return null;
            }
            return missingColumns;
        }
        catch (SQLException e) {
            log.warn((Object)("error while introspecting table: " + this.tableName), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getPhysicalColumns() throws SQLException {
        ResultSet rs = null;
        HashSet<String> columnNames = new HashSet<String>();
        try {
            DatabaseMetaData metadata = this.connection.getMetaData();
            rs = metadata.getColumns(null, "%", this.tableName, "%");
            while (rs.next()) {
                columnNames.add(rs.getString("COLUMN_NAME"));
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    log.warn((Object)"Error while trying to close result set", (Throwable)e);
                }
            }
        }
        return columnNames;
    }

    private boolean tableExists() {
        boolean bl;
        block22: {
            DatabaseMetaData metaData = this.connection.getMetaData();
            String schemaName = null;
            String productName = metaData.getDatabaseProductName();
            if ("Oracle".equals(productName)) {
                try (Statement st = this.connection.createStatement();){
                    String sql = "SELECT SYS_CONTEXT('USERENV', 'SESSION_USER') FROM DUAL";
                    log.trace((Object)("SQL: " + sql));
                    try (ResultSet rs = st.executeQuery(sql);){
                        rs.next();
                        schemaName = rs.getString(1);
                        log.trace((Object)("checking existing tables for oracle database, schema: " + schemaName));
                    }
                }
            }
            ResultSet rs = metaData.getTables(null, schemaName, this.table.getPhysicalName(), new String[]{"TABLE"});
            try {
                boolean exists = rs.next();
                log.debug((Object)String.format("checking if table %s exists: %s", this.table.getPhysicalName(), exists));
                bl = exists;
                if (rs == null) break block22;
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new DirectoryException((Throwable)e);
                }
            }
            rs.close();
        }
        return bl;
    }

    public static Table addTable(String name, Dialect dialect, boolean nativeCase) {
        String physicalName = dialect.getTableName(name);
        if (!nativeCase && name.length() == physicalName.length()) {
            physicalName = name;
        }
        return new TableImpl(dialect, physicalName, physicalName);
    }

    public static Column addColumn(Table table, String fieldName, ColumnType type, boolean nativeCase) {
        String physicalName = table.getDialect().getColumnName(fieldName);
        if (!nativeCase && fieldName.length() == physicalName.length()) {
            physicalName = fieldName;
        }
        Column column = new Column(table, physicalName, type, fieldName);
        return ((TableImpl)table).addColumn(fieldName, column);
    }
}

