/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ConcurrentUpdateException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.OrderByExpr;
import org.nuxeo.ecm.core.query.sql.model.OrderByList;
import org.nuxeo.ecm.core.query.sql.model.QueryBuilder;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.storage.sql.ColumnSpec;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCLogger;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Delete;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Insert;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Select;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Update;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;
import org.nuxeo.ecm.core.utils.SIDGenerator;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.OperationNotAllowedException;
import org.nuxeo.ecm.directory.PasswordHelper;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.sql.SQLDirectory;
import org.nuxeo.ecm.directory.sql.SQLDirectoryDescriptor;
import org.nuxeo.ecm.directory.sql.SQLQueryBuilder;
import org.nuxeo.ecm.directory.sql.SQLStaticFilter;
import org.nuxeo.ecm.directory.sql.TableReference;
import org.nuxeo.ecm.directory.sql.filter.SQLComplexFilter;

public class SQLSession
extends BaseSession {
    private static final Log log = LogFactory.getLog(SQLSession.class);
    private static final boolean HIDE_PASSWORD_IN_LOGS = true;
    final Table table;
    protected SQLStaticFilter[] staticFilters;
    String sid;
    Connection sqlConnection;
    protected final Dialect dialect;
    protected JDBCLogger logger = new JDBCLogger("SQLDirectory");

    public SQLSession(SQLDirectory directory, SQLDirectoryDescriptor config) {
        super((Directory)directory, TableReference.class);
        this.table = directory.getTable();
        this.dialect = directory.getDialect();
        this.sid = String.valueOf(SIDGenerator.next());
        this.staticFilters = config.getStaticFilters();
        this.acquireConnection();
    }

    public SQLDirectory getDirectory() {
        return (SQLDirectory)this.directory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DocumentModel getEntryFromSource(String id, boolean fetchReferences) {
        this.acquireConnection();
        Select select = new Select(this.table);
        select.setFrom(this.table.getQuotedName());
        select.setWhat(this.getReadColumnsSQL());
        Object whereClause = this.table.getPrimaryColumn().getQuotedName() + " = ?";
        whereClause = this.addFilterWhereClause((String)whereClause);
        select.setWhere((String)whereClause);
        String sql = select.getStatement();
        if (this.logger.isLogEnabled()) {
            ArrayList<Serializable> values = new ArrayList<Serializable>();
            values.add((Serializable)((Object)id));
            this.addFilterValuesForLog(values);
            this.logger.logSQL(sql, values);
        }
        try (PreparedStatement ps = this.sqlConnection.prepareStatement(sql);){
            String entryTenantId;
            String tenantId;
            this.setFieldValue(ps, 1, this.table.getPrimaryColumn(), id);
            this.addFilterValues(ps, 2);
            HashMap<String, Object> fieldMap = new HashMap<String, Object>();
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) {
                    DocumentModel documentModel = null;
                    return documentModel;
                }
                for (Column column : this.getReadColumns()) {
                    Object object = this.getFieldValue(rs, column);
                    fieldMap.put(column.getKey(), object);
                }
                if (this.logger.isLogEnabled()) {
                    this.logger.logResultSet(rs, this.getReadColumns());
                }
            }
            if (this.isMultiTenant() && !StringUtils.isBlank((CharSequence)(tenantId = this.getCurrentTenantId())) && !StringUtils.isBlank((CharSequence)(entryTenantId = (String)fieldMap.get("tenantId"))) && !entryTenantId.equals(tenantId)) {
                Iterator<Object> iterator = null;
                return iterator;
            }
            DocumentModel entry = this.fieldMapToDocumentModel(fieldMap);
            if (fetchReferences) {
                HashMap targetIdsMap = new HashMap();
                for (Reference reference : this.directory.getReferences()) {
                    ArrayList targetIds = reference.getTargetIdsForSource(entry.getId());
                    targetIds = new ArrayList(targetIds);
                    Collections.sort(targetIds);
                    String fieldName = reference.getFieldName();
                    if (targetIdsMap.containsKey(fieldName)) {
                        ((List)targetIdsMap.get(fieldName)).addAll(targetIds);
                        continue;
                    }
                    targetIdsMap.put(fieldName, targetIds);
                }
                for (Map.Entry entry2 : targetIdsMap.entrySet()) {
                    String fieldName = (String)entry2.getKey();
                    List targetIds = (List)entry2.getValue();
                    try {
                        entry.setProperty(this.schemaName, fieldName, (Object)targetIds);
                    }
                    catch (PropertyException e) {
                        throw new DirectoryException((Throwable)e);
                    }
                }
            }
            DocumentModel documentModel = entry;
            return documentModel;
        }
        catch (SQLException e) {
            throw new DirectoryException("getEntry failed", (Throwable)e);
        }
    }

    protected List<Column> getReadColumns() {
        return this.readAllColumns ? this.getDirectory().readColumnsAll : this.getDirectory().readColumns;
    }

    protected String getReadColumnsSQL() {
        return this.readAllColumns ? this.getDirectory().readColumnsAllSQL : this.getDirectory().readColumnsSQL;
    }

    protected Column getIdColumn() {
        return this.getDirectory().idColumn;
    }

    protected DocumentModel fieldMapToDocumentModel(Map<String, Object> fieldMap) {
        String idFieldName = ((Field)this.directory.getSchemaFieldMap().get(this.getIdField())).getName().getPrefixedName();
        if (!fieldMap.containsKey(idFieldName)) {
            idFieldName = this.getIdField();
        }
        String id = String.valueOf(fieldMap.get(idFieldName));
        try {
            DocumentModel docModel = BaseSession.createEntryModel((String)this.sid, (String)this.schemaName, (String)id, fieldMap, (boolean)this.isReadOnly());
            return docModel;
        }
        catch (PropertyException e) {
            log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    private void acquireConnection() {
        try {
            if (this.sqlConnection == null || this.sqlConnection.isClosed()) {
                this.sqlConnection = this.getDirectory().getConnection();
            }
        }
        catch (SQLException e) {
            throw new DirectoryException("Cannot connect to SQL directory '" + this.directory.getName() + "': " + e.getMessage(), (Throwable)e);
        }
    }

    protected void checkConcurrentUpdate(Throwable e) throws ConcurrentUpdateException {
        if (this.dialect.isConcurrentUpdateException(e)) {
            throw new ConcurrentUpdateException(e);
        }
    }

    protected String addFilterWhereClause(String whereClause) {
        if (this.staticFilters.length == 0) {
            return whereClause;
        }
        whereClause = whereClause != null && ((String)whereClause).trim().length() > 0 ? (String)whereClause + " AND " : "";
        for (int i = 0; i < this.staticFilters.length; ++i) {
            SQLStaticFilter filter = this.staticFilters[i];
            whereClause = (String)whereClause + filter.getDirectoryColumn(this.table, this.getDirectory().useNativeCase()).getQuotedName();
            whereClause = (String)whereClause + " " + filter.getOperator() + " ";
            whereClause = (String)whereClause + "? ";
            if (i >= this.staticFilters.length - 1) continue;
            whereClause = (String)whereClause + " AND ";
        }
        return whereClause;
    }

    protected void addFilterWhereClause(StringBuilder clause, List<SQLQueryBuilder.ColumnAndValue> params) {
        if (this.staticFilters.length == 0) {
            return;
        }
        for (SQLStaticFilter filter : this.staticFilters) {
            if (clause.length() > 0) {
                clause.append(" AND ");
            }
            Column column = filter.getDirectoryColumn(this.table, this.getDirectory().useNativeCase());
            clause.append(column.getQuotedName());
            clause.append(" ");
            clause.append(filter.getOperator());
            clause.append(" ?");
            params.add(new SQLQueryBuilder.ColumnAndValue(column, (Serializable)((Object)filter.getValue())));
        }
    }

    protected void addFilterValues(PreparedStatement ps, int startIdx) {
        for (int i = 0; i < this.staticFilters.length; ++i) {
            SQLStaticFilter filter = this.staticFilters[i];
            this.setFieldValue(ps, startIdx + i, filter.getDirectoryColumn(this.table, this.getDirectory().useNativeCase()), filter.getValue());
        }
    }

    protected void addFilterValuesForLog(List<Serializable> values) {
        for (int i = 0; i < this.staticFilters.length; ++i) {
            values.add((Serializable)((Object)this.staticFilters[i].getValue()));
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected String getPassword(String id) {
        this.acquireConnection();
        Select select = new Select(this.table);
        select.setFrom(this.table.getQuotedName());
        ArrayList<Column> whatColumns = new ArrayList<Column>(2);
        whatColumns.add(this.table.getColumn(this.getPasswordField()));
        if (this.isMultiTenant()) {
            whatColumns.add(this.table.getColumn("tenantId"));
        }
        String what = whatColumns.stream().map(Column::getQuotedName).collect(Collectors.joining(", "));
        select.setWhat(what);
        Object whereClause = this.table.getPrimaryColumn().getQuotedName() + " = ?";
        whereClause = this.addFilterWhereClause((String)whereClause);
        select.setWhere((String)whereClause);
        String sql = select.getStatement();
        if (this.logger.isLogEnabled()) {
            ArrayList<Serializable> values = new ArrayList<Serializable>();
            values.add((Serializable)((Object)id));
            this.addFilterValuesForLog(values);
            this.logger.logSQL(sql, values);
        }
        try (PreparedStatement ps = this.sqlConnection.prepareStatement(sql);){
            String string;
            block25: {
                ResultSet rs;
                block23: {
                    String string2;
                    block24: {
                        String entryTenantId;
                        String tenantId;
                        block21: {
                            String string3;
                            block22: {
                                this.setFieldValue(ps, 1, this.table.getPrimaryColumn(), id);
                                this.addFilterValues(ps, 2);
                                rs = ps.executeQuery();
                                try {
                                    if (rs.next()) break block21;
                                    string3 = null;
                                    if (rs == null) break block22;
                                }
                                catch (Throwable throwable) {
                                    if (rs != null) {
                                        try {
                                            rs.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                rs.close();
                            }
                            return string3;
                        }
                        if (!this.isMultiTenant() || StringUtils.isBlank((CharSequence)(tenantId = this.getCurrentTenantId())) || StringUtils.isBlank((CharSequence)(entryTenantId = (String)this.getFieldValue(rs, this.table.getColumn("tenantId")))) || entryTenantId.equals(tenantId)) break block23;
                        string2 = null;
                        if (rs == null) break block24;
                        rs.close();
                    }
                    return string2;
                }
                String password = (String)this.getFieldValue(rs, this.table.getColumn(this.getPasswordField()));
                if (this.logger.isLogEnabled()) {
                    String value = "********";
                    this.logger.logMap(Collections.singletonMap(this.getPasswordField(), value));
                }
                string = password;
                if (rs == null) break block25;
                rs.close();
            }
            return string;
        }
        catch (SQLException e) {
            throw new DirectoryException("getPassword failed", (Throwable)e);
        }
    }

    public void deleteEntry(String id) {
        this.acquireConnection();
        if (!this.canDeleteMultiTenantEntry(id)) {
            throw new OperationNotAllowedException("Operation not allowed in the current tenant context", "label.directory.error.multi.tenant.operationNotAllowed", null);
        }
        super.deleteEntry(id);
    }

    public void deleteEntry(String id, Map<String, String> map) {
        this.checkPermission("Write");
        this.acquireConnection();
        if (!this.canDeleteMultiTenantEntry(id)) {
            throw new DirectoryException("Operation not allowed in the current tenant context");
        }
        Delete delete = new Delete(this.table);
        StringBuilder whereClause = new StringBuilder();
        ArrayList<String> values = new ArrayList<String>(1 + map.size());
        whereClause.append(this.table.getPrimaryColumn().getQuotedName());
        whereClause.append(" = ?");
        values.add(id);
        for (Map.Entry<String, String> e : map.entrySet()) {
            String key = e.getKey();
            String value = e.getValue();
            whereClause.append(" AND ");
            Column col = this.table.getColumn(key);
            if (col == null) {
                throw new IllegalArgumentException("Unknown column " + key);
            }
            whereClause.append(col.getQuotedName());
            if (value == null) {
                whereClause.append(" IS NULL");
                continue;
            }
            whereClause.append(" = ?");
            values.add(value);
        }
        delete.setWhere(whereClause.toString());
        String sql = delete.getStatement();
        if (this.logger.isLogEnabled()) {
            this.logger.logSQL(sql, values);
        }
        try (PreparedStatement ps = this.sqlConnection.prepareStatement(sql);){
            for (int i = 0; i < values.size(); ++i) {
                if (i == 0) {
                    this.setFieldValue(ps, 1, this.table.getPrimaryColumn(), values.get(i));
                    continue;
                }
                ps.setString(1 + i, (String)values.get(i));
            }
            ps.execute();
        }
        catch (SQLException e) {
            this.checkConcurrentUpdate(e);
            throw new DirectoryException("deleteEntry failed", (Throwable)e);
        }
        this.getDirectory().invalidateCaches();
    }

    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy, boolean fetchReferences, int limit, int offset) {
        DocumentModelListImpl documentModelListImpl;
        block74: {
            boolean manualLimitOffset;
            String where;
            Select select;
            String tenantId;
            if (!this.hasPermission("Read")) {
                return new DocumentModelListImpl();
            }
            this.acquireConnection();
            LinkedHashMap<String, Object> filterMap = new LinkedHashMap<String, Object>(filter);
            filterMap.remove(this.getPasswordField());
            if (this.isMultiTenant() && !StringUtils.isBlank((CharSequence)(tenantId = this.getCurrentTenantId()))) {
                filterMap.put("tenantId", (Serializable)((Object)tenantId));
            }
            StringBuilder whereClause = new StringBuilder();
            String separator = "";
            LinkedList<Column> orderedColumns = new LinkedList<Column>();
            for (String columnName : filterMap.keySet()) {
                Object operator;
                boolean substring;
                if (this.getDirectory().isReference(columnName)) {
                    log.warn((Object)(columnName + " is a reference and will be ignored as a query criterion"));
                    continue;
                }
                Object value = filterMap.get(columnName);
                Column column = this.table.getColumn(columnName);
                if (null == column) {
                    throw new DirectoryException("cannot find column '" + columnName + "' for table: " + this.table);
                }
                Object leftSide = column.getQuotedName();
                String rightSide = "?";
                boolean bl = substring = fulltext != null && fulltext.contains(columnName);
                if ("".equals(value) && this.dialect.hasNullEmptyString() && !substring) {
                    value = null;
                }
                if (value != null) {
                    if (value instanceof SQLComplexFilter) {
                        SQLComplexFilter complexFilter = (SQLComplexFilter)value;
                        operator = complexFilter.getOperator();
                        rightSide = complexFilter.getRightSide();
                    } else if (substring) {
                        String searchedValue = null;
                        switch (this.substringMatchType) {
                            case subany: {
                                searchedValue = "%" + String.valueOf(value).toLowerCase() + "%";
                                break;
                            }
                            case subinitial: {
                                searchedValue = String.valueOf(value).toLowerCase() + "%";
                                break;
                            }
                            case subfinal: {
                                searchedValue = "%" + String.valueOf(value).toLowerCase();
                            }
                        }
                        filterMap.put(columnName, searchedValue);
                        if (this.dialect.supportsIlike()) {
                            operator = " ILIKE ";
                        } else {
                            leftSide = "LOWER(" + (String)leftSide + ")";
                            operator = " LIKE ";
                        }
                    } else {
                        operator = " = ";
                    }
                } else {
                    operator = " IS NULL";
                }
                whereClause.append(separator).append((String)leftSide).append((String)operator);
                if (value != null) {
                    whereClause.append(rightSide);
                    orderedColumns.add(column);
                }
                separator = " AND ";
            }
            int queryLimitSize = this.getDirectory().getDescriptor().getQuerySizeLimit();
            boolean trucatedResults = false;
            if (queryLimitSize != 0 && (limit <= 0 || limit > queryLimitSize)) {
                int count;
                select = new Select(this.table);
                select.setWhat("count(*)");
                select.setFrom(this.table.getQuotedName());
                where = whereClause.toString();
                where = this.addFilterWhereClause(where);
                select.setWhere(where);
                String countQuery = select.getStatement();
                if (this.logger.isLogEnabled()) {
                    ArrayList<Serializable> values = new ArrayList<Serializable>(orderedColumns.size());
                    for (Column column : orderedColumns) {
                        Object value = filterMap.get(column.getKey());
                        values.add((Serializable)value);
                    }
                    this.addFilterValuesForLog(values);
                    this.logger.logSQL(countQuery, values);
                }
                try (PreparedStatement ps = this.sqlConnection.prepareStatement(countQuery);){
                    this.fillPreparedStatementFields(filterMap, orderedColumns, ps);
                    try (ResultSet rs = ps.executeQuery();){
                        rs.next();
                        count = rs.getInt(1);
                    }
                }
                if (this.logger.isLogEnabled()) {
                    this.logger.logCount(count);
                }
                if (count > queryLimitSize) {
                    trucatedResults = true;
                    limit = queryLimitSize;
                    log.error((Object)("Displayed results will be truncated because too many rows in result: " + count));
                }
            }
            select = new Select(this.table);
            select.setWhat(this.getReadColumnsSQL());
            select.setFrom(this.table.getQuotedName());
            where = whereClause.toString();
            where = this.addFilterWhereClause(where);
            select.setWhere(where);
            StringBuilder orderby = new StringBuilder(128);
            if (orderBy != null) {
                Iterator<Map.Entry<String, String>> it = orderBy.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, String> entry = it.next();
                    orderby.append(this.dialect.openQuote()).append(entry.getKey()).append(this.dialect.closeQuote()).append(' ').append(entry.getValue());
                    if (!it.hasNext()) continue;
                    orderby.append(',');
                }
            }
            select.setOrderBy(orderby.toString());
            String query = select.getStatement();
            if (limit <= 0) {
                manualLimitOffset = false;
            } else {
                if (offset < 0) {
                    offset = 0;
                }
                if (this.dialect.supportsPaging()) {
                    query = this.dialect.addPagingClause(query, (long)limit, (long)offset);
                    manualLimitOffset = false;
                } else {
                    manualLimitOffset = true;
                }
            }
            if (this.logger.isLogEnabled()) {
                ArrayList<Serializable> values = new ArrayList<Serializable>(orderedColumns.size());
                for (Column column : orderedColumns) {
                    Object value = filterMap.get(column.getKey());
                    values.add((Serializable)value);
                }
                this.addFilterValuesForLog(values);
                this.logger.logSQL(query, values);
            }
            PreparedStatement ps = this.sqlConnection.prepareStatement(query);
            try {
                this.fillPreparedStatementFields(filterMap, orderedColumns, ps);
                DocumentModelListImpl list = new DocumentModelListImpl();
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        for (Column column : this.getReadColumns()) {
                            Object o = this.getFieldValue(rs, column);
                            map.put(column.getKey(), o);
                        }
                        DocumentModel docModel = this.fieldMapToDocumentModel(map);
                        if (fetchReferences) {
                            HashMap<String, List> targetIdsMap = new HashMap<String, List>();
                            for (Reference reference : this.directory.getReferences()) {
                                List targetIds = reference.getTargetIdsForSource(docModel.getId());
                                String fieldName = reference.getFieldName();
                                if (targetIdsMap.containsKey(fieldName)) {
                                    ((List)targetIdsMap.get(fieldName)).addAll(targetIds);
                                    continue;
                                }
                                targetIdsMap.put(fieldName, targetIds);
                            }
                            for (Map.Entry entry : targetIdsMap.entrySet()) {
                                String fieldName = (String)entry.getKey();
                                List targetIds = (List)entry.getValue();
                                docModel.setProperty(this.schemaName, fieldName, (Object)targetIds);
                            }
                        }
                        list.add((Object)docModel);
                    }
                }
                if (manualLimitOffset) {
                    int totalSize = list.size();
                    if (offset > 0) {
                        list = offset >= totalSize ? new DocumentModelListImpl() : new DocumentModelListImpl(list.subList(offset, totalSize));
                    }
                    if (list.size() > limit) {
                        list = new DocumentModelListImpl(list.subList(0, limit));
                    }
                    list.setTotalSize((long)totalSize);
                }
                if (trucatedResults) {
                    list.setTotalSize(-2L);
                }
                documentModelListImpl = list;
                if (ps == null) break block74;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    try {
                        this.sqlConnection.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    throw new DirectoryException("query failed", (Throwable)e);
                }
            }
            ps.close();
        }
        return documentModelListImpl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DocumentModelList query(QueryBuilder queryBuilder, boolean fetchReferences) {
        if (!this.hasPermission("Read")) {
            return new DocumentModelListImpl();
        }
        if (BaseSession.FieldDetector.hasField((MultiExpression)queryBuilder.predicate(), (String)this.getPasswordField())) {
            throw new DirectoryException("Cannot filter on password");
        }
        queryBuilder = this.addTenantId(queryBuilder);
        SQLQueryBuilder builder = new SQLQueryBuilder(this.getDirectory());
        builder.visitMultiExpression(queryBuilder.predicate());
        this.addFilterWhereClause(builder.clause, builder.params);
        String whereClause = builder.clause.toString();
        int limit = Math.max(0, (int)queryBuilder.limit());
        int offset = Math.max(0, (int)queryBuilder.offset());
        boolean countTotal = queryBuilder.countTotal();
        try {
            int count;
            DocumentModelListImpl list;
            block48: {
                this.acquireConnection();
                Select select = new Select(this.table);
                select.setWhat(this.getReadColumnsSQL());
                select.setFrom(this.table.getQuotedName());
                select.setWhere(whereClause);
                StringBuilder orderBy = new StringBuilder();
                OrderByList orders = queryBuilder.orders();
                if (!orders.isEmpty()) {
                    for (OrderByExpr ob : orders) {
                        if (orderBy.length() != 0) {
                            orderBy.append(", ");
                        }
                        orderBy.append(this.dialect.openQuote());
                        orderBy.append(ob.reference.name);
                        orderBy.append(this.dialect.closeQuote());
                        if (!ob.isDescending) continue;
                        orderBy.append(" DESC");
                    }
                    select.setOrderBy(orderBy.toString());
                }
                String query = select.getStatement();
                if (limit != 0 || offset != 0) {
                    if (!this.dialect.supportsPaging()) {
                        throw new QueryParseException("Cannot use limit/offset, not supported by database");
                    }
                    query = this.dialect.addPagingClause(query, (long)limit, (long)offset);
                }
                if (this.logger.isLogEnabled()) {
                    List values = builder.params.stream().map(SQLQueryBuilder.ColumnAndValue::getValue).collect(Collectors.toList());
                    this.logger.logSQL(query, values);
                }
                list = new DocumentModelListImpl();
                try (PreparedStatement ps = this.sqlConnection.prepareStatement(query);){
                    int i = 1;
                    for (SQLQueryBuilder.ColumnAndValue columnAndValue : builder.params) {
                        this.setFieldValue(ps, i++, columnAndValue.column, columnAndValue.value);
                    }
                    try (ResultSet rs = ps.executeQuery();){
                        while (rs.next()) {
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            for (Column column : this.getReadColumns()) {
                                Iterator<Object> o = this.getFieldValue(rs, column);
                                map.put(column.getKey(), o);
                            }
                            DocumentModel docModel = this.fieldMapToDocumentModel(map);
                            if (fetchReferences) {
                                HashMap<String, List> targetIdsMap = new HashMap<String, List>();
                                for (Reference reference : this.directory.getReferences()) {
                                    List targetIds = reference.getTargetIdsForSource(docModel.getId());
                                    String fieldName = reference.getFieldName();
                                    targetIdsMap.computeIfAbsent(fieldName, key -> new ArrayList()).addAll(targetIds);
                                }
                                for (Map.Entry entry : targetIdsMap.entrySet()) {
                                    String fieldName = (String)entry.getKey();
                                    List targetIds = (List)entry.getValue();
                                    docModel.setProperty(this.schemaName, fieldName, (Object)targetIds);
                                }
                            }
                            list.add((Object)docModel);
                        }
                    }
                }
                if (limit == 0) {
                    if (offset == 0) return list;
                }
                if (countTotal) {
                    Select selectCount = new Select(this.table);
                    selectCount.setWhat("COUNT(*)");
                    selectCount.setFrom(this.table.getQuotedName());
                    selectCount.setWhere(whereClause);
                    String countQuery = selectCount.getStatement();
                    if (this.logger.isLogEnabled()) {
                        List values = builder.params.stream().map(SQLQueryBuilder.ColumnAndValue::getValue).collect(Collectors.toList());
                        this.logger.logSQL(countQuery, values);
                    }
                    try (PreparedStatement ps = this.sqlConnection.prepareStatement(countQuery);){
                        int i = 1;
                        for (SQLQueryBuilder.ColumnAndValue columnAndValue : builder.params) {
                            this.setFieldValue(ps, i++, columnAndValue.column, columnAndValue.value);
                        }
                        try (ResultSet rs = ps.executeQuery();){
                            rs.next();
                            count = rs.getInt(1);
                            if (this.logger.isLogEnabled()) {
                                this.logger.logCount(count);
                            }
                            break block48;
                        }
                    }
                }
                count = -2;
            }
            list.setTotalSize((long)count);
            return list;
        }
        catch (SQLException e) {
            try {
                this.sqlConnection.close();
                throw new DirectoryException("query failed", (Throwable)e);
            }
            catch (SQLException ee) {
                log.error((Object)ee, (Throwable)ee);
            }
            throw new DirectoryException("query failed", (Throwable)e);
        }
    }

    public List<String> queryIds(QueryBuilder queryBuilder) {
        if (!this.hasPermission("Read")) {
            return Collections.emptyList();
        }
        if (BaseSession.FieldDetector.hasField((MultiExpression)queryBuilder.predicate(), (String)this.getPasswordField())) {
            throw new DirectoryException("Cannot filter on password");
        }
        queryBuilder = this.addTenantId(queryBuilder);
        SQLQueryBuilder builder = new SQLQueryBuilder(this.getDirectory());
        builder.visitMultiExpression(queryBuilder.predicate());
        this.addFilterWhereClause(builder.clause, builder.params);
        String whereClause = builder.clause.toString();
        int limit = Math.max(0, (int)queryBuilder.limit());
        int offset = Math.max(0, (int)queryBuilder.offset());
        try {
            this.acquireConnection();
            Column idColumn = this.getIdColumn();
            Select select = new Select(this.table);
            select.setWhat(idColumn.getQuotedName());
            select.setFrom(this.table.getQuotedName());
            select.setWhere(whereClause);
            StringBuilder orderBy = new StringBuilder();
            OrderByList orders = queryBuilder.orders();
            if (!orders.isEmpty()) {
                for (OrderByExpr ob : orders) {
                    if (orderBy.length() != 0) {
                        orderBy.append(", ");
                    }
                    orderBy.append(this.dialect.openQuote());
                    orderBy.append(ob.reference.name);
                    orderBy.append(this.dialect.closeQuote());
                    if (!ob.isDescending) continue;
                    orderBy.append(" DESC");
                }
                select.setOrderBy(orderBy.toString());
            }
            String query = select.getStatement();
            if (limit != 0 || offset != 0) {
                if (!this.dialect.supportsPaging()) {
                    throw new QueryParseException("Cannot use limit/offset, not supported by database");
                }
                query = this.dialect.addPagingClause(query, (long)limit, (long)offset);
            }
            if (this.logger.isLogEnabled()) {
                List values = builder.params.stream().map(SQLQueryBuilder.ColumnAndValue::getValue).collect(Collectors.toList());
                this.logger.logSQL(query, values);
            }
            ArrayList<String> ids = new ArrayList<String>();
            try (PreparedStatement ps = this.sqlConnection.prepareStatement(query);){
                int i = 1;
                for (SQLQueryBuilder.ColumnAndValue columnAndValue : builder.params) {
                    this.setFieldValue(ps, i++, columnAndValue.column, columnAndValue.value);
                }
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        String id = String.valueOf(idColumn.getFromResultSet(rs, 1));
                        ids.add(id);
                    }
                }
            }
            return ids;
        }
        catch (SQLException e) {
            try {
                this.sqlConnection.close();
            }
            catch (SQLException ee) {
                log.error((Object)ee, (Throwable)ee);
            }
            throw new DirectoryException("query failed", (Throwable)e);
        }
    }

    protected DocumentModel createEntryWithoutReferences(Map<String, Object> fieldMap) {
        DocumentModel entry;
        fieldMap = new HashMap<String, Object>(fieldMap);
        Map schemaFieldMap = this.directory.getSchemaFieldMap();
        Field schemaIdField = (Field)schemaFieldMap.get(this.getIdField());
        String idFieldName = schemaIdField.getName().getPrefixedName();
        this.acquireConnection();
        if (this.autoincrementId) {
            fieldMap.remove(idFieldName);
        } else {
            String tenantId;
            Object rawId = fieldMap.get(idFieldName);
            if (rawId == null) {
                throw new DirectoryException("Missing id");
            }
            String id = String.valueOf(rawId);
            if (this.isMultiTenant() && !StringUtils.isBlank((CharSequence)(tenantId = this.getCurrentTenantId()))) {
                fieldMap.put("tenantId", tenantId);
                if (this.computeMultiTenantId) {
                    id = SQLSession.computeMultiTenantDirectoryId((String)tenantId, (String)id);
                    fieldMap.put(idFieldName, id);
                }
            }
            if (this.hasEntry(id)) {
                throw new DirectoryException(String.format("Entry with id %s already exists in directory %s", id, this.directory.getName()));
            }
        }
        ArrayList columnList = new ArrayList(this.table.getColumns());
        Column idColumn = null;
        Iterator i = columnList.iterator();
        while (i.hasNext()) {
            String prefixedName;
            Column column = (Column)i.next();
            if (column.isIdentity()) {
                idColumn = column;
            }
            if (fieldMap.containsKey(prefixedName = ((Field)schemaFieldMap.get(column.getKey())).getName().getPrefixedName())) continue;
            Field prefixedField = (Field)schemaFieldMap.get(prefixedName);
            if (prefixedField != null && prefixedField.getDefaultValue() != null) {
                fieldMap.put(prefixedName, prefixedField.getDefaultValue());
                continue;
            }
            i.remove();
        }
        Insert insert = new Insert(this.table);
        for (Column column : columnList) {
            insert.addColumn(column);
        }
        insert.addIdentityColumn(idColumn);
        String sql = insert.getStatement();
        if (this.logger.isLogEnabled()) {
            ArrayList<String> values = new ArrayList<String>(columnList.size());
            for (Column column : columnList) {
                String prefixField = ((Field)schemaFieldMap.get(column.getKey())).getName().getPrefixedName();
                Object value = fieldMap.get(prefixField);
                Object v = column.getKey().equals(this.getPasswordField()) ? "********" : this.fieldValueForWrite(value, column);
                values.add((String)v);
            }
            this.logger.logSQL(sql, values);
        }
        try (PreparedStatement ps = this.prepareStatementWithAutoKeys(sql);){
            int index = 1;
            for (Column column : columnList) {
                String prefixField = ((Field)schemaFieldMap.get(column.getKey())).getName().getPrefixedName();
                Object value = fieldMap.get(prefixField);
                this.setFieldValue(ps, index, column, value);
                ++index;
            }
            ps.execute();
            if (this.autoincrementId) {
                Column column = this.table.getColumn(this.getIdField());
                if (this.dialect.hasIdentityGeneratedKey()) {
                    try (ResultSet rs = ps.getGeneratedKeys();){
                        this.setIdFieldInMap(rs, column, idFieldName, fieldMap);
                    }
                }
                sql = this.dialect.getIdentityGeneratedKeySql(column);
                try (Statement st = this.sqlConnection.createStatement();
                     ResultSet rs = st.executeQuery(sql);){
                    this.setIdFieldInMap(rs, column, idFieldName, fieldMap);
                }
            }
            entry = this.fieldMapToDocumentModel(fieldMap);
        }
        catch (SQLException e) {
            this.checkConcurrentUpdate(e);
            throw new DirectoryException("createEntry failed", (Throwable)e);
        }
        return entry;
    }

    protected void setIdFieldInMap(ResultSet rs, Column column, String idFieldName, Map<String, Object> fieldMap) throws SQLException {
        if (!rs.next()) {
            throw new DirectoryException("Cannot get generated key");
        }
        if (this.logger.isLogEnabled()) {
            this.logger.logResultSet(rs, Collections.singletonList(column));
        }
        Serializable rawId = column.getFromResultSet(rs, 1);
        fieldMap.put(idFieldName, rawId);
    }

    protected PreparedStatement prepareStatementWithAutoKeys(String sql) throws SQLException {
        if (this.autoincrementId && this.dialect.hasIdentityGeneratedKey()) {
            return this.sqlConnection.prepareStatement(sql, new String[]{this.getIdField()});
        }
        return this.sqlConnection.prepareStatement(sql);
    }

    protected List<String> updateEntryWithoutReferences(DocumentModel docModel) {
        String entryTenantId;
        Object tenantId;
        this.acquireConnection();
        LinkedList<Column> storedColumnList = new LinkedList<Column>();
        LinkedList<String> referenceFieldList = new LinkedList<String>();
        if (this.isMultiTenant() && !StringUtils.isBlank((CharSequence)(tenantId = this.getCurrentTenantId())) && (StringUtils.isBlank((CharSequence)(entryTenantId = (String)docModel.getProperty(this.schemaName, "tenantId"))) || !entryTenantId.equals(tenantId))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Trying to update entry '%s' not part of current tenant '%s'", docModel.getId(), tenantId));
            }
            throw new OperationNotAllowedException("Operation not allowed in the current tenant context", "label.directory.error.multi.tenant.operationNotAllowed", null);
        }
        for (String fieldName : this.directory.getSchemaFieldMap().keySet()) {
            Property prop;
            if (fieldName.equals(this.getIdField()) || !(prop = docModel.getPropertyObject(this.schemaName, fieldName)).isDirty() || fieldName.equals(this.getPasswordField()) && StringUtils.isEmpty((CharSequence)((String)((Object)prop.getValue())))) continue;
            if (this.getDirectory().isReference(fieldName)) {
                referenceFieldList.add(fieldName);
                continue;
            }
            storedColumnList.add(this.table.getColumn(fieldName));
        }
        if (!storedColumnList.isEmpty()) {
            Update update = new Update(this.table);
            update.setUpdatedColumns(storedColumnList);
            String whereString = this.table.getPrimaryColumn().getQuotedName() + " = ?";
            update.setWhere(whereString);
            String sql = update.getStatement();
            if (this.logger.isLogEnabled()) {
                ArrayList<Object> values = new ArrayList<Object>(storedColumnList.size());
                for (Column column : storedColumnList) {
                    Object value = docModel.getProperty(this.schemaName, column.getKey());
                    if (column.getKey().equals(this.getPasswordField())) {
                        value = "********";
                    }
                    values.add((Serializable)value);
                }
                values.add(docModel.getId());
                this.logger.logSQL(sql, values);
            }
            try (PreparedStatement ps = this.sqlConnection.prepareStatement(sql);){
                int index = 1;
                for (Column column : storedColumnList) {
                    Object value = docModel.getProperty(this.schemaName, column.getKey());
                    this.setFieldValue(ps, index, column, value);
                    ++index;
                }
                this.setFieldValue(ps, index, this.table.getPrimaryColumn(), docModel.getId());
                ps.execute();
            }
            catch (SQLException e) {
                this.checkConcurrentUpdate(e);
                throw new DirectoryException("updateEntry failed for " + docModel.getId(), (Throwable)e);
            }
        }
        return referenceFieldList;
    }

    public void deleteEntryWithoutReferences(String id) {
        Delete delete = new Delete(this.table);
        String whereString = this.table.getPrimaryColumn().getQuotedName() + " = ?";
        delete.setWhere(whereString);
        String sql = delete.getStatement();
        if (this.logger.isLogEnabled()) {
            this.logger.logSQL(sql, Collections.singleton(id));
        }
        try (PreparedStatement ps = this.sqlConnection.prepareStatement(sql);){
            this.setFieldValue(ps, 1, this.table.getPrimaryColumn(), id);
            ps.execute();
        }
        catch (SQLException e) {
            this.checkConcurrentUpdate(e);
            throw new DirectoryException("deleteEntry failed", (Throwable)e);
        }
    }

    protected void fillPreparedStatementFields(Map<String, Object> filterMap, List<Column> orderedColumns, PreparedStatement ps) {
        int index = 1;
        for (Column column : orderedColumns) {
            Object value = filterMap.get(column.getKey());
            if (value instanceof SQLComplexFilter) {
                index = ((SQLComplexFilter)value).setFieldValue(ps, index, column);
                continue;
            }
            this.setFieldValue(ps, index, column, value);
            ++index;
        }
        this.addFilterValues(ps, index);
    }

    private Object getFieldValue(ResultSet rs, Column column) {
        try {
            int index = rs.findColumn(column.getPhysicalName());
            return column.getFromResultSet(rs, index);
        }
        catch (SQLException e) {
            throw new DirectoryException("getFieldValue failed", (Throwable)e);
        }
    }

    private void setFieldValue(PreparedStatement ps, int index, Column column, Object value) {
        try {
            column.setToPreparedStatement(ps, index, this.fieldValueForWrite(value, column));
        }
        catch (SQLException e) {
            throw new DirectoryException("setFieldValue failed", (Throwable)e);
        }
    }

    protected Serializable fieldValueForWrite(Object value, Column column) {
        ColumnSpec spec = column.getType().spec;
        if (value instanceof String) {
            if (spec == ColumnSpec.LONG || spec == ColumnSpec.AUTOINC) {
                return Long.valueOf((String)value);
            }
            if (column.getKey().equals(this.getPasswordField())) {
                String password = (String)value;
                if (!PasswordHelper.isHashed((String)password)) {
                    password = PasswordHelper.hashPassword((String)password, (String)this.passwordHashAlgorithm);
                }
                return password;
            }
        } else if (value instanceof Number) {
            if (spec == ColumnSpec.LONG || spec == ColumnSpec.AUTOINC) {
                if (value instanceof Integer) {
                    return Long.valueOf(((Integer)value).longValue());
                }
            } else if (spec == ColumnSpec.STRING) {
                return value.toString();
            }
        }
        return (Serializable)value;
    }

    public void close() {
        try {
            if (!this.sqlConnection.isClosed()) {
                this.sqlConnection.close();
            }
        }
        catch (SQLException e) {
            throw new DirectoryException("close failed", (Throwable)e);
        }
        finally {
            this.getDirectory().removeSession((Session)this);
        }
    }

    public boolean isLive() {
        try {
            return !this.sqlConnection.isClosed();
        }
        catch (SQLException e) {
            throw new DirectoryException("Cannot check connection status of " + this, (Throwable)e);
        }
    }

    public boolean authenticate(String username, String password) {
        String storedPassword = this.getPassword(username);
        return PasswordHelper.verifyPassword((String)password, (String)storedPassword);
    }

    public boolean isAuthenticating() {
        return this.directory.getSchemaFieldMap().containsKey(this.getPasswordField());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean hasEntry(String id) {
        this.acquireConnection();
        Select select = new Select(this.table);
        select.setFrom(this.table.getQuotedName());
        select.setWhat("1");
        select.setWhere(this.table.getPrimaryColumn().getQuotedName() + " = ?");
        String sql = select.getStatement();
        if (this.logger.isLogEnabled()) {
            this.logger.logSQL(sql, Collections.singleton(id));
        }
        try (PreparedStatement ps = this.sqlConnection.prepareStatement(sql);){
            boolean bl;
            block16: {
                this.setFieldValue(ps, 1, this.table.getPrimaryColumn(), id);
                ResultSet rs = ps.executeQuery();
                try {
                    boolean has = rs.next();
                    if (this.logger.isLogEnabled()) {
                        this.logger.logCount(has ? 1 : 0);
                    }
                    bl = has;
                    if (rs == null) break block16;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
        catch (SQLException e) {
            throw new DirectoryException("hasEntry failed", (Throwable)e);
        }
    }

    public String toString() {
        return "SQLSession [directory=" + this.directory.getName() + ", sid=" + this.sid + "]";
    }
}

