/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.SchemaImpl;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.StringType;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Delete;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Insert;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Select;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;
import org.nuxeo.ecm.directory.AbstractReference;
import org.nuxeo.ecm.directory.DirectoryCSVLoader;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.ReferenceDescriptor;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.sql.SQLDirectory;
import org.nuxeo.ecm.directory.sql.SQLHelper;
import org.nuxeo.ecm.directory.sql.SQLSession;
import org.nuxeo.ecm.directory.sql.TableReferenceDescriptor;

public class TableReference
extends AbstractReference {
    protected String tableName;
    protected String sourceColumn;
    protected String targetColumn;
    protected String dataFileName;
    private Table table;

    public TableReference(String fieldName, String directory, String tableName, String sourceColumn, String targetColumn, String dataFileName) {
        super(fieldName, directory);
        this.tableName = tableName;
        this.sourceColumn = sourceColumn;
        this.targetColumn = targetColumn;
        this.dataFileName = dataFileName;
    }

    public TableReference(TableReferenceDescriptor descriptor) {
        this(descriptor.getFieldName(), descriptor.getTargetDirectoryName(), descriptor.getTableName(), descriptor.getSourceColumn(), descriptor.getTargetColumn(), descriptor.getDataFileName());
    }

    public TableReference(ReferenceDescriptor descriptor) {
        this(descriptor.getFieldName(), descriptor.getDirectory(), descriptor.getReferenceName(), descriptor.getSource(), descriptor.getTarget(), descriptor.getDataFileName());
    }

    protected void initialize(Connection connection) {
        SQLDirectory directory = (SQLDirectory)this.getSourceDirectory();
        Dialect dialect = directory.getDialect();
        boolean nativeCase = directory.useNativeCase();
        this.table = SQLHelper.addTable(this.tableName, dialect, nativeCase);
        SQLHelper.addColumn(this.table, this.sourceColumn, ColumnType.STRING, nativeCase);
        SQLHelper.addColumn(this.table, this.targetColumn, ColumnType.STRING, nativeCase);
        this.table.addIndex(null, Table.IndexType.MAIN_NON_PRIMARY, new String[]{this.sourceColumn});
        SQLHelper helper = new SQLHelper(connection, this.table, directory.getDescriptor().getCreateTablePolicy());
        boolean loadData = helper.setupTable();
        if (loadData && this.dataFileName != null) {
            SchemaImpl schema = new SchemaImpl(this.tableName, null);
            schema.addField(this.sourceColumn, (Type)StringType.INSTANCE, null, 0, Collections.emptySet());
            schema.addField(this.targetColumn, (Type)StringType.INSTANCE, null, 0, Collections.emptySet());
            Insert insert = new Insert(this.table);
            for (Column column : this.table.getColumns()) {
                insert.addColumn(column);
            }
            try (final PreparedStatement ps = connection.prepareStatement(insert.getStatement());){
                Consumer<Map<String, Object>> loader = new Consumer<Map<String, Object>>(){

                    @Override
                    public void accept(Map<String, Object> map) {
                        try {
                            ps.setString(1, (String)map.get(TableReference.this.sourceColumn));
                            ps.setString(2, (String)map.get(TableReference.this.targetColumn));
                            ps.execute();
                        }
                        catch (SQLException e) {
                            throw new DirectoryException((Throwable)e);
                        }
                    }
                };
                DirectoryCSVLoader.loadData((String)this.dataFileName, (char)',', (Schema)schema, (Consumer)loader);
            }
            catch (SQLException e) {
                throw new DirectoryException(String.format("Table '%s' initialization failed", this.tableName), (Throwable)e);
            }
        }
    }

    public void addLinks(String sourceId, List<String> targetIds) {
        if (targetIds == null) {
            return;
        }
        try (SQLSession session = this.getSQLSession();){
            this.addLinks(sourceId, targetIds, (Session)session);
        }
    }

    public void addLinks(List<String> sourceIds, String targetId) {
        if (sourceIds == null) {
            return;
        }
        try (SQLSession session = this.getSQLSession();){
            this.addLinks(sourceIds, targetId, (Session)session);
        }
    }

    public void addLinks(String sourceId, List<String> targetIds, Session session) {
        if (targetIds == null) {
            return;
        }
        SQLSession sqlSession = (SQLSession)session;
        for (String targetId : targetIds) {
            this.addLink(sourceId, targetId, sqlSession, true);
        }
    }

    public void addLinks(List<String> sourceIds, String targetId, Session session) {
        if (sourceIds == null) {
            return;
        }
        SQLSession sqlSession = (SQLSession)session;
        for (String sourceId : sourceIds) {
            this.addLink(sourceId, targetId, sqlSession, true);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean exists(String sourceId, String targetId, SQLSession session) {
        Select select = new Select(this.table);
        select.setFrom(this.table.getQuotedName());
        select.setWhat("count(*)");
        String whereString = String.format("%s = ? and %s = ?", this.table.getColumn(this.sourceColumn).getQuotedName(), this.table.getColumn(this.targetColumn).getQuotedName());
        select.setWhere(whereString);
        String selectSql = select.getStatement();
        if (session.logger.isLogEnabled()) {
            session.logger.logSQL(selectSql, Arrays.asList(sourceId, targetId));
        }
        try (PreparedStatement ps = session.sqlConnection.prepareStatement(selectSql);){
            boolean bl;
            block15: {
                ps.setString(1, sourceId);
                ps.setString(2, targetId);
                ResultSet rs = ps.executeQuery();
                try {
                    rs.next();
                    boolean bl2 = bl = rs.getInt(1) > 0;
                    if (rs == null) break block15;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
        catch (SQLException e) {
            throw new DirectoryException(String.format("error reading link from %s to %s", sourceId, targetId), (Throwable)e);
        }
    }

    public void addLink(String sourceId, String targetId, SQLSession session, boolean checkExisting) {
        if (checkExisting && this.exists(sourceId, targetId, session)) {
            return;
        }
        Insert insert = new Insert(this.table);
        insert.addColumn(this.table.getColumn(this.sourceColumn));
        insert.addColumn(this.table.getColumn(this.targetColumn));
        String insertSql = insert.getStatement();
        if (session.logger.isLogEnabled()) {
            session.logger.logSQL(insertSql, Arrays.asList(sourceId, targetId));
        }
        try (PreparedStatement ps = session.sqlConnection.prepareStatement(insertSql);){
            ps.setString(1, sourceId);
            ps.setString(2, targetId);
            ps.execute();
        }
        catch (SQLException e) {
            throw new DirectoryException(String.format("error adding link from %s to %s", sourceId, targetId), (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    protected List<String> getIdsFor(String valueColumn, String filterColumn, String filterValue) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<String> getSourceIdsForTarget(String targetId) {
        return this.getIdsFor(this.sourceColumn, this.targetColumn, targetId);
    }

    public List<String> getTargetIdsForSource(String sourceId) {
        return this.getIdsFor(this.targetColumn, this.sourceColumn, sourceId);
    }

    public void removeLinksFor(String column, String entryId, SQLSession session) {
        String sql = String.format("DELETE FROM %s WHERE %s = ?", this.table.getQuotedName(), this.table.getColumn(column).getQuotedName());
        if (session.logger.isLogEnabled()) {
            session.logger.logSQL(sql, Collections.singleton(entryId));
        }
        try (PreparedStatement ps = session.sqlConnection.prepareStatement(sql);){
            ps.setString(1, entryId);
            ps.execute();
        }
        catch (SQLException e) {
            throw new DirectoryException("error remove links to " + entryId, (Throwable)e);
        }
    }

    public void removeLinksForSource(String sourceId, Session session) {
        SQLSession sqlSession = (SQLSession)session;
        this.removeLinksFor(this.sourceColumn, sourceId, sqlSession);
    }

    public void removeLinksForTarget(String targetId, Session session) {
        SQLSession sqlSession = (SQLSession)session;
        this.removeLinksFor(this.targetColumn, targetId, sqlSession);
    }

    public void removeLinksForSource(String sourceId) {
        try (SQLSession session = this.getSQLSession();){
            this.removeLinksForSource(sourceId, (Session)session);
        }
    }

    public void removeLinksForTarget(String targetId) {
        try (SQLSession session = this.getSQLSession();){
            this.removeLinksForTarget(targetId, (Session)session);
        }
    }

    public void setIdsFor(String idsColumn, List<String> ids, String filterColumn, String filterValue, SQLSession session) {
        block34: {
            LinkedList<String> idsToDelete = new LinkedList<String>();
            HashSet<String> idsToAdd = new HashSet<String>();
            if (ids != null) {
                idsToAdd.addAll(ids);
            }
            String selectSql = String.format("SELECT %s FROM %s WHERE %s = ?", this.table.getColumn(idsColumn).getQuotedName(), this.table.getQuotedName(), this.table.getColumn(filterColumn).getQuotedName());
            try (PreparedStatement ps = session.sqlConnection.prepareStatement(selectSql);){
                ps.setString(1, filterValue);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        String existingId = rs.getString(1);
                        if (idsToAdd.contains(existingId)) {
                            idsToAdd.remove(existingId);
                            continue;
                        }
                        idsToDelete.add(existingId);
                    }
                }
            }
            catch (SQLException e) {
                throw new DirectoryException("failed to fetch existing links for " + filterValue, (Throwable)e);
            }
            if (!idsToDelete.isEmpty()) {
                Delete delete = new Delete(this.table);
                String whereString = String.format("%s = ? AND %s = ?", this.table.getColumn(filterColumn).getQuotedName(), this.table.getColumn(idsColumn).getQuotedName());
                delete.setWhere(whereString);
                String deleteSql = delete.getStatement();
                try (PreparedStatement ps = session.sqlConnection.prepareStatement(deleteSql);){
                    for (String unwantedId : idsToDelete) {
                        if (session.logger.isLogEnabled()) {
                            session.logger.logSQL(deleteSql, Arrays.asList(filterValue, unwantedId));
                        }
                        ps.setString(1, filterValue);
                        ps.setString(2, unwantedId);
                        ps.execute();
                    }
                }
                catch (SQLException e) {
                    throw new DirectoryException("failed to remove unwanted links for " + filterValue, (Throwable)e);
                }
            }
            if (idsToAdd.isEmpty()) break block34;
            if (filterColumn.equals(this.sourceColumn)) {
                for (String missingId : idsToAdd) {
                    this.addLink(filterValue, missingId, session, false);
                }
            } else {
                for (String missingId : idsToAdd) {
                    this.addLink(missingId, filterValue, session, false);
                }
            }
        }
    }

    public void setSourceIdsForTarget(String targetId, List<String> sourceIds, SQLSession session) {
        this.setIdsFor(this.sourceColumn, sourceIds, this.targetColumn, targetId, session);
    }

    public void setTargetIdsForSource(String sourceId, List<String> targetIds, SQLSession session) {
        this.setIdsFor(this.targetColumn, targetIds, this.sourceColumn, sourceId, session);
    }

    public void setSourceIdsForTarget(String targetId, List<String> sourceIds) {
        try (SQLSession session = this.getSQLSession();){
            this.setSourceIdsForTarget(targetId, sourceIds, session);
        }
    }

    public void setSourceIdsForTarget(String targetId, List<String> sourceIds, Session session) {
        SQLSession sqlSession = (SQLSession)session;
        this.setSourceIdsForTarget(targetId, sourceIds, sqlSession);
    }

    public void setTargetIdsForSource(String sourceId, List<String> targetIds) {
        try (SQLSession session = this.getSQLSession();){
            this.setTargetIdsForSource(sourceId, targetIds, session);
        }
    }

    public void setTargetIdsForSource(String sourceId, List<String> targetIds, Session session) {
        SQLSession sqlSession = (SQLSession)session;
        this.setTargetIdsForSource(sourceId, targetIds, sqlSession);
    }

    protected SQLSession getSQLSession() {
        return (SQLSession)this.getSourceDirectory().getSession();
    }

    public String getSourceColumn() {
        return this.sourceColumn;
    }

    public String getTargetColumn() {
        return this.targetColumn;
    }

    public String getTargetDirectoryName() {
        return this.targetDirectoryName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDataFileName() {
        return this.dataFileName;
    }
}

