/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.naming.context;

import java.io.Serializable;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import org.apache.xbean.naming.context.ContextAccess;
import org.apache.xbean.naming.context.ContextUtil;
import org.apache.xbean.naming.context.NestedContextFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContext
implements Context,
NestedContextFactory,
Serializable {
    private static final long serialVersionUID = 6481918425692261483L;
    private final String nameInNamespace;
    private final Name parsedNameInNamespace;
    private final ContextAccess contextAccess;
    private final boolean modifiable;
    private final ThreadLocal<Name> inCall = new ThreadLocal();

    protected AbstractContext(String nameInNamespace) {
        this(nameInNamespace, ContextAccess.MODIFIABLE);
    }

    public AbstractContext(String nameInNamespace, ContextAccess contextAccess) {
        this.nameInNamespace = nameInNamespace;
        try {
            this.parsedNameInNamespace = this.getNameParser().parse(nameInNamespace);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        this.contextAccess = contextAccess;
        this.modifiable = contextAccess.isModifiable(this.getParsedNameInNamespace());
    }

    @Override
    public void close() throws NamingException {
    }

    protected ContextAccess getContextAccess() {
        return this.contextAccess;
    }

    protected Object getDeepBinding(String name) {
        return null;
    }

    protected Object getBinding(String name) throws NamingException {
        Map<String, Object> bindings = this.getBindings();
        return bindings.get(name);
    }

    protected Object lookup(String stringName, Name parsedName) throws NamingException {
        Object directLookup;
        if (stringName == null && parsedName == null) {
            throw new IllegalArgumentException("Both stringName and parsedName are null");
        }
        if (stringName == null) {
            stringName = parsedName.toString();
        }
        if ((directLookup = this.getDeepBinding(stringName)) != null) {
            return ContextUtil.resolve(directLookup, stringName, parsedName, this);
        }
        if (parsedName == null) {
            parsedName = this.getNameParser().parse(stringName);
        }
        if (parsedName.isEmpty()) {
            return this;
        }
        String firstNameElement = parsedName.get(0);
        Object localValue = firstNameElement.length() == 0 ? this : this.getBinding(firstNameElement);
        if (localValue != null) {
            if (parsedName.size() == 1) {
                localValue = ContextUtil.resolve(localValue, stringName, parsedName, this);
                return localValue;
            }
            if (localValue instanceof LinkRef) {
                LinkRef linkRef = (LinkRef)localValue;
                localValue = this.lookup(linkRef.getLinkName());
            }
            if (!(localValue instanceof Context)) {
                throw new NameNotFoundException(stringName);
            }
            return ((Context)localValue).lookup(parsedName.getSuffix(1));
        }
        Object value = this.faultLookup(stringName, parsedName);
        if (value != null) {
            return value;
        }
        if (parsedName.size() > 1) {
            throw new NotContextException(stringName);
        }
        throw new NameNotFoundException(stringName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object faultLookup(String stringName, Name parsedName) {
        if (!stringName.startsWith(this.nameInNamespace) && stringName.indexOf(58) > 0 && this.inCall.get() == null) {
            this.inCall.set(parsedName);
            try {
                InitialContext ctx = new InitialContext();
                Object object = ctx.lookup(parsedName);
                return object;
            }
            catch (NamingException namingException) {
            }
            finally {
                this.inCall.set(null);
            }
        }
        return null;
    }

    protected Context lookupFinalContext(Name name) throws NamingException {
        Object value;
        try {
            value = this.lookup(name.getPrefix(name.size() - 1));
        }
        catch (NamingException e) {
            throw new NotContextException("The intermediate context " + name.get(name.size() - 1) + " does not exist");
        }
        if (value == null) {
            throw new NotContextException("The intermediate context " + name.get(name.size() - 1) + " does not exist");
        }
        if (!(value instanceof Context)) {
            throw new NotContextException("The intermediate context " + name.get(name.size() - 1) + " is not a context");
        }
        return (Context)value;
    }

    protected abstract Map<String, Object> getBindings() throws NamingException;

    protected void addDeepBinding(Name name, Object value, boolean rebind, boolean createIntermediateContexts) throws NamingException {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null for name: " + name);
        }
        if (name.isEmpty()) {
            throw new InvalidNameException("Name is empty");
        }
        if (name.size() == 1) {
            this.addBinding(name.get(0), value, rebind);
            return;
        }
        if (!createIntermediateContexts) {
            Context context = this.lookupFinalContext(name);
            String lastSegment = name.get(name.size() - 1);
            this.addBinding(context, lastSegment, value, rebind);
        } else {
            Context currentContext = this;
            for (int i = 0; i < name.size(); ++i) {
                String part = name.get(i);
                if (part.length() == 0) {
                    throw new InvalidNameException("Name part " + i + " is empty: " + name);
                }
                if (i == name.size() - 1) {
                    this.addBinding(currentContext, part, value, rebind);
                    break;
                }
                Object currentValue = AbstractContext.getBinding(currentContext, part);
                if (currentValue == null) {
                    Context subcontext = this.createSubcontextTree(name.getPrefix(i).toString(), name.getSuffix(i), value);
                    this.addBinding(currentContext, part, subcontext, rebind);
                    break;
                }
                if (!(currentValue instanceof Context)) {
                    throw new NotContextException("Expected an instance of context to be bound at " + part + " but found an instance of " + currentValue.getClass().getName());
                }
                currentContext = (Context)currentValue;
            }
        }
    }

    private static Object getBinding(Context context, String name) {
        try {
            if (context instanceof AbstractContext) {
                AbstractContext abstractContext = (AbstractContext)context;
                return abstractContext.getBinding(name);
            }
            return context.lookup(name);
        }
        catch (NamingException e) {
            return null;
        }
    }

    protected void addBinding(Context context, String name, Object value, boolean rebind) throws NamingException {
        if (context == this || context instanceof AbstractContext && this.isNestedSubcontext(context)) {
            AbstractContext abstractContext = (AbstractContext)context;
            abstractContext.addBinding(name, value, rebind);
        } else if (rebind) {
            context.rebind(name, value);
        } else {
            context.bind(name, value);
        }
    }

    protected abstract boolean addBinding(String var1, Object var2, boolean var3) throws NamingException;

    protected Context createSubcontextTree(String path, Name name, Object value) throws NamingException {
        if (path == null) {
            throw new NullPointerException("path is null");
        }
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (name.size() < 2) {
            throw new InvalidNameException("name must have at least 2 parts " + name);
        }
        if (path.length() > 0 && !path.endsWith("/")) {
            path = path + "/";
        }
        for (int i = name.size() - 1; i > 0; --i) {
            String fullPath = path + name.getPrefix(i);
            String key = name.get(i);
            value = this.createNestedSubcontext(fullPath, Collections.singletonMap(key, value));
        }
        return (Context)value;
    }

    protected abstract boolean removeBinding(String var1, boolean var2) throws NamingException;

    protected void removeDeepBinding(Name name, boolean pruneEmptyContexts) throws NamingException {
        this.removeDeepBinding(name, pruneEmptyContexts, false);
    }

    protected void removeDeepBinding(Name name, boolean pruneEmptyContexts, boolean removeNotEmptyContext) throws NamingException {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (name.isEmpty()) {
            throw new InvalidNameException("Name is empty");
        }
        if (name.size() == 1) {
            this.removeBinding(name.get(0), removeNotEmptyContext);
            return;
        }
        if (!pruneEmptyContexts) {
            Context context = this.lookupFinalContext(name);
            context.unbind(name.getSuffix(name.size() - 1));
        } else {
            AbstractContext targetContext = this;
            String targetName = name.get(0);
            Context currentContext = this;
            for (int i = 0; i < name.size(); ++i) {
                String part = name.get(i);
                if (part.length() == 0) {
                    throw new InvalidNameException("Name part " + i + " is empty: " + name);
                }
                if (AbstractContext.getSize(currentContext) > 1) {
                    targetContext = currentContext;
                    targetName = part;
                }
                if (i == name.size() - 1) {
                    this.unbind(targetContext, targetName, true);
                    break;
                }
                Object currentValue = AbstractContext.getBinding(currentContext, part);
                if (currentValue == null) {
                    if (targetContext == currentContext) break;
                    this.unbind(targetContext, targetName, false);
                    break;
                }
                if (!(currentValue instanceof Context)) {
                    throw new NotContextException("Expected an instance of context to be bound at " + part + " but found an instance of " + currentValue.getClass().getName());
                }
                currentContext = (Context)currentValue;
            }
        }
    }

    protected static boolean isEmpty(Context context) throws NamingException {
        if (context instanceof AbstractContext) {
            AbstractContext abstractContext = (AbstractContext)context;
            Map<String, Object> currentBindings = abstractContext.getBindings();
            return currentBindings.isEmpty();
        }
        NamingEnumeration<NameClassPair> namingEnumeration = context.list("");
        return namingEnumeration.hasMore();
    }

    protected static int getSize(Context context) throws NamingException {
        if (context instanceof AbstractContext) {
            AbstractContext abstractContext = (AbstractContext)context;
            Map<String, Object> currentBindings = abstractContext.getBindings();
            return currentBindings.size();
        }
        NamingEnumeration<NameClassPair> namingEnumeration = context.list("");
        int size = 0;
        while (namingEnumeration.hasMore()) {
            ++size;
        }
        return size;
    }

    private void unbind(Context context, String name, boolean removeNotEmptyContext) throws NamingException {
        if (context == this || context instanceof AbstractContext && this.isNestedSubcontext(context)) {
            AbstractContext abstractContext = (AbstractContext)context;
            abstractContext.removeBinding(name, removeNotEmptyContext);
        } else {
            context.unbind(name);
        }
    }

    public Hashtable getEnvironment() {
        return new Hashtable();
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (propName == null) {
            throw new NullPointerException("propName is null");
        }
        if (propVal == null) {
            throw new NullPointerException("propVal is null");
        }
        Hashtable env = this.getEnvironment();
        return env.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        if (propName == null) {
            throw new NullPointerException("propName is null");
        }
        Hashtable env = this.getEnvironment();
        return env.remove(propName);
    }

    @Override
    public String getNameInNamespace() {
        return this.nameInNamespace;
    }

    protected Name getParsedNameInNamespace() {
        return this.parsedNameInNamespace;
    }

    protected String getNameInNamespace(String path) {
        String nameInNamespace = this.getNameInNamespace();
        if (nameInNamespace == null || nameInNamespace.length() == 0) {
            return path;
        }
        return nameInNamespace + "/" + path;
    }

    protected Name getNameInNamespace(Name path) throws NamingException {
        Name nameInNamespace = this.getParsedNameInNamespace();
        if (nameInNamespace == null || nameInNamespace.size() == 0) {
            return path;
        }
        return this.composeName(nameInNamespace, path);
    }

    protected NameParser getNameParser() {
        return ContextUtil.NAME_PARSER;
    }

    @Override
    public NameParser getNameParser(Name name) {
        return this.getNameParser();
    }

    @Override
    public NameParser getNameParser(String name) {
        return this.getNameParser();
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix is null");
        }
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix is null");
        }
        CompositeName result = new CompositeName(prefix);
        result.addAll(new CompositeName(name));
        return result.toString();
    }

    @Override
    public Object lookup(String name) throws NamingException {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        Object value = this.lookup(name, null);
        if (value instanceof LinkRef) {
            LinkRef linkRef = (LinkRef)value;
            value = this.lookup(linkRef.getLinkName());
        }
        return value;
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        Object value = this.lookup(null, name);
        if (value instanceof LinkRef) {
            LinkRef linkRef = (LinkRef)value;
            value = this.lookup(linkRef.getLinkName());
        }
        return value;
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        return this.lookup(name, null);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        return this.lookup(null, name);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        if (!this.modifiable) {
            throw new OperationNotSupportedException("Context is read only");
        }
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (name.length() == 0) {
            throw new NameAlreadyBoundException("Cannot bind to an empty name (this context)");
        }
        this.bind(new CompositeName(name), obj);
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        if (!this.modifiable) {
            throw new OperationNotSupportedException("Context is read only");
        }
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (name.isEmpty()) {
            throw new NameAlreadyBoundException("Cannot bind to an empty name (this context)");
        }
        this.addDeepBinding(name, obj, false, false);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        if (!this.modifiable) {
            throw new OperationNotSupportedException("Context is read only");
        }
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        this.rebind(new CompositeName(name), obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        if (!this.modifiable) {
            throw new OperationNotSupportedException("Context is read only");
        }
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (name.isEmpty()) {
            throw new NameAlreadyBoundException("Cannot rebind an empty name (this context)");
        }
        this.addDeepBinding(name, obj, true, false);
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        if (!this.modifiable) {
            throw new OperationNotSupportedException("Context is read only");
        }
        if (oldName == null) {
            throw new NullPointerException("oldName is null");
        }
        if (newName == null) {
            throw new NullPointerException("newName is null");
        }
        this.rename(new CompositeName(oldName), new CompositeName(newName));
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        if (!this.modifiable) {
            throw new OperationNotSupportedException("Context is read only");
        }
        if (oldName == null || newName == null) {
            throw new NullPointerException("name is null");
        }
        if (oldName.isEmpty() || newName.isEmpty()) {
            throw new NameAlreadyBoundException("Name cannot be empty");
        }
        this.bind(newName, this.lookup(oldName));
        this.unbind(oldName);
    }

    @Override
    public void unbind(String name) throws NamingException {
        if (!this.modifiable) {
            throw new OperationNotSupportedException("Context is read only");
        }
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        this.unbind(new CompositeName(name));
    }

    @Override
    public void unbind(Name name) throws NamingException {
        if (!this.modifiable) {
            throw new OperationNotSupportedException("Context is read only");
        }
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot unbind empty name");
        }
        this.removeDeepBinding(name, false);
    }

    protected NamingEnumeration<NameClassPair> list() throws NamingException {
        Map<String, Object> bindings = this.getBindings();
        return new ContextUtil.ListEnumeration(bindings);
    }

    protected NamingEnumeration<Binding> listBindings() throws NamingException {
        Map<String, Object> bindings = this.getBindings();
        return new ContextUtil.ListBindingEnumeration(bindings, this);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        Object target;
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (name.length() == 0) {
            return this.list();
        }
        try {
            target = this.lookup(name);
        }
        catch (NamingException e) {
            throw new NotContextException(name);
        }
        if (target == this) {
            return this.list();
        }
        if (target instanceof Context) {
            return ((Context)target).list("");
        }
        throw new NotContextException("The name " + name + " cannot be listed");
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        Object target;
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (name.isEmpty()) {
            return this.list();
        }
        try {
            target = this.lookup(name);
        }
        catch (NamingException e) {
            throw new NotContextException(name.toString());
        }
        if (target == this) {
            return this.list();
        }
        if (target instanceof Context) {
            return ((Context)target).list("");
        }
        throw new NotContextException("The name " + name + " cannot be listed");
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        Object target;
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (name.length() == 0) {
            return this.listBindings();
        }
        try {
            target = this.lookup(name);
        }
        catch (NamingException e) {
            throw new NotContextException(name);
        }
        if (target == this) {
            return this.listBindings();
        }
        if (target instanceof Context) {
            return ((Context)target).listBindings("");
        }
        throw new NotContextException("The name " + name + " cannot be listed");
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        Object target;
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (name.isEmpty()) {
            return this.listBindings();
        }
        try {
            target = this.lookup(name);
        }
        catch (NamingException e) {
            throw new NotContextException(name.toString());
        }
        if (target == this) {
            return this.listBindings();
        }
        if (target instanceof Context) {
            return ((Context)target).listBindings("");
        }
        throw new NotContextException("The name " + name + " cannot be listed");
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        if (!this.modifiable) {
            throw new OperationNotSupportedException("Context is read only");
        }
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        return this.createSubcontext(new CompositeName(name));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        if (!this.modifiable) {
            throw new OperationNotSupportedException("Context is read only");
        }
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (name.isEmpty()) {
            throw new NameAlreadyBoundException("Cannot create a subcontext if the name is empty");
        }
        Context abstractContext = this.createNestedSubcontext(name.toString(), Collections.EMPTY_MAP);
        this.addDeepBinding(name, abstractContext, false, false);
        return abstractContext;
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        if (!this.modifiable) {
            throw new OperationNotSupportedException("Context is read only");
        }
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        this.destroySubcontext(new CompositeName(name));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        if (!this.modifiable) {
            throw new OperationNotSupportedException("Context is read only");
        }
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot destroy subcontext with empty name");
        }
        this.unbind(name);
    }
}

