/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.extension;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.platform.rendition.extension.AutomationRenderer;
import org.nuxeo.ecm.platform.rendition.extension.RenditionProvider;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;
import org.nuxeo.runtime.api.Framework;

public class DefaultAutomationRenditionProvider
implements RenditionProvider {
    private static final Log log = LogFactory.getLog(DefaultAutomationRenditionProvider.class);
    public static final String VARIANT_POLICY_USER = "user";

    public boolean isAvailable(DocumentModel doc, RenditionDefinition def) {
        String chain = def.getOperationChain();
        if (chain == null) {
            log.error((Object)"Can not run Automation rendition if chain is not defined");
            return false;
        }
        AutomationService as = (AutomationService)Framework.getService(AutomationService.class);
        try {
            if (as.getOperation(chain) == null) {
                log.error((Object)("Chain " + chain + " is not defined : rendition can not be used"));
                return false;
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to test Rendition availability", (Throwable)e);
            return false;
        }
        if (!def.isEmptyBlobAllowed()) {
            BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
            if (bh == null) {
                return false;
            }
            try {
                Blob blob = bh.getBlob();
                if (blob == null) {
                    return false;
                }
            }
            catch (Exception e) {
                log.error((Object)"Unable to get Blob to test Rendition availability", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public List<Blob> render(DocumentModel doc, RenditionDefinition definition) {
        return AutomationRenderer.render(doc, definition, null);
    }

    public String getVariant(DocumentModel doc, RenditionDefinition definition) {
        if (VARIANT_POLICY_USER.equals(definition.getVariantPolicy())) {
            NuxeoPrincipal principal = doc.getCoreSession().getPrincipal();
            if (principal.isAdministrator()) {
                return "administratoruser:";
            }
            return "user:" + principal.getName();
        }
        return null;
    }
}

