/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.listener;

import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.PostCommitFilteringEventListener;
import org.nuxeo.ecm.platform.rendition.service.RenditionService;
import org.nuxeo.runtime.api.Framework;

public class StoredRenditionsCleanupListener
implements PostCommitFilteringEventListener {
    public static final String STORED_RENDITIONS_CLEANUP_EVENT = "storedRenditionsCleanup";

    public void handleEvent(EventBundle eventBundle) {
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
        RenditionService renditionService = (RenditionService)Framework.getService(RenditionService.class);
        for (String repositoryName : repositoryManager.getRepositoryNames()) {
            renditionService.deleteStoredRenditions(repositoryName);
        }
    }

    public boolean acceptEvent(Event event) {
        return STORED_RENDITIONS_CLEANUP_EVENT.equals(event.getName());
    }
}

