/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.service;

import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.rendition.impl.StoredRendition;
import org.nuxeo.ecm.platform.rendition.service.RenditionCreator;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;
import org.nuxeo.ecm.platform.rendition.service.RenditionFinder;
import org.nuxeo.ecm.platform.rendition.service.StoredRenditionManager;

public class DefaultStoredRenditionManager
implements StoredRenditionManager {
    @Override
    public StoredRendition createStoredRendition(DocumentModel liveDocument, DocumentModel versionDocument, Blob renditionBlob, RenditionDefinition renditionDefinition) {
        RenditionCreator rc = new RenditionCreator(liveDocument, versionDocument, renditionBlob, renditionDefinition);
        rc.runUnrestricted();
        DocumentModel storedDoc = rc.getDetachedRendition();
        String sessionId = liveDocument.getCoreSession().getSessionId();
        return this.toStoredRendition(storedDoc, renditionDefinition, sessionId);
    }

    @Override
    public StoredRendition findStoredRendition(DocumentModel sourceDocument, RenditionDefinition renditionDefinition) {
        RenditionFinder finder = new RenditionFinder(sourceDocument, renditionDefinition);
        finder.runUnrestricted();
        DocumentModel storedDoc = finder.getStoredRendition();
        String sessionId = sourceDocument.getCoreSession().getSessionId();
        return this.toStoredRendition(storedDoc, renditionDefinition, sessionId);
    }

    protected StoredRendition toStoredRendition(DocumentModel storedDoc, RenditionDefinition def, String sessionId) {
        if (storedDoc == null) {
            return null;
        }
        storedDoc.attach(sessionId);
        return new StoredRendition(storedDoc, def);
    }
}

