/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.ELActionContext;
import org.nuxeo.ecm.platform.actions.ejb.ActionManager;
import org.nuxeo.ecm.platform.rendition.extension.DefaultAutomationRenditionProvider;
import org.nuxeo.ecm.platform.rendition.extension.RenditionProvider;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class RenditionDefinitionRegistry
extends ContributionFragmentRegistry<RenditionDefinition> {
    private static final Log log = LogFactory.getLog(RenditionDefinitionRegistry.class);
    protected Map<String, RenditionDefinition> descriptors = new HashMap<String, RenditionDefinition>();

    public RenditionDefinition getRenditionDefinition(String name) {
        RenditionDefinition renditionDefinition = this.descriptors.get(name);
        if (renditionDefinition == null) {
            for (RenditionDefinition rd : this.descriptors.values()) {
                if (!name.equals(rd.getCmisName())) continue;
                renditionDefinition = rd;
                break;
            }
        }
        return renditionDefinition;
    }

    public List<RenditionDefinition> getRenditionDefinitions(DocumentModel doc) {
        ArrayList<RenditionDefinition> renditionDefinitions = new ArrayList<RenditionDefinition>();
        for (RenditionDefinition descriptor : this.descriptors.values()) {
            if (!this.canUseRenditionDefinition(descriptor, doc) || !descriptor.getProvider().isAvailable(doc, descriptor)) continue;
            renditionDefinitions.add(descriptor);
        }
        return renditionDefinitions;
    }

    protected boolean canUseRenditionDefinition(RenditionDefinition renditionDefinition, DocumentModel doc) {
        ActionManager actionService = (ActionManager)Framework.getService(ActionManager.class);
        return actionService.checkFilters(renditionDefinition.getFilterIds(), this.createActionContext(doc));
    }

    protected ActionContext createActionContext(DocumentModel doc) {
        ELActionContext actionContext = new ELActionContext();
        actionContext.setCurrentDocument(doc);
        actionContext.setDocumentManager(doc.getCoreSession());
        return actionContext;
    }

    public String getContributionId(RenditionDefinition renditionDefinition) {
        return renditionDefinition.getName();
    }

    public void contributionUpdated(String id, RenditionDefinition contrib, RenditionDefinition newOrigContrib) {
        if (contrib.isEnabled()) {
            this.descriptors.put(id, contrib);
            this.setupProvider(contrib);
        } else {
            this.descriptors.remove(id);
        }
    }

    protected void setupProvider(RenditionDefinition definition) {
        if (definition.getProviderClass() == null) {
            definition.setProvider((RenditionProvider)new DefaultAutomationRenditionProvider());
        } else {
            try {
                RenditionProvider provider = (RenditionProvider)definition.getProviderClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                definition.setProvider(provider);
            }
            catch (Exception e) {
                log.error((Object)"Unable to create RenditionProvider", (Throwable)e);
            }
        }
    }

    public void contributionRemoved(String id, RenditionDefinition contrib) {
        this.descriptors.remove(id);
    }

    public RenditionDefinition clone(RenditionDefinition contrib) {
        return new RenditionDefinition(contrib);
    }

    public void merge(RenditionDefinition source, RenditionDefinition dest) {
        dest.merge(source);
    }
}

