/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.service;

import java.util.Calendar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.utils.DateUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.query.sql.NXQL;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;

public class RenditionFinder
extends UnrestrictedSessionRunner {
    private static final Logger log = LogManager.getLogger(RenditionFinder.class);
    protected final DocumentModel source;
    protected DocumentModel storedRendition;
    protected final String renditionName;
    protected RenditionDefinition renditionDefinition;
    protected final String renditionVariant;

    protected RenditionFinder(DocumentModel source, RenditionDefinition renditionDefinition) {
        super(source.getCoreSession());
        this.source = source;
        this.renditionDefinition = renditionDefinition;
        this.renditionName = renditionDefinition.getName();
        this.renditionVariant = renditionDefinition.getProvider().getVariant(source, renditionDefinition);
    }

    public void run() {
        boolean isVersionable = this.source.isVersionable();
        String renditionSourceId = this.source.getId();
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM Document WHERE ecm:isProxy = 0 AND ");
        query.append("rend:renditionName");
        query.append(" = '");
        query.append(NXQL.escapeStringInner((String)this.renditionName));
        query.append("' AND ");
        if (this.renditionVariant != null) {
            query.append("rend:renditionVariant");
            query.append(" = '");
            query.append(NXQL.escapeStringInner((String)this.renditionVariant));
            query.append("' AND ");
        }
        if (isVersionable) {
            if (!this.source.isVersion() && !this.source.isCheckedOut()) {
                DocumentModel lastVersion = this.session.getLastDocumentVersion(this.source.getRef());
                if (lastVersion != null) {
                    renditionSourceId = lastVersion.getId();
                } else {
                    return;
                }
            }
            query.append("ecm:isVersion = 1 AND ");
        } else {
            String modificationDatePropertyName = this.getSourceDocumentModificationDatePropertyName();
            Calendar sourceLastModified = (Calendar)this.source.getPropertyValue(modificationDatePropertyName);
            if (sourceLastModified != null) {
                query.append("rend:sourceModificationDate");
                query.append(" >= TIMESTAMP '");
                query.append(DateUtils.formatISODateTime((Calendar)sourceLastModified));
                query.append("' AND ");
            }
        }
        query.append("rend:sourceId");
        query.append(" = '");
        query.append(renditionSourceId);
        query.append("' ORDER BY dc:modified DESC");
        String queryStr = query.toString();
        log.debug("Finding stored renditions for document {} with query {}.", (Object)this.source, (Object)queryStr);
        DocumentModelList docs = this.session.query(queryStr);
        log.debug("Stored renditions found for document {}: {}", (Object)this.source, (Object)docs);
        if (!docs.isEmpty()) {
            this.storedRendition = (DocumentModel)docs.get(0);
            this.storedRendition.detach(true);
        }
    }

    public DocumentModel getStoredRendition() {
        return this.storedRendition;
    }

    protected String getSourceDocumentModificationDatePropertyName() {
        return this.renditionDefinition.getSourceDocumentModificationDatePropertyName();
    }
}

