/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.runtime.api.Framework;

public class RenditionsRemover
extends UnrestrictedSessionRunner {
    public static final String RENDITION_PROXY_PUBLISHED = "renditionProxyPublished";
    protected final DocumentModel proxy;

    public RenditionsRemover(DocumentModel source) {
        super(source.getCoreSession());
        this.proxy = source;
    }

    public void run() {
        String targetUUID = (String)((Object)this.proxy.getPropertyValue("rend:sourceVersionableId"));
        Object query = "select * from Document where ";
        query = (String)query + "rend:sourceVersionableId='" + targetUUID + "' ";
        query = (String)query + " AND ecm:parentId='" + this.proxy.getParentRef().toString() + "'";
        ArrayList<String> removedProxyIds = new ArrayList<String>();
        DocumentModelList docs = this.session.query((String)query);
        for (DocumentModel doc : docs) {
            if (doc.getId().equals(this.proxy.getId())) continue;
            removedProxyIds.add(doc.getId());
        }
        this.notifyRenditionPublished(removedProxyIds);
        for (String docId : removedProxyIds) {
            this.session.removeDocument((DocumentRef)new IdRef(docId));
        }
    }

    protected void notifyRenditionPublished(List<String> removedProxyIds) {
        HashMap<String, Serializable> options = new HashMap<String, Serializable>();
        options.put("replacedProxyRefs", (Serializable)((Object)removedProxyIds));
        this.notifyEvent(RENDITION_PROXY_PUBLISHED, this.proxy, options);
    }

    protected void notifyEvent(String eventId, DocumentModel doc, Map<String, Serializable> options) {
        CoreSession session = doc.getCoreSession();
        DocumentEventContext ctx = new DocumentEventContext(session, session.getPrincipal(), doc);
        if (options != null) {
            ctx.setProperties(options);
        }
        ctx.setProperty("category", (Serializable)((Object)"eventDocumentCategory"));
        Event event = ctx.newEvent(eventId);
        this.getEventService().fireEvent(event);
    }

    protected EventService getEventService() {
        return (EventService)Framework.getService(EventService.class);
    }
}

