/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.IOException;
import java.util.NoSuchElementException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import jdbm.btree.BTree;
import jdbm.helper.Tuple;
import jdbm.helper.TupleBrowser;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;

public class BTreeEnumeration
implements NamingEnumeration {
    private final Tuple jdbmTuple = new Tuple();
    private TupleBrowser browser;
    private boolean success = false;

    BTreeEnumeration(BTree tree) throws NamingException {
        try {
            this.browser = tree.browse();
            this.prefetch();
        }
        catch (IOException e) {
            LdapNamingException lne = new LdapNamingException("Failure on btree: " + e.getMessage(), ResultCodeEnum.OTHER);
            lne.setRootCause((Throwable)e);
            throw lne;
        }
    }

    private void prefetch() throws IOException {
        this.success = this.browser.getNext(this.jdbmTuple);
    }

    public void close() throws NamingException {
        this.success = false;
    }

    public boolean hasMore() throws NamingException {
        return this.success;
    }

    public Object next() throws NamingException {
        if (!this.success) {
            throw new NoSuchElementException();
        }
        Object next = this.jdbmTuple.getKey();
        try {
            this.prefetch();
        }
        catch (IOException e) {
            LdapNamingException lne = new LdapNamingException("Failure on btree: " + e.getMessage(), ResultCodeEnum.OTHER);
            lne.setRootCause((Throwable)e);
            throw lne;
        }
        return next;
    }

    public boolean hasMoreElements() {
        return this.success;
    }

    public Object nextElement() {
        try {
            return this.next();
        }
        catch (NamingException e) {
            e.printStackTrace();
            throw new NoSuchElementException("Got IO Failure on btree: " + e.getCause().getMessage());
        }
    }
}

