/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.webdav.jaxrs.xml.elements;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import net.java.dev.webdav.jaxrs.ConstantsAdapter;
import net.java.dev.webdav.jaxrs.xml.elements.Exclusive;
import net.java.dev.webdav.jaxrs.xml.elements.Shared;
import net.java.dev.webdav.util.Utilities;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"exclusive", "shared"})
@XmlJavaTypeAdapter(value=Adapter.class)
@XmlRootElement(name="lockscope")
public final class LockScope {
    public static final LockScope SHARED = new LockScope(Shared.SHARED, null);
    public static final LockScope EXCLUSIVE = new LockScope(null, Exclusive.EXCLUSIVE);
    private final Shared shared;
    private final Exclusive exclusive;

    private LockScope() {
        this.shared = null;
        this.exclusive = null;
    }

    private LockScope(Shared shared, Exclusive exclusive) {
        this.shared = shared;
        this.exclusive = exclusive;
    }

    public final int hashCode() {
        return Objects.hash(this.shared, this.exclusive);
    }

    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof LockScope)) {
            return false;
        }
        LockScope that = (LockScope)other;
        return Arrays.equals(Utilities.array(this.exclusive, this.shared), Utilities.array(that.exclusive, that.shared));
    }

    public final String toString() {
        return Utilities.toString(this, this.shared, this.exclusive);
    }

    protected static final class Adapter
    extends ConstantsAdapter<LockScope> {
        protected Adapter() {
        }

        @Override
        protected final Collection<LockScope> getConstants() {
            return Arrays.asList(SHARED, EXCLUSIVE);
        }
    }
}

