/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools.encoding;

import org.sat4j.core.ConstrGroup;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.tools.encoding.EncodingStrategyAdapter;

public class Binary
extends EncodingStrategyAdapter {
    public IConstr addAtMostOne(ISolver solver, IVecInt literals) throws ContradictionException {
        int j;
        ConstrGroup group = new ConstrGroup(false);
        int n = literals.size();
        int p = (int)Math.ceil(Math.log(n) / Math.log(2.0));
        int k = (int)Math.pow(2.0, p) - n;
        int[] y = new int[p];
        int i = 0;
        while (i < p) {
            y[i] = solver.nextFreeVarId(true);
            ++i;
        }
        VecInt clause = new VecInt();
        String binary = "";
        int i2 = 0;
        while (i2 < k) {
            binary = Integer.toBinaryString(i2);
            while (binary.length() != p - 1) {
                binary = "0" + binary;
            }
            j = 0;
            while (j < p - 1) {
                clause.push(-literals.get(i2));
                if (binary.charAt(j) == '0') {
                    clause.push(-y[j]);
                } else {
                    clause.push(y[j]);
                }
                group.add(solver.addClause(clause));
                clause.clear();
                ++j;
            }
            ++i2;
        }
        i2 = k;
        while (i2 < n) {
            binary = Integer.toBinaryString(2 * k + i2 - k);
            while (binary.length() != p) {
                binary = "0" + binary;
            }
            j = 0;
            while (j < p) {
                clause.push(-literals.get(i2));
                if (binary.charAt(j) == '0') {
                    clause.push(-y[j]);
                } else {
                    clause.push(y[j]);
                }
                group.add(solver.addClause(clause));
                clause.clear();
                ++j;
            }
            ++i2;
        }
        return group;
    }

    public IConstr addAtMost(ISolver solver, IVecInt literals, int degree) throws ContradictionException {
        return super.addAtMost(solver, literals, degree);
    }
}

