/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis.contribs;

import java.io.IOException;
import java.net.ConnectException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.redis.contribs.RedisWorkQueuing;
import org.nuxeo.ecm.core.work.NuxeoBlockingQueue;
import org.nuxeo.ecm.core.work.WorkHolder;
import org.nuxeo.ecm.core.work.WorkQueuing;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkQueueMetrics;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class RedisBlockingQueue
extends NuxeoBlockingQueue {
    private static final Log log = LogFactory.getLog(RedisBlockingQueue.class);
    private static final long LOG_INTERVAL = 10000L;
    private static AtomicLong LAST_IO_EXCEPTION = new AtomicLong(0L);
    private static AtomicLong LAST_CONNECTION_EXCEPTION = new AtomicLong(0L);
    private static final int REMOTE_POLL_INTERVAL_MS = 1000;
    private static final int REMOTE_POLL_INTERVAL_STDEV_MS = 200;
    protected final RedisWorkQueuing queuing;
    protected final Lock lock = new ReentrantLock();
    protected final Condition notEmpty = this.lock.newCondition();

    public RedisBlockingQueue(String queueId, RedisWorkQueuing queuing) {
        super(queueId, (WorkQueuing)queuing);
        this.queuing = queuing;
    }

    protected WorkQueueMetrics metrics() {
        return this.queuing.metrics(this.queueId);
    }

    public int getQueueSize() {
        return this.queuing.metrics((String)this.queueId).scheduled.intValue();
    }

    public Runnable take() throws InterruptedException {
        Runnable r;
        while ((r = this.poll(1L, TimeUnit.DAYS)) == null) {
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        if ((nanos = this.awaitActivation(nanos)) <= 0L) {
            return null;
        }
        long end = System.currentTimeMillis() + TimeUnit.NANOSECONDS.toMillis(nanos);
        Runnable r;
        while ((r = this.poll()) == null) {
            if (this.timeUntil(end) == 0L) {
                return null;
            }
            this.lock.lock();
            try {
                this.notEmpty.await(this.getRemotePollInterval(), TimeUnit.MILLISECONDS);
                continue;
            }
            finally {
                this.lock.unlock();
                continue;
            }
            break;
        }
        return r;
    }

    private int getRemotePollInterval() {
        return 1000 + ThreadLocalRandom.current().nextInt(-200, 200);
    }

    public void putElement(Runnable r) {
        Work work = WorkHolder.getWork((Runnable)r);
        this.lock.lock();
        try {
            this.queuing.workSetScheduled(this.queueId, work);
            this.notEmpty.signal();
        }
        catch (IOException e) {
            log.error((Object)("Failed to add Work: " + work), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public Runnable pollElement() {
        try {
            Work work = this.queuing.getWorkFromQueue(this.queueId);
            return work == null ? null : new WorkHolder(work);
        }
        catch (IOException e) {
            if (RedisBlockingQueue.delayExpired(LAST_IO_EXCEPTION)) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            return null;
        }
        catch (JedisConnectionException e) {
            if (RedisBlockingQueue.delayExpired(LAST_CONNECTION_EXCEPTION)) {
                Throwable cause = e.getCause();
                if (cause != null && cause.getMessage().contains(ConnectException.class.getName())) {
                    log.error((Object)(e.getMessage() + ": " + cause.getMessage()));
                    log.debug((Object)e.getMessage(), (Throwable)e);
                } else {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            return null;
        }
    }

    protected static boolean delayExpired(AtomicLong atomic) {
        long last;
        long now = System.currentTimeMillis();
        return now > (last = atomic.get()) + 10000L && atomic.compareAndSet(last, now);
    }
}

