/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.codec.stateful;

import java.util.Stack;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.codec.stateful.AbstractStatefulDecoder;
import org.apache.directory.shared.asn1.codec.stateful.DecoderCallback;
import org.apache.directory.shared.asn1.codec.stateful.StatefulDecoder;

public class DecoderStack
extends AbstractStatefulDecoder {
    private final DecoderCallback topcb;
    private Stack decoders = new Stack();

    public DecoderStack() {
        this.topcb = new DecoderCallback(){

            public void decodeOccurred(StatefulDecoder decoder, Object decoded) {
                DecoderStack.this.decodeOccurred(decoded);
            }
        };
    }

    public synchronized void push(StatefulDecoder decoder) {
        decoder.setCallback(this.topcb);
        if (!this.decoders.isEmpty()) {
            StatefulDecoder top = (StatefulDecoder)this.decoders.peek();
            ChainingCallback chaining = new ChainingCallback(top, decoder);
            top.setCallback(chaining);
        }
        this.decoders.push(decoder);
    }

    public synchronized StatefulDecoder pop() {
        if (this.decoders.isEmpty()) {
            return this;
        }
        StatefulDecoder popped = (StatefulDecoder)this.decoders.pop();
        popped.setCallback(null);
        if (!this.decoders.isEmpty()) {
            StatefulDecoder top = (StatefulDecoder)this.decoders.peek();
            top.setCallback(this.topcb);
        }
        return popped;
    }

    public synchronized void decode(Object encoded) throws DecoderException {
        if (this.decoders.isEmpty()) {
            this.decodeOccurred(encoded);
            return;
        }
        ((StatefulDecoder)this.decoders.get(0)).decode(encoded);
    }

    public boolean isEmpty() {
        return this.decoders.isEmpty();
    }

    public synchronized void clear() {
        while (!this.decoders.isEmpty()) {
            this.pop();
        }
    }

    class ChainingCallback
    implements DecoderCallback {
        private StatefulDecoder sink;
        private StatefulDecoder src;

        ChainingCallback(StatefulDecoder src, StatefulDecoder sink) {
            this.src = src;
            this.sink = sink;
        }

        public void decodeOccurred(StatefulDecoder decoder, Object decoded) {
            if (decoder != this.src) {
                return;
            }
            try {
                this.sink.decode(decoded);
            }
            catch (DecoderException e) {
                if (DecoderStack.this.getDecoderMonitor() != null) {
                    DecoderStack.this.getDecoderMonitor().fatalError(DecoderStack.this, e);
                }
                throw new RuntimeException(e);
            }
        }
    }
}

