/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz.support;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.core.authz.support.ACITupleFilter;
import org.apache.directory.server.core.authz.support.OperationScope;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.partition.PartitionNexusProxy;
import org.apache.directory.shared.ldap.aci.ACITuple;
import org.apache.directory.shared.ldap.aci.AuthenticationLevel;
import org.apache.directory.shared.ldap.aci.MicroOperation;
import org.apache.directory.shared.ldap.aci.ProtectedItem;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.name.LdapDN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxImmSubFilter
implements ACITupleFilter {
    private final ExprNode childrenFilter = new PresenceNode("objectClass");
    private final SearchControls childrenSearchControls = new SearchControls();
    public static final Collection<String> SEARCH_BYPASS;

    public MaxImmSubFilter() {
        this.childrenSearchControls.setSearchScope(1);
    }

    @Override
    public Collection<ACITuple> filter(Collection<ACITuple> tuples, OperationScope scope, PartitionNexusProxy proxy, Collection<LdapDN> userGroupNames, LdapDN userName, Attributes userEntry, AuthenticationLevel authenticationLevel, LdapDN entryName, String attrId, Object attrValue, Attributes entry, Collection<MicroOperation> microOperations) throws NamingException {
        if (entryName.size() == 0) {
            return tuples;
        }
        if (tuples.size() == 0) {
            return tuples;
        }
        if (scope != OperationScope.ENTRY) {
            return tuples;
        }
        int immSubCount = -1;
        Iterator<ACITuple> i = tuples.iterator();
        block0: while (i.hasNext()) {
            ACITuple tuple = i.next();
            if (!tuple.isGrant()) continue;
            for (ProtectedItem item : tuple.getProtectedItems()) {
                ProtectedItem.MaxImmSub mis;
                if (!(item instanceof ProtectedItem.MaxImmSub)) continue;
                if (immSubCount < 0) {
                    immSubCount = this.getImmSubCount(proxy, entryName);
                }
                if (immSubCount < (mis = (ProtectedItem.MaxImmSub)item).getValue()) continue;
                i.remove();
                continue block0;
            }
        }
        return tuples;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getImmSubCount(PartitionNexusProxy proxy, LdapDN entryName) throws NamingException {
        int cnt = 0;
        NamingEnumeration<SearchResult> e = null;
        try {
            e = proxy.search(new SearchOperationContext((LdapDN)entryName.getPrefix(1), new HashMap(), this.childrenFilter, this.childrenSearchControls), SEARCH_BYPASS);
            while (e.hasMore()) {
                e.next();
                ++cnt;
            }
        }
        finally {
            if (e != null) {
                e.close();
            }
        }
        return cnt;
    }

    static {
        HashSet<String> c = new HashSet<String>();
        c.add("normalizationService");
        c.add("authenticationService");
        c.add("authorizationService");
        c.add("defaultAuthorizationService");
        c.add("schemaService");
        c.add("subentryService");
        c.add("operationalAttributeService");
        c.add("eventService");
        SEARCH_BYPASS = Collections.unmodifiableCollection(c);
    }
}

