/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.Binding;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.event.EventContext;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingListener;
import javax.naming.event.ObjectChangeListener;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.configuration.InterceptorConfiguration;
import org.apache.directory.server.core.event.Evaluator;
import org.apache.directory.server.core.event.ExpressionEvaluator;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.invocation.Invocation;
import org.apache.directory.server.core.invocation.InvocationStack;
import org.apache.directory.server.core.normalization.NormalizingVisitor;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.core.partition.PartitionNexusProxy;
import org.apache.directory.server.schema.ConcreteNameComponentNormalizer;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.shared.ldap.filter.AssertionEnum;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.FilterVisitor;
import org.apache.directory.shared.ldap.filter.LeafNode;
import org.apache.directory.shared.ldap.filter.ScopeNode;
import org.apache.directory.shared.ldap.message.DerefAliasesEnum;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.NameComponentNormalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventService
extends BaseInterceptor {
    private static Logger log = LoggerFactory.getLogger(EventService.class);
    private PartitionNexus nexus;
    private Map<NamingListener, Object> sources = new HashMap<NamingListener, Object>();
    private Evaluator evaluator = null;
    private AttributeTypeRegistry attributeRegistry;
    private NormalizingVisitor visitor;

    public void init(DirectoryServiceConfiguration factoryCfg, InterceptorConfiguration cfg) throws NamingException {
        super.init(factoryCfg, cfg);
        OidRegistry oidRegistry = factoryCfg.getRegistries().getOidRegistry();
        this.attributeRegistry = factoryCfg.getRegistries().getAttributeTypeRegistry();
        this.evaluator = new ExpressionEvaluator(oidRegistry, this.attributeRegistry);
        this.nexus = factoryCfg.getPartitionNexus();
        ConcreteNameComponentNormalizer ncn = new ConcreteNameComponentNormalizer(this.attributeRegistry, oidRegistry);
        this.visitor = new NormalizingVisitor((NameComponentNormalizer)ncn, factoryCfg.getRegistries().getOidRegistry());
    }

    public void addNamingListener(EventContext ctx, Name name, ExprNode filter, SearchControls searchControls, NamingListener namingListener) throws NamingException {
        LdapDN normalizedBaseDn = new LdapDN(name);
        normalizedBaseDn.normalize(this.attributeRegistry.getNormalizerMapping());
        if (filter.isLeaf()) {
            LeafNode ln = (LeafNode)filter;
            if (!this.attributeRegistry.hasAttributeType(ln.getAttribute())) {
                StringBuffer buf = new StringBuffer();
                buf.append("undefined filter based on undefined attributeType '");
                buf.append(ln.getAttribute());
                buf.append("' not evaluted at all.  Only using scope node.");
                log.warn(buf.toString());
                filter = null;
            } else {
                filter.accept((FilterVisitor)this.visitor);
            }
        } else {
            filter.accept((FilterVisitor)this.visitor);
            BranchNode child = (BranchNode)filter;
            if (child.getChildren().size() == 0) {
                log.warn("Undefined branchnode filter without child nodes not evaluted at all. Only using scope node.");
                filter = null;
            }
            if (child.getChildren().size() == 1 && child.getOperator() != AssertionEnum.NOT) {
                filter = child.getChild();
            }
        }
        ScopeNode scope = new ScopeNode(DerefAliasesEnum.NEVER_DEREF_ALIASES, normalizedBaseDn.toNormName(), searchControls.getSearchScope());
        if (filter != null) {
            BranchNode and = new BranchNode(AssertionEnum.AND);
            and.addNode((ExprNode)scope);
            and.addNode(filter);
            filter = and;
        } else {
            filter = scope;
        }
        EventSourceRecord rec = new EventSourceRecord(name, filter, ctx, searchControls, namingListener);
        Object obj = this.sources.get(namingListener);
        if (obj == null) {
            this.sources.put(namingListener, rec);
        } else if (obj instanceof EventSourceRecord) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(obj);
            list.add(rec);
            this.sources.put(namingListener, list);
        } else if (obj instanceof List) {
            List list = (List)obj;
            list.add(rec);
        }
    }

    public void removeNamingListener(EventContext ctx, NamingListener namingListener) {
        Object obj = this.sources.get(namingListener);
        if (obj == null) {
            return;
        }
        if (obj instanceof EventSourceRecord) {
            this.sources.remove(namingListener);
        } else if (obj instanceof List) {
            List list = (List)obj;
            for (int ii = 0; ii < list.size(); ++ii) {
                EventSourceRecord rec = (EventSourceRecord)list.get(ii);
                if (rec.getEventContext() != ctx) continue;
                list.remove(ii);
            }
            if (list.isEmpty()) {
                this.sources.remove(namingListener);
            }
        }
    }

    public void add(NextInterceptor next, AddOperationContext opContext) throws NamingException {
        super.add(next, opContext);
        LdapDN name = opContext.getDn();
        Attributes entry = opContext.getEntry();
        Set selecting = this.getSelectingSources(name, entry);
        if (selecting.isEmpty()) {
            return;
        }
        for (EventSourceRecord rec : selecting) {
            NamingListener listener = rec.getNamingListener();
            if (!(listener instanceof NamespaceChangeListener)) continue;
            NamespaceChangeListener nclistener = (NamespaceChangeListener)listener;
            Binding binding = new Binding(name.getUpName(), entry, false);
            nclistener.objectAdded(new NamingEvent(rec.getEventContext(), 0, binding, null, entry));
        }
    }

    public void delete(NextInterceptor next, DeleteOperationContext opContext) throws NamingException {
        LdapDN name = opContext.getDn();
        Attributes entry = this.nexus.lookup(new LookupOperationContext(name));
        super.delete(next, opContext);
        Set selecting = this.getSelectingSources(name, entry);
        if (selecting.isEmpty()) {
            return;
        }
        for (EventSourceRecord rec : selecting) {
            NamingListener listener = rec.getNamingListener();
            if (!(listener instanceof NamespaceChangeListener)) continue;
            NamespaceChangeListener nclistener = (NamespaceChangeListener)listener;
            Binding binding = new Binding(name.getUpName(), entry, false);
            nclistener.objectRemoved(new NamingEvent(rec.getEventContext(), 1, null, binding, entry));
        }
    }

    private void notifyOnModify(LdapDN name, ModificationItemImpl[] mods, Attributes oriEntry) throws NamingException {
        Attributes entry = this.nexus.lookup(new LookupOperationContext(name));
        Set selecting = this.getSelectingSources(name, entry);
        if (selecting.isEmpty()) {
            return;
        }
        for (EventSourceRecord rec : selecting) {
            NamingListener listener = rec.getNamingListener();
            if (!(listener instanceof ObjectChangeListener)) continue;
            ObjectChangeListener oclistener = (ObjectChangeListener)listener;
            Binding before = new Binding(name.getUpName(), oriEntry, false);
            Binding after = new Binding(name.getUpName(), entry, false);
            oclistener.objectChanged(new NamingEvent(rec.getEventContext(), 3, after, before, mods));
        }
    }

    public void modify(NextInterceptor next, ModifyOperationContext opContext) throws NamingException {
        Invocation invocation = InvocationStack.getInstance().peek();
        PartitionNexusProxy proxy = invocation.getProxy();
        Attributes oriEntry = proxy.lookup(new LookupOperationContext(opContext.getDn()), PartitionNexusProxy.LOOKUP_BYPASS);
        super.modify(next, opContext);
        this.notifyOnModify(opContext.getDn(), opContext.getModItems(), oriEntry);
    }

    private void notifyOnNameChange(LdapDN oldName, LdapDN newName) throws NamingException {
        Attributes entry = this.nexus.lookup(new LookupOperationContext(newName));
        Set selecting = this.getSelectingSources(oldName, entry);
        if (selecting.isEmpty()) {
            return;
        }
        for (EventSourceRecord rec : selecting) {
            NamingListener listener = rec.getNamingListener();
            if (!(listener instanceof NamespaceChangeListener)) continue;
            NamespaceChangeListener nclistener = (NamespaceChangeListener)listener;
            Binding oldBinding = new Binding(oldName.getUpName(), entry, false);
            Binding newBinding = new Binding(newName.getUpName(), entry, false);
            nclistener.objectRenamed(new NamingEvent(rec.getEventContext(), 2, newBinding, oldBinding, entry));
        }
    }

    public void rename(NextInterceptor next, RenameOperationContext opContext) throws NamingException {
        super.rename(next, opContext);
        LdapDN newName = (LdapDN)opContext.getDn().clone();
        newName.remove(newName.size() - 1);
        newName.add(opContext.getNewRdn());
        newName.normalize(this.attributeRegistry.getNormalizerMapping());
        this.notifyOnNameChange(opContext.getDn(), newName);
    }

    public void moveAndRename(NextInterceptor next, MoveAndRenameOperationContext opContext) throws NamingException {
        super.moveAndRename(next, opContext);
        LdapDN newName = (LdapDN)opContext.getParent().clone();
        newName.add(opContext.getNewRdn());
        this.notifyOnNameChange(opContext.getDn(), newName);
    }

    public void move(NextInterceptor next, MoveOperationContext opContext) throws NamingException {
        super.move(next, opContext);
        LdapDN oriChildName = opContext.getDn();
        LdapDN newName = (LdapDN)opContext.getParent().clone();
        newName.add(oriChildName.get(oriChildName.size() - 1));
        this.notifyOnNameChange(oriChildName, newName);
    }

    Set getSelectingSources(LdapDN name, Attributes entry) throws NamingException {
        if (this.sources.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<Object> selecting = new HashSet<Object>();
        for (Object obj : this.sources.values()) {
            if (obj instanceof EventSourceRecord) {
                EventSourceRecord rec = (EventSourceRecord)obj;
                if (!this.evaluator.evaluate(rec.getFilter(), name.toNormName(), entry)) continue;
                selecting.add(obj);
                continue;
            }
            if (obj instanceof List) {
                List records = (List)obj;
                for (int ii = 0; ii < records.size(); ++ii) {
                    EventSourceRecord rec = (EventSourceRecord)records.get(ii);
                    if (!this.evaluator.evaluate(rec.getFilter(), name.toNormName(), entry)) continue;
                    selecting.add(obj);
                }
                continue;
            }
            throw new IllegalStateException("Unexpected class type of " + obj.getClass());
        }
        return selecting;
    }

    class EventSourceRecord {
        private Name base;
        private SearchControls controls;
        private ExprNode filter;
        private EventContext context;
        private NamingListener listener;

        public EventSourceRecord(Name base, ExprNode filter, EventContext context, SearchControls controls, NamingListener listener) {
            this.filter = filter;
            this.context = context;
            this.base = base;
            this.controls = controls;
            this.listener = listener;
        }

        public NamingListener getNamingListener() {
            return this.listener;
        }

        public ExprNode getFilter() {
            return this.filter;
        }

        public EventContext getEventContext() {
            return this.context;
        }

        public Name getBase() {
            return this.base;
        }

        public SearchControls getSearchControls() {
            return this.controls;
        }
    }
}

