/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.interceptor.context;

import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.server.core.interceptor.context.AbstractOperationContext;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.name.LdapDN;

public class ModifyOperationContext
extends AbstractOperationContext {
    private ModificationItemImpl[] modItems;

    public ModifyOperationContext() {
    }

    public ModifyOperationContext(LdapDN dn, ModificationItemImpl[] modItems) {
        super(dn);
        this.modItems = modItems;
    }

    public void setModItems(ModificationItemImpl[] modItems) {
        this.modItems = modItems;
    }

    public ModificationItemImpl[] getModItems() {
        return this.modItems;
    }

    public static ModificationItemImpl[] createModItems(Attributes attributes, int modOp) throws NamingException {
        ModificationItemImpl[] items = new ModificationItemImpl[attributes.size()];
        NamingEnumeration<? extends Attribute> e = attributes.getAll();
        int i = 0;
        while (e.hasMore()) {
            items[i++] = new ModificationItemImpl(modOp, e.next());
        }
        return items;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ModifyContext for DN '").append(this.getDn().getUpName()).append("', modifications :\n");
        for (ModificationItemImpl mod : this.modItems) {
            sb.append(mod).append('\n');
        }
        return sb.toString();
    }
}

