/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.ConfigurationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.configuration.PartitionConfiguration;
import org.apache.directory.server.core.interceptor.context.AddContextPartitionOperationContext;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.GetMatchedNameOperationContext;
import org.apache.directory.server.core.interceptor.context.GetRootDSEOperationContext;
import org.apache.directory.server.core.interceptor.context.GetSuffixOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.ListSuffixOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RemoveContextPartitionOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.core.partition.impl.btree.MutableBTreePartitionConfiguration;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmPartition;
import org.apache.directory.server.core.partition.tree.BranchNode;
import org.apache.directory.server.core.partition.tree.LeafNode;
import org.apache.directory.server.core.partition.tree.Node;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.shared.ldap.MultiException;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.exception.LdapInvalidAttributeIdentifierException;
import org.apache.directory.shared.ldap.exception.LdapNameNotFoundException;
import org.apache.directory.shared.ldap.exception.LdapNoSuchAttributeException;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.message.AttributeImpl;
import org.apache.directory.shared.ldap.message.AttributesImpl;
import org.apache.directory.shared.ldap.message.ServerSearchResult;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.UsageEnum;
import org.apache.directory.shared.ldap.util.DateUtils;
import org.apache.directory.shared.ldap.util.NamespaceTools;
import org.apache.directory.shared.ldap.util.SingletonEnumeration;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPartitionNexus
extends PartitionNexus {
    private static final Logger log = LoggerFactory.getLogger(DefaultPartitionNexus.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private static final String ASF = "Apache Software Foundation";
    private static final String VENDORNAME_ATTR = "vendorName";
    private static final String VENDORVERSION_ATTR = "vendorVersion";
    private static final String NAMINGCTXS_ATTR = "namingContexts";
    private boolean initialized;
    private DirectoryServiceConfiguration factoryCfg;
    private Partition system;
    private Map<String, Partition> partitions = new HashMap<String, Partition>();
    private BranchNode partitionLookupTree = new BranchNode();
    private final Attributes rootDSE;
    private AttributeTypeRegistry attrRegistry;
    private OidRegistry oidRegistry;

    public DefaultPartitionNexus(Attributes rootDSE) {
        this.rootDSE = rootDSE;
        AttributeImpl attr = new AttributeImpl("subschemaSubentry");
        attr.add("cn=schema");
        rootDSE.put((Attribute)attr);
        attr = new AttributeImpl("supportedLDAPVersion");
        rootDSE.put((Attribute)attr);
        attr.add("3");
        attr = new AttributeImpl("supportedFeatures");
        rootDSE.put((Attribute)attr);
        attr.add("1.3.6.1.4.1.4203.1.5.1");
        attr = new AttributeImpl("supportedExtension");
        rootDSE.put((Attribute)attr);
        attr.add("1.3.6.1.4.1.1466.20036");
        attr = new AttributeImpl("supportedSASLMechanisms");
        rootDSE.put((Attribute)attr);
        attr.add("GSSAPI");
        attr.add("DIGEST-MD5");
        attr.add("CRAM-MD5");
        attr = new AttributeImpl("supportedControl");
        rootDSE.put((Attribute)attr);
        attr.add("2.16.840.1.113730.3.4.3");
        attr.add("2.16.840.1.113730.3.4.7");
        attr.add("1.3.6.1.4.1.4203.1.10.1");
        attr.add("2.16.840.1.113730.3.4.2");
        attr.add("1.3.6.1.4.1.18060.0.0.1");
        attr = new AttributeImpl("objectClass");
        rootDSE.put((Attribute)attr);
        attr.add("top");
        attr.add("extensibleObject");
        attr = new AttributeImpl(NAMINGCTXS_ATTR);
        rootDSE.put((Attribute)attr);
        attr = new AttributeImpl(VENDORNAME_ATTR);
        attr.add(ASF);
        rootDSE.put((Attribute)attr);
        Properties props = new Properties();
        try {
            props.load(this.getClass().getResourceAsStream("version.properties"));
        }
        catch (IOException e) {
            log.error("failed to log version properties");
        }
        attr = new AttributeImpl(VENDORVERSION_ATTR);
        attr.add(props.getProperty("apacheds.version", "UNKNOWN"));
        rootDSE.put((Attribute)attr);
    }

    @Override
    public PartitionConfiguration getConfiguration() {
        throw new UnsupportedOperationException("The NEXUS partition does not have a standard partition configuration associated with it.");
    }

    @Override
    public String getId() {
        return "NEXUS";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(DirectoryServiceConfiguration factoryCfg, PartitionConfiguration cfg) throws NamingException {
        if (this.initialized) {
            return;
        }
        this.factoryCfg = factoryCfg;
        this.attrRegistry = this.factoryCfg.getRegistries().getAttributeTypeRegistry();
        this.oidRegistry = this.factoryCfg.getRegistries().getOidRegistry();
        this.initializeSystemPartition();
        ArrayList<Partition> initializedPartitions = new ArrayList<Partition>();
        initializedPartitions.add(0, this.system);
        Iterator<PartitionConfiguration> partitionConfigurations = factoryCfg.getStartupConfiguration().getPartitionConfigurations().iterator();
        try {
            while (partitionConfigurations.hasNext()) {
                PartitionConfiguration c = partitionConfigurations.next();
                AddContextPartitionOperationContext opCtx = new AddContextPartitionOperationContext(c);
                this.addContextPartition(opCtx);
                initializedPartitions.add(opCtx.getPartition());
            }
            this.initialized = true;
        }
        finally {
            if (!this.initialized) {
                Iterator i = initializedPartitions.iterator();
                while (i.hasNext()) {
                    Partition partition = (Partition)i.next();
                    i.remove();
                    try {
                        partition.destroy();
                    }
                    catch (Exception e) {
                        log.warn("Failed to destroy a partition: " + partition.getSuffix(), (Throwable)e);
                    }
                    finally {
                        this.unregister(partition);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PartitionConfiguration initializeSystemPartition() throws NamingException {
        MutableBTreePartitionConfiguration systemCfg;
        PartitionConfiguration overrides = this.factoryCfg.getStartupConfiguration().getSystemPartitionConfiguration();
        if (overrides != null) {
            systemCfg = MutableBTreePartitionConfiguration.getConfiguration(overrides);
            Attributes systemEntry = systemCfg.getContextEntry();
            Attribute objectClassAttr = systemEntry.get("objectClass");
            if (objectClassAttr == null) {
                objectClassAttr = new AttributeImpl("objectClass");
                systemEntry.put(objectClassAttr);
            }
            objectClassAttr.add("top");
            objectClassAttr.add("organizationalUnit");
            objectClassAttr.add("extensibleObject");
            systemEntry.put("creatorsName", "uid=admin,ou=system");
            systemEntry.put("createTimestamp", DateUtils.getGeneralizedTime());
            systemEntry.put(NamespaceTools.getRdnAttribute((String)"ou=system"), NamespaceTools.getRdnValue((String)"ou=system"));
            systemCfg.setContextEntry(systemEntry);
            if (!systemCfg.getId().equals("system")) {
                throw new ConfigurationException("System partition has wrong name: should be 'system'.");
            }
            Set<Object> indices = systemCfg.getIndexedAttributes();
            HashSet<String> indexOids = new HashSet<String>();
            OidRegistry registry = this.factoryCfg.getRegistries().getOidRegistry();
            for (Object index : indices) {
                indexOids.add(registry.getOid(index.toString()));
            }
            if (!indexOids.contains("1.3.6.1.4.1.18060.0.4.1.2.7")) {
                indices.add("1.3.6.1.4.1.18060.0.4.1.2.7");
            }
            if (!indexOids.contains("1.3.6.1.4.1.18060.0.4.1.2.3")) {
                indices.add("1.3.6.1.4.1.18060.0.4.1.2.3");
            }
            if (!indexOids.contains("1.3.6.1.4.1.18060.0.4.1.2.4")) {
                indices.add("1.3.6.1.4.1.18060.0.4.1.2.4");
            }
            if (!indexOids.contains("1.3.6.1.4.1.18060.0.4.1.2.1")) {
                indices.add("1.3.6.1.4.1.18060.0.4.1.2.1");
            }
            if (!indexOids.contains("1.3.6.1.4.1.18060.0.4.1.2.5")) {
                indices.add("1.3.6.1.4.1.18060.0.4.1.2.5");
            }
            if (!indexOids.contains("1.3.6.1.4.1.18060.0.4.1.2.6")) {
                indices.add("1.3.6.1.4.1.18060.0.4.1.2.6");
            }
            if (!indexOids.contains("1.3.6.1.4.1.18060.0.4.1.2.2")) {
                indices.add("1.3.6.1.4.1.18060.0.4.1.2.2");
            }
            if (!indexOids.contains(registry.getOid("objectClass"))) {
                log.warn("CAUTION: You have not included objectClass as an indexed attributein the system partition configuration.  This will lead to poor performance.  The server is automatically adding this index for you.");
                indices.add("objectClass");
            }
        } else {
            systemCfg = new MutableBTreePartitionConfiguration();
            systemCfg.setId("system");
            systemCfg.setCacheSize(500);
            systemCfg.setSuffix("ou=system");
            HashSet<Object> indexedSystemAttrs = new HashSet<Object>();
            indexedSystemAttrs.add("1.3.6.1.4.1.18060.0.4.1.2.7");
            indexedSystemAttrs.add("1.3.6.1.4.1.18060.0.4.1.2.3");
            indexedSystemAttrs.add("1.3.6.1.4.1.18060.0.4.1.2.4");
            indexedSystemAttrs.add("1.3.6.1.4.1.18060.0.4.1.2.1");
            indexedSystemAttrs.add("1.3.6.1.4.1.18060.0.4.1.2.5");
            indexedSystemAttrs.add("1.3.6.1.4.1.18060.0.4.1.2.6");
            indexedSystemAttrs.add("1.3.6.1.4.1.18060.0.4.1.2.2");
            indexedSystemAttrs.add("objectClass");
            systemCfg.setIndexedAttributes(indexedSystemAttrs);
            AttributesImpl systemEntry = new AttributesImpl();
            AttributeImpl objectClassAttr = new AttributeImpl("objectClass");
            objectClassAttr.add("top");
            objectClassAttr.add("organizationalUnit");
            objectClassAttr.add("extensibleObject");
            systemEntry.put((Attribute)objectClassAttr);
            systemEntry.put("creatorsName", "uid=admin,ou=system");
            systemEntry.put("createTimestamp", DateUtils.getGeneralizedTime());
            systemEntry.put(NamespaceTools.getRdnAttribute((String)"ou=system"), NamespaceTools.getRdnValue((String)"ou=system"));
            systemCfg.setContextEntry((Attributes)systemEntry);
        }
        this.system = new JdbmPartition();
        this.system.init(this.factoryCfg, systemCfg);
        String key = this.system.getSuffix().toString();
        if (this.partitions.containsKey(key)) {
            throw new ConfigurationException("Duplicate partition suffix: " + key);
        }
        BranchNode branchNode = this.partitionLookupTree;
        synchronized (branchNode) {
            this.partitions.put(key, this.system);
            this.partitionLookupTree.recursivelyAddPartition(this.partitionLookupTree, this.system.getSuffix(), 0, this.system);
            Attribute namingContexts = this.rootDSE.get(NAMINGCTXS_ATTR);
            namingContexts.add(this.system.getUpSuffix().getUpName());
        }
        return systemCfg;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public synchronized void destroy() {
        if (!this.initialized) {
            return;
        }
        for (String suffix : new HashSet<String>(this.partitions.keySet())) {
            try {
                this.removeContextPartition(new RemoveContextPartitionOperationContext(new LdapDN(suffix)));
            }
            catch (NamingException e) {
                log.warn("Failed to destroy a partition: " + suffix, (Throwable)e);
            }
        }
        this.initialized = false;
    }

    @Override
    public void sync() throws NamingException {
        MultiException error = null;
        for (Partition partition : this.partitions.values()) {
            try {
                partition.sync();
            }
            catch (NamingException e) {
                log.warn("Failed to flush partition data out.", (Throwable)e);
                if (error == null) {
                    error = new MultiException("Grouping many exceptions on root nexus sync()");
                }
                error.addThrowable((Throwable)e);
            }
        }
        if (error != null) {
            String msg = "Encountered failures while performing a sync() operation on backing stores";
            NamingException total = new NamingException(msg);
            total.setRootCause((Throwable)error);
        }
    }

    @Override
    public boolean compare(CompareOperationContext compareContext) throws NamingException {
        Partition partition = this.getPartition(compareContext.getDn());
        AttributeTypeRegistry registry = this.factoryCfg.getRegistries().getAttributeTypeRegistry();
        if (!registry.hasAttributeType(compareContext.getOid())) {
            throw new LdapInvalidAttributeIdentifierException(compareContext.getOid() + " not found within the attributeType registry");
        }
        AttributeType attrType = registry.lookup(compareContext.getOid());
        Attribute attr = partition.lookup(new LookupOperationContext(compareContext.getDn())).get(attrType.getName());
        if (attr == null) {
            throw new LdapNoSuchAttributeException();
        }
        if (attr.contains(compareContext.getValue())) {
            return true;
        }
        Normalizer normalizer = attrType.getEquality().getNormalizer();
        Object reqVal = normalizer.normalize(compareContext.getValue());
        for (int ii = 0; ii < attr.size(); ++ii) {
            Object attrVal;
            Object attrValObj = normalizer.normalize(attr.get(ii));
            if (attrValObj instanceof String) {
                attrVal = (String)attrValObj;
                if (!(reqVal instanceof String) || !((String)attrVal).equals(reqVal)) continue;
                return true;
            }
            attrVal = (byte[])attrValObj;
            if (reqVal instanceof byte[]) {
                return Arrays.equals((byte[])attrVal, (byte[])reqVal);
            }
            if (!(reqVal instanceof String)) continue;
            return Arrays.equals((byte[])attrVal, StringTools.getBytesUtf8((String)((String)reqVal)));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addContextPartition(AddContextPartitionOperationContext opContext) throws NamingException {
        PartitionConfiguration config = opContext.getPartitionConfiguration();
        Partition partition = opContext.getPartition();
        String key = config.getSuffix();
        if (this.partitions.containsKey(key)) {
            throw new ConfigurationException("Duplicate partition suffix: " + key);
        }
        if (!partition.isInitialized()) {
            partition.init(this.factoryCfg, config);
        }
        BranchNode branchNode = this.partitionLookupTree;
        synchronized (branchNode) {
            LdapDN partitionSuffix = partition.getSuffix();
            if (partitionSuffix == null) {
                throw new ConfigurationException("The current partition does not have any suffix: " + partition.getId());
            }
            this.partitions.put(partitionSuffix.toString(), partition);
            this.partitionLookupTree.recursivelyAddPartition(this.partitionLookupTree, partition.getSuffix(), 0, partition);
            Attribute namingContexts = this.rootDSE.get(NAMINGCTXS_ATTR);
            if (partitionSuffix == null) {
                throw new ConfigurationException("The current partition does not have any suffix: " + partition.getId());
            }
            LdapDN partitionUpSuffix = partition.getUpSuffix();
            if (partitionUpSuffix == null) {
                throw new ConfigurationException("The current partition does not have any user provided suffix: " + partition.getId());
            }
            namingContexts.add(partitionUpSuffix.getUpName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeContextPartition(RemoveContextPartitionOperationContext removeContextPartition) throws NamingException {
        String key = removeContextPartition.getDn().getNormName();
        Partition partition = this.partitions.get(key);
        if (partition == null) {
            throw new NameNotFoundException("No partition with suffix: " + key);
        }
        Attribute namingContexts = this.rootDSE.get(NAMINGCTXS_ATTR);
        namingContexts.remove(partition.getUpSuffix().getUpName());
        BranchNode branchNode = this.partitionLookupTree;
        synchronized (branchNode) {
            this.partitions.remove(key);
            this.partitionLookupTree = new BranchNode();
            for (Partition part : this.partitions.values()) {
                this.partitionLookupTree.recursivelyAddPartition(this.partitionLookupTree, part.getSuffix(), 0, partition);
            }
            partition.sync();
            partition.destroy();
        }
    }

    @Override
    public Partition getSystemPartition() {
        return this.system;
    }

    @Override
    public LdapContext getLdapContext() {
        throw new NotImplementedException();
    }

    @Override
    public LdapDN getMatchedName(GetMatchedNameOperationContext getMatchedNameContext) throws NamingException {
        LdapDN dn = (LdapDN)getMatchedNameContext.getDn().clone();
        while (dn.size() > 0) {
            if (this.hasEntry(new EntryOperationContext(dn))) {
                return dn;
            }
            dn.remove(dn.size() - 1);
        }
        return dn;
    }

    @Override
    public LdapDN getSuffix() {
        return LdapDN.EMPTY_LDAPDN;
    }

    @Override
    public LdapDN getUpSuffix() {
        return LdapDN.EMPTY_LDAPDN;
    }

    @Override
    public LdapDN getSuffix(GetSuffixOperationContext getSuffixContext) throws NamingException {
        Partition backend = this.getPartition(getSuffixContext.getDn());
        return backend.getSuffix();
    }

    @Override
    public Iterator<String> listSuffixes(ListSuffixOperationContext emptyContext) throws NamingException {
        return Collections.unmodifiableSet(this.partitions.keySet()).iterator();
    }

    @Override
    public Attributes getRootDSE(GetRootDSEOperationContext getRootDSEContext) {
        return this.rootDSE;
    }

    private void unregister(Partition partition) throws NamingException {
        Attribute namingContexts = this.rootDSE.get(NAMINGCTXS_ATTR);
        namingContexts.remove(partition.getSuffix().getUpName());
        this.partitions.remove(partition.getSuffix().toString());
    }

    @Override
    public void bind(BindOperationContext bindContext) throws NamingException {
        Partition partition = this.getPartition(bindContext.getDn());
        partition.bind(bindContext);
    }

    @Override
    public void unbind(UnbindOperationContext unbindContext) throws NamingException {
        Partition partition = this.getPartition(unbindContext.getDn());
        partition.unbind(unbindContext);
    }

    @Override
    public void delete(DeleteOperationContext deleteContext) throws NamingException {
        Partition backend = this.getPartition(deleteContext.getDn());
        backend.delete(deleteContext);
    }

    @Override
    public void add(AddOperationContext addContext) throws NamingException {
        Partition backend = this.getPartition(addContext.getDn());
        backend.add(addContext);
    }

    @Override
    public void modify(ModifyOperationContext modifyContext) throws NamingException {
        Partition backend = this.getPartition(modifyContext.getDn());
        backend.modify(modifyContext);
    }

    @Override
    public NamingEnumeration<SearchResult> list(ListOperationContext opContext) throws NamingException {
        Partition backend = this.getPartition(opContext.getDn());
        return backend.list(opContext);
    }

    @Override
    public NamingEnumeration<SearchResult> search(SearchOperationContext opContext) throws NamingException {
        LdapDN base = opContext.getDn();
        SearchControls searchCtls = opContext.getSearchControls();
        ExprNode filter = opContext.getFilter();
        if (base.size() == 0) {
            boolean isObjectScope = searchCtls.getSearchScope() == 0;
            boolean isSearchAll = ((PresenceNode)filter).getAttribute().equals("2.5.4.0");
            if (filter instanceof PresenceNode && isObjectScope && isSearchAll) {
                AttributeType type;
                NamingEnumeration<? extends Attribute> ii;
                ServerSearchResult result;
                String[] ids = searchCtls.getReturningAttributes();
                if (ids == null || ids.length == 0) {
                    ServerSearchResult result2 = new ServerSearchResult("", null, (Attributes)this.getRootDSE(null).clone(), false);
                    return new SingletonEnumeration((Object)result2);
                }
                HashSet<String> realIds = new HashSet<String>();
                boolean containsAsterisk = false;
                boolean containsPlus = false;
                boolean containsOneDotOne = false;
                for (String id : ids) {
                    String idTrimmed = id.trim();
                    if (idTrimmed.equals("*")) {
                        containsAsterisk = true;
                        continue;
                    }
                    if (idTrimmed.equals("+")) {
                        containsPlus = true;
                        continue;
                    }
                    if (idTrimmed.equals("1.1")) {
                        containsOneDotOne = true;
                        continue;
                    }
                    try {
                        realIds.add(this.oidRegistry.getOid(idTrimmed));
                    }
                    catch (NamingException e) {
                        realIds.add(idTrimmed);
                    }
                }
                if (containsOneDotOne) {
                    result = new ServerSearchResult("", null, (Attributes)new AttributesImpl(), false);
                    return new SingletonEnumeration((Object)result);
                }
                if (containsAsterisk && containsPlus) {
                    result = new ServerSearchResult("", null, (Attributes)this.getRootDSE(null).clone(), false);
                    return new SingletonEnumeration((Object)result);
                }
                AttributesImpl attrs = new AttributesImpl();
                if (containsAsterisk) {
                    ii = this.getRootDSE(null).getAll();
                    while (ii.hasMore()) {
                        Attribute attr = ii.next();
                        type = this.attrRegistry.lookup(attr.getID());
                        if (type.getUsage() == UsageEnum.USER_APPLICATIONS) {
                            attrs.put(attr);
                            continue;
                        }
                        if (!realIds.contains(type.getOid())) continue;
                        attrs.put(attr);
                    }
                } else if (containsPlus) {
                    ii = this.getRootDSE(null).getAll();
                    while (ii.hasMore()) {
                        Attribute attr = ii.next();
                        type = this.attrRegistry.lookup(attr.getID());
                        if (type.getUsage() != UsageEnum.USER_APPLICATIONS) {
                            attrs.put(attr);
                            continue;
                        }
                        if (!realIds.contains(type.getOid())) continue;
                        attrs.put(attr);
                    }
                } else {
                    ii = this.getRootDSE(null).getAll();
                    while (ii.hasMore()) {
                        Attribute attr = ii.next();
                        type = this.attrRegistry.lookup(attr.getID());
                        if (!realIds.contains(type.getOid())) continue;
                        attrs.put(attr);
                    }
                }
                ServerSearchResult result3 = new ServerSearchResult("", null, (Attributes)attrs, false);
                return new SingletonEnumeration((Object)result3);
            }
            throw new LdapNameNotFoundException();
        }
        Partition backend = this.getPartition(base);
        return backend.search(opContext);
    }

    @Override
    public Attributes lookup(LookupOperationContext opContext) throws NamingException {
        LdapDN dn = opContext.getDn();
        if (dn.size() == 0) {
            AttributesImpl retval = new AttributesImpl();
            NamingEnumeration<String> list = this.rootDSE.getIDs();
            if (opContext.getAttrsId() != null) {
                while (list.hasMore()) {
                    String id = list.next();
                    if (!opContext.getAttrsId().contains(id)) continue;
                    Attribute attr = this.rootDSE.get(id);
                    retval.put((Attribute)attr.clone());
                }
            } else {
                while (list.hasMore()) {
                    String id = list.next();
                    Attribute attr = this.rootDSE.get(id);
                    retval.put((Attribute)attr.clone());
                }
            }
            return retval;
        }
        Partition backend = this.getPartition(dn);
        return backend.lookup(opContext);
    }

    @Override
    public boolean hasEntry(EntryOperationContext opContext) throws NamingException {
        LdapDN dn = opContext.getDn();
        if (IS_DEBUG) {
            log.debug("Check if DN '" + dn + "' exists.");
        }
        if (dn.size() == 0) {
            return true;
        }
        Partition backend = this.getPartition(dn);
        return backend.hasEntry(opContext);
    }

    @Override
    public void rename(RenameOperationContext opContext) throws NamingException {
        Partition backend = this.getPartition(opContext.getDn());
        backend.rename(opContext);
    }

    @Override
    public void move(MoveOperationContext opContext) throws NamingException {
        Partition backend = this.getPartition(opContext.getDn());
        backend.move(opContext);
    }

    @Override
    public void moveAndRename(MoveAndRenameOperationContext opContext) throws NamingException {
        Partition backend = this.getPartition(opContext.getDn());
        backend.moveAndRename(opContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Partition getPartition(LdapDN dn) throws NamingException {
        Enumeration rdns = dn.getAll();
        Node currentNode = this.partitionLookupTree;
        BranchNode branchNode = this.partitionLookupTree;
        synchronized (branchNode) {
            while (rdns.hasMoreElements()) {
                String rdn = (String)rdns.nextElement();
                if (currentNode == null) break;
                if (currentNode instanceof LeafNode) {
                    return ((LeafNode)currentNode).getPartition();
                }
                BranchNode currentBranch = currentNode;
                if (!currentBranch.contains(rdn) || !((currentNode = currentBranch.getChild(rdn)) instanceof LeafNode)) continue;
                return ((LeafNode)currentNode).getPartition();
            }
        }
        throw new LdapNameNotFoundException(dn.getUpName());
    }

    @Override
    public void registerSupportedExtensions(Set<String> extensionOids) {
        Attribute supportedExtension = this.rootDSE.get("supportedExtension");
        if (supportedExtension == null) {
            supportedExtension = new AttributeImpl("supportedExtension");
            this.rootDSE.put(supportedExtension);
        }
        Iterator<String> oids = extensionOids.iterator();
        while (oids.hasNext()) {
            supportedExtension.add(oids.next());
        }
    }
}

