/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.directory.server.core.partition.impl.btree.IndexRecord;

public class DisjunctionEnumeration
implements NamingEnumeration {
    private final NamingEnumeration[] children;
    private final Map candidates = new HashMap();
    private int index = 0;
    private final IndexRecord candidate = new IndexRecord();
    private final IndexRecord prefetched = new IndexRecord();
    private boolean hasMore = true;

    public DisjunctionEnumeration(NamingEnumeration[] children) throws NamingException {
        this.children = children;
        if (children.length <= 0) {
            this.hasMore = false;
            return;
        }
        while (!children[this.index].hasMore()) {
            ++this.index;
            if (this.index < children.length) continue;
            this.close();
            return;
        }
        IndexRecord rec = (IndexRecord)children[this.index].next();
        this.prefetched.copy(rec);
        this.candidates.put(rec.getEntryId(), rec.getEntryId());
    }

    public Object nextElement() {
        try {
            return this.next();
        }
        catch (NamingException e) {
            throw new NoSuchElementException();
        }
    }

    public boolean hasMoreElements() {
        return this.hasMore();
    }

    public Object next() throws NamingException {
        this.candidate.copy(this.prefetched);
        while (true) {
            if (!this.children[this.index].hasMore()) {
                ++this.index;
                if (this.index < this.children.length) continue;
                this.close();
                return this.candidate;
            }
            IndexRecord rec = (IndexRecord)this.children[this.index].next();
            this.prefetched.copy(rec);
            if (!this.candidates.containsKey(this.prefetched.getEntryId())) break;
        }
        this.candidates.put(this.candidate.getEntryId(), this.candidate.getEntryId());
        return this.candidate;
    }

    public boolean hasMore() {
        return this.hasMore;
    }

    public void close() throws NamingException {
        Throwable throwable = null;
        this.hasMore = false;
        for (int ii = 0; ii < this.children.length; ++ii) {
            try {
                this.children[ii].close();
                continue;
            }
            catch (Throwable t) {
                throwable = t;
            }
        }
        if (null != throwable && throwable instanceof NamingException) {
            throw (NamingException)throwable;
        }
        if (null != throwable) {
            NamingException ne = new NamingException();
            ne.setRootCause(throwable);
            throw ne;
        }
    }
}

