/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.directory.server.core.partition.impl.btree.BTreePartition;
import org.apache.directory.server.core.partition.impl.btree.Enumerator;
import org.apache.directory.server.core.partition.impl.btree.Index;
import org.apache.directory.server.core.partition.impl.btree.IndexAssertion;
import org.apache.directory.server.core.partition.impl.btree.IndexAssertionEnumeration;
import org.apache.directory.server.core.partition.impl.btree.IndexEnumeration;
import org.apache.directory.server.core.partition.impl.btree.IndexRecord;
import org.apache.directory.server.core.partition.impl.btree.SubstringEvaluator;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.SubstringNode;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.Normalizer;

public class SubstringEnumerator
implements Enumerator {
    private final BTreePartition db;
    private final SubstringEvaluator evaluator;
    private final AttributeTypeRegistry attributeTypeRegistry;

    public SubstringEnumerator(BTreePartition db, AttributeTypeRegistry attributeTypeRegistry, SubstringEvaluator evaluator) {
        this.db = db;
        this.evaluator = evaluator;
        this.attributeTypeRegistry = attributeTypeRegistry;
    }

    public NamingEnumeration enumerate(final ExprNode node) throws NamingException {
        Pattern regex = null;
        Index idx = null;
        SubstringNode snode = (SubstringNode)node;
        AttributeType type = this.attributeTypeRegistry.lookup(snode.getAttribute());
        Normalizer normalizer = type.getSubstr().getNormalizer();
        if (this.db.hasUserIndexOn(snode.getAttribute())) {
            try {
                regex = snode.getRegex(normalizer);
            }
            catch (PatternSyntaxException e) {
                NamingException ne = new NamingException("SubstringNode '" + node + "' had incorrect syntax");
                ne.setRootCause(e);
                throw ne;
            }
            idx = this.db.getUserIndex(snode.getAttribute());
            if (null == snode.getInitial()) {
                return idx.listIndices(regex);
            }
            return idx.listIndices(regex, snode.getInitial());
        }
        IndexEnumeration underlying = this.db.getNdnIndex().listIndices();
        IndexAssertion assertion = new IndexAssertion(){

            public boolean assertCandidate(IndexRecord record) throws NamingException {
                return SubstringEnumerator.this.evaluator.evaluate(node, record);
            }
        };
        return new IndexAssertionEnumeration((NamingEnumeration)underlying, assertion);
    }
}

