/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.schema.AbstractSchemaObject;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.MatchingRuleUse;
import org.apache.directory.shared.ldap.schema.MutableSchemaObject;

public class MatchingRuleUseImpl
extends AbstractSchemaObject
implements MatchingRuleUse,
MutableSchemaObject {
    private static final long serialVersionUID = 1L;
    private static final AttributeType[] EMPTY_ATTRIBUTES = new AttributeType[0];
    private static final String[] EMPTY_STRINGS = new String[0];
    private final Registries registries;
    private AttributeType[] applicableAttributes = EMPTY_ATTRIBUTES;
    private String[] applicableAttributesOids;

    protected MatchingRuleUseImpl(String oid, Registries registries) {
        super(oid);
        this.registries = registries;
    }

    public MatchingRule getMatchingRule() throws NamingException {
        return this.registries.getMatchingRuleRegistry().lookup(this.getOid());
    }

    public AttributeType[] getApplicableAttributes() throws NamingException {
        if (this.applicableAttributesOids == null || this.applicableAttributesOids == EMPTY_STRINGS) {
            return EMPTY_ATTRIBUTES;
        }
        for (int ii = 0; ii < this.applicableAttributesOids.length; ++ii) {
            this.applicableAttributes[ii] = this.registries.getAttributeTypeRegistry().lookup(this.applicableAttributesOids[ii]);
        }
        return this.applicableAttributes;
    }

    public void setApplicableAttributesOids(String[] applicableAttributesOids) {
        this.applicableAttributesOids = applicableAttributesOids;
        if (applicableAttributesOids == null) {
            this.applicableAttributesOids = EMPTY_STRINGS;
            this.applicableAttributes = EMPTY_ATTRIBUTES;
        } else {
            this.applicableAttributesOids = applicableAttributesOids;
            this.applicableAttributes = new AttributeType[applicableAttributesOids.length];
        }
    }

    public void setNames(String[] names) {
        super.setNames(names);
    }

    public void setDescription(String description) {
        super.setDescription(description);
    }

    public void setObsolete(boolean obsolete) {
        super.setObsolete(obsolete);
    }

    public void setSchema(String schemaName) {
        super.setSchema(schemaName);
    }
}

