/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.schema.SchemaEntityFactory;
import org.apache.directory.server.schema.bootstrap.Schema;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.filter.AssertionEnum;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.message.AttributeImpl;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.syntax.NumericOidSyntaxChecker;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaPartitionDao {
    private static final Logger log = LoggerFactory.getLogger(SchemaPartitionDao.class);
    private static final NumericOidSyntaxChecker NUMERIC_OID_CHECKER = new NumericOidSyntaxChecker();
    private static final String[] SCHEMA_ATTRIBUTES = new String[]{"creatorsName", "m-dependencies", "objectClass", "cn", "m-disabled"};
    private final Partition partition;
    private final Registries bootstrapRegistries;
    private final SchemaEntityFactory factory;
    private final OidRegistry oidRegistry;
    private final AttributeTypeRegistry attrRegistry;
    private final String M_NAME_OID;
    private final String CN_OID;
    private final String M_OID_OID;
    private final String OBJECTCLASS_OID;
    private final String M_SYNTAX_OID;
    private final String M_ORDERING_OID;
    private final String M_SUBSTRING_OID;
    private final String M_EQUALITY_OID;
    private final String M_SUP_ATTRIBUTE_TYPE_OID;
    private final String M_MUST_OID;
    private final String M_MAY_OID;
    private final String M_AUX_OID;
    private final String M_OC_OID;
    private final String M_SUP_OBJECT_CLASS_OID;
    private final String M_DEPENDENCIES_OID;
    private final AttributeType disabledAttributeType;

    public SchemaPartitionDao(Partition partition, Registries bootstrapRegistries) throws NamingException {
        this.partition = partition;
        this.bootstrapRegistries = bootstrapRegistries;
        this.factory = new SchemaEntityFactory(this.bootstrapRegistries);
        this.oidRegistry = this.bootstrapRegistries.getOidRegistry();
        this.attrRegistry = this.bootstrapRegistries.getAttributeTypeRegistry();
        this.M_NAME_OID = this.oidRegistry.getOid("m-name");
        this.CN_OID = this.oidRegistry.getOid("cn");
        this.disabledAttributeType = this.attrRegistry.lookup("m-disabled");
        this.M_OID_OID = this.oidRegistry.getOid("m-oid");
        this.OBJECTCLASS_OID = this.oidRegistry.getOid("objectClass");
        this.M_SYNTAX_OID = this.oidRegistry.getOid("m-syntax");
        this.M_ORDERING_OID = this.oidRegistry.getOid("m-ordering");
        this.M_EQUALITY_OID = this.oidRegistry.getOid("m-equality");
        this.M_SUBSTRING_OID = this.oidRegistry.getOid("m-substr");
        this.M_SUP_ATTRIBUTE_TYPE_OID = this.oidRegistry.getOid("m-supAttributeType");
        this.M_MUST_OID = this.oidRegistry.getOid("m-must");
        this.M_MAY_OID = this.oidRegistry.getOid("m-may");
        this.M_AUX_OID = this.oidRegistry.getOid("m-aux");
        this.M_OC_OID = this.oidRegistry.getOid("m-oc");
        this.M_SUP_OBJECT_CLASS_OID = this.oidRegistry.getOid("m-supObjectClass");
        this.M_DEPENDENCIES_OID = this.oidRegistry.getOid("m-dependencies");
    }

    public Map<String, Schema> getSchemas() throws NamingException {
        HashMap<String, Schema> schemas = new HashMap<String, Schema>();
        NamingEnumeration list = this.listSchemas();
        while (list.hasMore()) {
            SearchResult sr = (SearchResult)list.next();
            Schema schema = this.factory.getSchema(sr.getAttributes());
            schemas.put(schema.getSchemaName(), schema);
        }
        return schemas;
    }

    public Set<String> getSchemaNames() throws NamingException {
        HashSet<String> schemaNames = new HashSet<String>();
        NamingEnumeration list = this.listSchemas();
        while (list.hasMore()) {
            SearchResult sr = (SearchResult)list.next();
            schemaNames.add((String)sr.getAttributes().get("cn").get());
        }
        return schemaNames;
    }

    private NamingEnumeration listSchemas() throws NamingException {
        LdapDN base = new LdapDN("ou=schema");
        base.normalize(this.attrRegistry.getNormalizerMapping());
        SimpleNode filter = new SimpleNode(this.oidRegistry.getOid("objectClass"), "metaSchema", AssertionEnum.EQUALITY);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(1);
        searchControls.setReturningAttributes(SCHEMA_ATTRIBUTES);
        return this.partition.search(new SearchOperationContext(base, new HashMap(), (ExprNode)filter, searchControls));
    }

    public Schema getSchema(String schemaName) throws NamingException {
        LdapDN dn = new LdapDN("cn=" + schemaName + ",ou=schema");
        dn.normalize(this.attrRegistry.getNormalizerMapping());
        return this.factory.getSchema(this.partition.lookup(new LookupOperationContext(dn)));
    }

    public Schema getSchema(String schemaName, Properties schemaProperties) throws NamingException {
        return this.getSchema(schemaName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMatchingRule(String oid) throws NamingException {
        BranchNode filter = new BranchNode(AssertionEnum.AND);
        filter.addNode((ExprNode)new SimpleNode(this.OBJECTCLASS_OID, "metaMatchingRule", AssertionEnum.EQUALITY));
        if (NUMERIC_OID_CHECKER.isValidSyntax((Object)oid)) {
            filter.addNode((ExprNode)new SimpleNode(this.M_OID_OID, oid, AssertionEnum.EQUALITY));
        } else {
            filter.addNode((ExprNode)new SimpleNode(this.M_NAME_OID, oid.toLowerCase(), AssertionEnum.EQUALITY));
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        NamingEnumeration<SearchResult> ne = null;
        try {
            ne = this.partition.search(new SearchOperationContext(this.partition.getSuffix(), new HashMap(), (ExprNode)filter, searchControls));
            if (!ne.hasMore()) {
                boolean bl = false;
                return bl;
            }
            ne.next();
            if (ne.hasMore()) {
                throw new NamingException("Got more than one matchingRule for oid of " + oid);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            ne.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAttributeType(String oid) throws NamingException {
        BranchNode filter = new BranchNode(AssertionEnum.AND);
        filter.addNode((ExprNode)new SimpleNode(this.OBJECTCLASS_OID, "metaAttributeType", AssertionEnum.EQUALITY));
        if (NUMERIC_OID_CHECKER.isValidSyntax((Object)oid)) {
            filter.addNode((ExprNode)new SimpleNode(this.M_OID_OID, oid, AssertionEnum.EQUALITY));
        } else {
            filter.addNode((ExprNode)new SimpleNode(this.M_NAME_OID, oid.toLowerCase(), AssertionEnum.EQUALITY));
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        NamingEnumeration<SearchResult> ne = null;
        try {
            ne = this.partition.search(new SearchOperationContext(this.partition.getSuffix(), new HashMap(), (ExprNode)filter, searchControls));
            if (!ne.hasMore()) {
                boolean bl = false;
                return bl;
            }
            ne.next();
            if (ne.hasMore()) {
                throw new NamingException("Got more than one attributeType for oid of " + oid);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            ne.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasObjectClass(String oid) throws NamingException {
        BranchNode filter = new BranchNode(AssertionEnum.AND);
        filter.addNode((ExprNode)new SimpleNode(this.OBJECTCLASS_OID, "metaObjectClass", AssertionEnum.EQUALITY));
        if (NUMERIC_OID_CHECKER.isValidSyntax((Object)oid)) {
            filter.addNode((ExprNode)new SimpleNode(this.M_OID_OID, oid, AssertionEnum.EQUALITY));
        } else {
            filter.addNode((ExprNode)new SimpleNode(this.M_NAME_OID, oid.toLowerCase(), AssertionEnum.EQUALITY));
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        NamingEnumeration<SearchResult> ne = null;
        try {
            ne = this.partition.search(new SearchOperationContext(this.partition.getSuffix(), new HashMap(), (ExprNode)filter, searchControls));
            if (!ne.hasMore()) {
                boolean bl = false;
                return bl;
            }
            ne.next();
            if (ne.hasMore()) {
                throw new NamingException("Got more than one attributeType for oid of " + oid);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            ne.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSyntax(String oid) throws NamingException {
        BranchNode filter = new BranchNode(AssertionEnum.AND);
        filter.addNode((ExprNode)new SimpleNode(this.OBJECTCLASS_OID, "metaSyntax", AssertionEnum.EQUALITY));
        if (NUMERIC_OID_CHECKER.isValidSyntax((Object)oid)) {
            filter.addNode((ExprNode)new SimpleNode(this.M_OID_OID, oid, AssertionEnum.EQUALITY));
        } else {
            filter.addNode((ExprNode)new SimpleNode(this.M_NAME_OID, oid.toLowerCase(), AssertionEnum.EQUALITY));
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        NamingEnumeration<SearchResult> ne = null;
        try {
            ne = this.partition.search(new SearchOperationContext(this.partition.getSuffix(), new HashMap(), (ExprNode)filter, searchControls));
            if (!ne.hasMore()) {
                boolean bl = false;
                return bl;
            }
            ne.next();
            if (ne.hasMore()) {
                throw new NamingException("Got more than one syntax for oid of " + oid);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            ne.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSyntaxChecker(String oid) throws NamingException {
        BranchNode filter = new BranchNode(AssertionEnum.AND);
        filter.addNode((ExprNode)new SimpleNode(this.OBJECTCLASS_OID, "metaSyntaxChecker", AssertionEnum.EQUALITY));
        if (NUMERIC_OID_CHECKER.isValidSyntax((Object)oid)) {
            filter.addNode((ExprNode)new SimpleNode(this.M_OID_OID, oid, AssertionEnum.EQUALITY));
        } else {
            filter.addNode((ExprNode)new SimpleNode(this.M_NAME_OID, oid.toLowerCase(), AssertionEnum.EQUALITY));
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        NamingEnumeration<SearchResult> ne = null;
        try {
            ne = this.partition.search(new SearchOperationContext(this.partition.getSuffix(), new HashMap(), (ExprNode)filter, searchControls));
            if (!ne.hasMore()) {
                boolean bl = false;
                return bl;
            }
            ne.next();
            if (ne.hasMore()) {
                throw new NamingException("Got more than one syntaxChecker for oid of " + oid);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            ne.close();
        }
    }

    public String findSchema(String entityName) throws NamingException {
        LdapDN dn = this.findDn(entityName);
        if (dn == null) {
            return null;
        }
        Rdn rdn = dn.getRdn(1);
        if (!rdn.getNormType().equalsIgnoreCase(this.CN_OID)) {
            throw new NamingException("Attribute of second rdn in dn '" + dn.toNormName() + "' expected to be CN oid of " + this.CN_OID + " but was " + rdn.getNormType());
        }
        return (String)rdn.getValue();
    }

    public LdapDN findDn(String entityName) throws NamingException {
        SearchResult sr = this.find(entityName);
        LdapDN dn = new LdapDN(sr.getName());
        dn.normalize(this.attrRegistry.getNormalizerMapping());
        return dn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchResult find(String entityName) throws NamingException {
        BranchNode filter = new BranchNode(AssertionEnum.OR);
        SimpleNode nameAVA = new SimpleNode(this.M_NAME_OID, entityName.toLowerCase(), AssertionEnum.EQUALITY);
        SimpleNode oidAVA = new SimpleNode(this.M_OID_OID, entityName.toLowerCase(), AssertionEnum.EQUALITY);
        filter.addNode((ExprNode)nameAVA);
        filter.addNode((ExprNode)oidAVA);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        NamingEnumeration<SearchResult> ne = null;
        try {
            ne = this.partition.search(new SearchOperationContext(this.partition.getSuffix(), new HashMap(), (ExprNode)filter, searchControls));
            if (!ne.hasMore()) {
                SearchResult searchResult = null;
                return searchResult;
            }
            SearchResult sr = ne.next();
            if (ne.hasMore()) {
                throw new NamingException("Got more than one result for the entity name: " + entityName);
            }
            SearchResult searchResult = sr;
            return searchResult;
        }
        finally {
            if (ne != null) {
                ne.close();
            }
        }
    }

    public void enableSchema(String schemaName) throws NamingException {
        LdapDN dn = new LdapDN("cn=" + schemaName + ",ou=schema");
        dn.normalize(this.attrRegistry.getNormalizerMapping());
        Attributes entry = this.partition.lookup(new LookupOperationContext(dn));
        Attribute disabledAttr = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.disabledAttributeType);
        ModificationItemImpl[] mods = new ModificationItemImpl[3];
        if (disabledAttr == null) {
            log.warn("Does not make sense: you're trying to enable {} schema which is already enabled", (Object)schemaName);
            return;
        }
        boolean isDisabled = ((String)disabledAttr.get()).equalsIgnoreCase("TRUE");
        if (!isDisabled) {
            log.warn("Does not make sense: you're trying to enable {} schema which is already enabled", (Object)schemaName);
            return;
        }
        mods[0] = new ModificationItemImpl(3, (Attribute)new AttributeImpl("m-disabled"));
        mods[1] = new ModificationItemImpl(1, (Attribute)new AttributeImpl("modifiersName", (Object)"uid=admin,ou=system"));
        mods[2] = new ModificationItemImpl(1, (Attribute)new AttributeImpl("modifyTimestamp", (Object)DateUtils.getGeneralizedTime()));
        this.partition.modify(new ModifyOperationContext(dn, mods));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<SearchResult> listSyntaxDependents(String numericOid) throws NamingException {
        HashSet<SearchResult> set = new HashSet<SearchResult>();
        BranchNode filter = new BranchNode(AssertionEnum.AND);
        BranchNode or = new BranchNode(AssertionEnum.OR);
        or.addNode((ExprNode)new SimpleNode(this.OBJECTCLASS_OID, "metaMatchingRule".toLowerCase(), AssertionEnum.EQUALITY));
        or.addNode((ExprNode)new SimpleNode(this.OBJECTCLASS_OID, "metaAttributeType".toLowerCase(), AssertionEnum.EQUALITY));
        filter.addNode((ExprNode)or);
        filter.addNode((ExprNode)new SimpleNode(this.M_SYNTAX_OID, numericOid.toLowerCase(), AssertionEnum.EQUALITY));
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        NamingEnumeration<SearchResult> ne = null;
        try {
            ne = this.partition.search(new SearchOperationContext(this.partition.getSuffix(), new HashMap(), (ExprNode)filter, searchControls));
            while (ne.hasMore()) {
                set.add(ne.next());
            }
        }
        finally {
            if (ne != null) {
                ne.close();
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<SearchResult> listMatchingRuleDependents(MatchingRule mr) throws NamingException {
        HashSet<SearchResult> set = new HashSet<SearchResult>();
        BranchNode filter = new BranchNode(AssertionEnum.AND);
        filter.addNode((ExprNode)new SimpleNode(this.OBJECTCLASS_OID, "metaAttributeType".toLowerCase(), AssertionEnum.EQUALITY));
        BranchNode or = new BranchNode(AssertionEnum.OR);
        or.addNode((ExprNode)new SimpleNode(this.M_ORDERING_OID, mr.getOid(), AssertionEnum.EQUALITY));
        or.addNode((ExprNode)new SimpleNode(this.M_SUBSTRING_OID, mr.getOid(), AssertionEnum.EQUALITY));
        or.addNode((ExprNode)new SimpleNode(this.M_EQUALITY_OID, mr.getOid(), AssertionEnum.EQUALITY));
        filter.addNode((ExprNode)or);
        if (mr.getNames() != null || mr.getNames().length > 0) {
            for (String name : mr.getNames()) {
                or.addNode((ExprNode)new SimpleNode(this.M_ORDERING_OID, name.toLowerCase(), AssertionEnum.EQUALITY));
                or.addNode((ExprNode)new SimpleNode(this.M_SUBSTRING_OID, name.toLowerCase(), AssertionEnum.EQUALITY));
                or.addNode((ExprNode)new SimpleNode(this.M_EQUALITY_OID, name.toLowerCase(), AssertionEnum.EQUALITY));
            }
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        NamingEnumeration<SearchResult> ne = null;
        try {
            ne = this.partition.search(new SearchOperationContext(this.partition.getSuffix(), new HashMap(), (ExprNode)filter, searchControls));
            while (ne.hasMore()) {
                set.add(ne.next());
            }
        }
        finally {
            if (ne != null) {
                ne.close();
            }
        }
        return set;
    }

    public NamingEnumeration listAllNames() throws NamingException {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        BranchNode filter = new BranchNode(AssertionEnum.AND);
        filter.addNode((ExprNode)new PresenceNode(this.M_OID_OID));
        filter.addNode((ExprNode)new PresenceNode(this.M_NAME_OID));
        return this.partition.search(new SearchOperationContext(this.partition.getSuffix(), new HashMap(), (ExprNode)filter, searchControls));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<SearchResult> listAttributeTypeDependents(AttributeType at) throws NamingException {
        HashSet<SearchResult> set = new HashSet<SearchResult>();
        BranchNode filter = new BranchNode(AssertionEnum.AND);
        BranchNode or = new BranchNode(AssertionEnum.OR);
        or.addNode((ExprNode)new SimpleNode(this.OBJECTCLASS_OID, "metaAttributeType".toLowerCase(), AssertionEnum.EQUALITY));
        or.addNode((ExprNode)new SimpleNode(this.OBJECTCLASS_OID, "metaObjectClass".toLowerCase(), AssertionEnum.EQUALITY));
        filter.addNode((ExprNode)or);
        or = new BranchNode(AssertionEnum.OR);
        or.addNode((ExprNode)new SimpleNode(this.M_MAY_OID, at.getOid(), AssertionEnum.EQUALITY));
        or.addNode((ExprNode)new SimpleNode(this.M_MUST_OID, at.getOid(), AssertionEnum.EQUALITY));
        or.addNode((ExprNode)new SimpleNode(this.M_SUP_ATTRIBUTE_TYPE_OID, at.getOid(), AssertionEnum.EQUALITY));
        filter.addNode((ExprNode)or);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        NamingEnumeration<SearchResult> ne = null;
        try {
            ne = this.partition.search(new SearchOperationContext(this.partition.getSuffix(), new HashMap(), (ExprNode)filter, searchControls));
            while (ne.hasMore()) {
                set.add(ne.next());
            }
        }
        finally {
            if (ne != null) {
                ne.close();
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<SearchResult> listSchemaDependents(String schemaName) throws NamingException {
        HashSet<SearchResult> set = new HashSet<SearchResult>();
        BranchNode filter = new BranchNode(AssertionEnum.AND);
        filter.addNode((ExprNode)new SimpleNode(this.OBJECTCLASS_OID, "metaSchema".toLowerCase(), AssertionEnum.EQUALITY));
        filter.addNode((ExprNode)new SimpleNode(this.M_DEPENDENCIES_OID, schemaName.toLowerCase(), AssertionEnum.EQUALITY));
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(1);
        NamingEnumeration<SearchResult> ne = null;
        try {
            ne = this.partition.search(new SearchOperationContext(this.partition.getSuffix(), new HashMap(), (ExprNode)filter, searchControls));
            while (ne.hasMore()) {
                set.add(ne.next());
            }
        }
        finally {
            if (ne != null) {
                ne.close();
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<SearchResult> listEnabledSchemaDependents(String schemaName) throws NamingException {
        HashSet<SearchResult> set = new HashSet<SearchResult>();
        BranchNode filter = new BranchNode(AssertionEnum.AND);
        filter.addNode((ExprNode)new SimpleNode(this.OBJECTCLASS_OID, "metaSchema".toLowerCase(), AssertionEnum.EQUALITY));
        filter.addNode((ExprNode)new SimpleNode(this.M_DEPENDENCIES_OID, schemaName.toLowerCase(), AssertionEnum.EQUALITY));
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(1);
        NamingEnumeration<SearchResult> ne = null;
        try {
            ne = this.partition.search(new SearchOperationContext(this.partition.getSuffix(), new HashMap(), (ExprNode)filter, searchControls));
            while (ne.hasMore()) {
                SearchResult sr = ne.next();
                Attribute disabled = AttributeUtils.getAttribute((Attributes)sr.getAttributes(), (AttributeType)this.disabledAttributeType);
                if (disabled == null) {
                    set.add(sr);
                    continue;
                }
                if (!disabled.get().equals("FALSE")) continue;
                set.add(sr);
            }
        }
        finally {
            if (ne != null) {
                ne.close();
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<SearchResult> listObjectClassDependents(ObjectClass oc) throws NamingException {
        HashSet<SearchResult> set = new HashSet<SearchResult>();
        BranchNode filter = new BranchNode(AssertionEnum.AND);
        BranchNode or = new BranchNode(AssertionEnum.OR);
        or.addNode((ExprNode)new SimpleNode(this.OBJECTCLASS_OID, "metaNameForm".toLowerCase(), AssertionEnum.EQUALITY));
        or.addNode((ExprNode)new SimpleNode(this.OBJECTCLASS_OID, "metaObjectClass".toLowerCase(), AssertionEnum.EQUALITY));
        or.addNode((ExprNode)new SimpleNode(this.OBJECTCLASS_OID, "metaDITContentRule".toLowerCase(), AssertionEnum.EQUALITY));
        filter.addNode((ExprNode)or);
        or = new BranchNode(AssertionEnum.OR);
        or.addNode((ExprNode)new SimpleNode(this.M_AUX_OID, oc.getOid(), AssertionEnum.EQUALITY));
        or.addNode((ExprNode)new SimpleNode(this.M_OC_OID, oc.getOid(), AssertionEnum.EQUALITY));
        or.addNode((ExprNode)new SimpleNode(this.M_SUP_OBJECT_CLASS_OID, oc.getOid(), AssertionEnum.EQUALITY));
        filter.addNode((ExprNode)or);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        NamingEnumeration<SearchResult> ne = null;
        try {
            ne = this.partition.search(new SearchOperationContext(this.partition.getSuffix(), new HashMap(), (ExprNode)filter, searchControls));
            while (ne.hasMore()) {
                set.add(ne.next());
            }
        }
        finally {
            if (ne != null) {
                ne.close();
            }
        }
        return set;
    }
}

