/*
 * Decompiled with CFR 0.152.
 */
package com.novemberain.quartz.mongodb.cluster;

import com.mongodb.MongoException;
import com.novemberain.quartz.mongodb.dao.SchedulerDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckinTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(CheckinTask.class);
    private static final Runnable DEFAULT_ERROR_HANDLER = new Runnable(){

        @Override
        public void run() {
        }
    };
    private SchedulerDao schedulerDao;
    private Runnable errorhandler = DEFAULT_ERROR_HANDLER;

    public CheckinTask(SchedulerDao schedulerDao) {
        this.schedulerDao = schedulerDao;
    }

    public void setErrorHandler(Runnable errorhandler) {
        this.errorhandler = errorhandler;
    }

    @Override
    public void run() {
        log.info("Node {}:{} checks-in.", (Object)this.schedulerDao.schedulerName, (Object)this.schedulerDao.instanceId);
        try {
            this.schedulerDao.checkIn();
        }
        catch (MongoException e) {
            log.error("Node " + this.schedulerDao.instanceId + " could not check-in: " + e.getMessage(), (Throwable)e);
            this.errorhandler.run();
        }
    }
}

