/*
 * Decompiled with CFR 0.152.
 */
package com.novemberain.quartz.mongodb.dao;

import com.mongodb.MongoWriteException;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.model.UpdateOptions;
import com.novemberain.quartz.mongodb.trigger.TriggerConverter;
import com.novemberain.quartz.mongodb.util.Keys;
import com.novemberain.quartz.mongodb.util.QueryHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.spi.OperableTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerDao {
    private static final Logger log = LoggerFactory.getLogger(TriggerDao.class);
    private MongoCollection<Document> triggerCollection;
    private QueryHelper queryHelper;
    private TriggerConverter triggerConverter;

    public TriggerDao(MongoCollection<Document> triggerCollection, QueryHelper queryHelper, TriggerConverter triggerConverter) {
        this.triggerCollection = triggerCollection;
        this.queryHelper = queryHelper;
        this.triggerConverter = triggerConverter;
    }

    public void createIndex() {
        this.triggerCollection.createIndex(Keys.KEY_AND_GROUP_FIELDS, new IndexOptions().unique(true));
    }

    public void dropIndex() {
        this.triggerCollection.dropIndex("keyName_1_keyGroup_1");
    }

    public void clear() {
        this.triggerCollection.deleteMany((Bson)new Document());
    }

    public MongoCollection<Document> getCollection() {
        return this.triggerCollection;
    }

    public boolean exists(Bson filter) {
        return this.triggerCollection.count(filter) > 0L;
    }

    public FindIterable<Document> findEligibleToRun(Date noLaterThanDate) {
        Bson query = this.createNextTriggerQuery(noLaterThanDate);
        if (log.isInfoEnabled()) {
            log.info("Found {} triggers which are eligible to be run.", (Object)this.getCount(query));
        }
        return this.triggerCollection.find(query).sort(Sorts.ascending((String[])new String[]{"nextFireTime"}));
    }

    public Document findTrigger(Bson filter) {
        return (Document)this.triggerCollection.find(filter).first();
    }

    public int getCount() {
        return (int)this.triggerCollection.count();
    }

    public List<String> getGroupNames() {
        return (List)this.triggerCollection.distinct("keyGroup", String.class).into(new ArrayList());
    }

    public String getState(TriggerKey triggerKey) {
        Document doc = this.findTrigger(triggerKey);
        return doc.getString((Object)"state");
    }

    public OperableTrigger getTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        Document doc = this.findTrigger(Keys.toFilter(triggerKey));
        if (doc == null) {
            return null;
        }
        return this.triggerConverter.toTrigger(triggerKey, doc);
    }

    public List<OperableTrigger> getTriggersForJob(Document doc) throws JobPersistenceException {
        LinkedList<OperableTrigger> triggers = new LinkedList<OperableTrigger>();
        if (doc != null) {
            for (Document item : this.findByJobId(doc.get((Object)"_id"))) {
                triggers.add(this.triggerConverter.toTrigger(item));
            }
        }
        return triggers;
    }

    public Set<TriggerKey> getTriggerKeys(GroupMatcher<TriggerKey> matcher) {
        HashSet<TriggerKey> keys = new HashSet<TriggerKey>();
        Bson query = this.queryHelper.matchingKeysConditionFor(matcher);
        for (Document doc : this.triggerCollection.find(query).projection(Keys.KEY_AND_GROUP_FIELDS)) {
            keys.add(Keys.toTriggerKey(doc));
        }
        return keys;
    }

    public boolean hasLastTrigger(Document job) {
        List referencedTriggers = (List)this.triggerCollection.find(Filters.eq((String)"jobId", (Object)job.get((Object)"_id"))).limit(2).into(new ArrayList(2));
        return referencedTriggers.size() == 1;
    }

    public void insert(Document trigger, Trigger offendingTrigger) throws ObjectAlreadyExistsException {
        try {
            this.triggerCollection.insertOne((Object)trigger);
        }
        catch (MongoWriteException key) {
            throw new ObjectAlreadyExistsException(offendingTrigger);
        }
    }

    public void remove(Bson filter) {
        this.triggerCollection.deleteMany(filter);
    }

    public void remove(TriggerKey triggerKey) {
        this.remove(Keys.toFilter(triggerKey));
    }

    public void removeByJobId(Object id) {
        this.triggerCollection.deleteMany(Filters.eq((String)"jobId", (Object)id));
    }

    public void replace(TriggerKey triggerKey, Document trigger) {
        this.triggerCollection.replaceOne(Keys.toFilter(triggerKey), (Object)trigger);
    }

    public void setState(TriggerKey triggerKey, String state) {
        this.triggerCollection.updateOne(Keys.toFilter(triggerKey), this.createTriggerStateUpdateDocument(state));
    }

    public void setStateInAll(String state) {
        this.setStates((Bson)new Document(), state);
    }

    public void setStateByJobId(ObjectId jobId, String state) {
        this.setStates((Bson)new Document("jobId", (Object)jobId), state);
    }

    public void setStateInGroups(List<String> groups, String state) {
        this.setStates(this.queryHelper.inGroups(groups), state);
    }

    public void setStateInMatching(GroupMatcher<TriggerKey> matcher, String state) {
        this.setStates(matcher, state);
    }

    private Bson createNextTriggerQuery(Date noLaterThanDate) {
        return Filters.and((Bson[])new Bson[]{Filters.or((Bson[])new Bson[]{Filters.eq((String)"nextFireTime", null), Filters.lte((String)"nextFireTime", (Object)noLaterThanDate)}), Filters.eq((String)"state", (Object)"waiting")});
    }

    private Bson createTriggerStateUpdateDocument(String state) {
        return new Document("$set", (Object)new Document("state", (Object)state));
    }

    private FindIterable<Document> findByJobId(Object jobId) {
        return this.triggerCollection.find(Filters.eq((String)"jobId", (Object)jobId));
    }

    private Document findTrigger(TriggerKey key) {
        return this.findTrigger(Keys.toFilter(key));
    }

    private long getCount(Bson query) {
        return this.triggerCollection.count(query);
    }

    private void setStates(Bson filter, String state) {
        this.triggerCollection.updateMany(filter, this.createTriggerStateUpdateDocument(state));
    }

    private void setStates(GroupMatcher<TriggerKey> matcher, String state) {
        this.triggerCollection.updateMany(this.queryHelper.matchingKeysConditionFor(matcher), this.createTriggerStateUpdateDocument(state), new UpdateOptions().upsert(false));
    }
}

