/*
 * Decompiled with CFR 0.152.
 */
package com.novemberain.quartz.mongodb.trigger;

import com.novemberain.quartz.mongodb.JobDataConverter;
import com.novemberain.quartz.mongodb.dao.JobDao;
import com.novemberain.quartz.mongodb.trigger.TriggerPropertiesConverter;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.quartz.Job;
import org.quartz.JobKey;
import org.quartz.JobPersistenceException;
import org.quartz.TriggerKey;
import org.quartz.spi.OperableTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerConverter {
    private static final String TRIGGER_CALENDAR_NAME = "calendarName";
    private static final String TRIGGER_CLASS = "class";
    private static final String TRIGGER_DESCRIPTION = "description";
    private static final String TRIGGER_END_TIME = "endTime";
    private static final String TRIGGER_FINAL_FIRE_TIME = "finalFireTime";
    private static final String TRIGGER_FIRE_INSTANCE_ID = "fireInstanceId";
    private static final String TRIGGER_MISFIRE_INSTRUCTION = "misfireInstruction";
    private static final String TRIGGER_PREVIOUS_FIRE_TIME = "previousFireTime";
    private static final String TRIGGER_PRIORITY = "priority";
    private static final String TRIGGER_START_TIME = "startTime";
    private static final Logger log = LoggerFactory.getLogger(TriggerConverter.class);
    private JobDao jobDao;
    private final JobDataConverter jobDataConverter;

    public TriggerConverter(JobDao jobDao, JobDataConverter jobDataConverter) {
        this.jobDao = jobDao;
        this.jobDataConverter = jobDataConverter;
    }

    public Document toDocument(OperableTrigger newTrigger, ObjectId jobId) throws JobPersistenceException {
        Document trigger = this.convertToBson(newTrigger, jobId);
        this.jobDataConverter.toDocument(newTrigger.getJobDataMap(), trigger);
        TriggerPropertiesConverter tpd = TriggerPropertiesConverter.getConverterFor(newTrigger);
        trigger = tpd.injectExtraPropertiesForInsert(newTrigger, trigger);
        return trigger;
    }

    public OperableTrigger toTrigger(TriggerKey triggerKey, Document triggerDoc) throws JobPersistenceException {
        OperableTrigger trigger = this.createNewInstance(triggerDoc);
        TriggerPropertiesConverter tpd = TriggerPropertiesConverter.getConverterFor(trigger);
        this.loadCommonProperties(triggerKey, triggerDoc, trigger);
        this.jobDataConverter.toJobData(triggerDoc, trigger.getJobDataMap());
        this.loadStartAndEndTimes(triggerDoc, trigger);
        tpd.setExtraPropertiesAfterInstantiation(trigger, triggerDoc);
        Document job = this.jobDao.getById(triggerDoc.get((Object)"jobId"));
        if (job != null) {
            trigger.setJobKey(new JobKey(job.getString((Object)"keyName"), job.getString((Object)"keyGroup")));
            return trigger;
        }
        return null;
    }

    public OperableTrigger toTrigger(Document doc) throws JobPersistenceException {
        TriggerKey key = new TriggerKey(doc.getString((Object)"keyName"), doc.getString((Object)"keyGroup"));
        return this.toTrigger(key, doc);
    }

    private Document convertToBson(OperableTrigger newTrigger, ObjectId jobId) {
        Document trigger = new Document();
        trigger.put("state", (Object)"waiting");
        trigger.put(TRIGGER_CALENDAR_NAME, (Object)newTrigger.getCalendarName());
        trigger.put(TRIGGER_CLASS, (Object)newTrigger.getClass().getName());
        trigger.put(TRIGGER_DESCRIPTION, (Object)newTrigger.getDescription());
        trigger.put(TRIGGER_END_TIME, (Object)newTrigger.getEndTime());
        trigger.put(TRIGGER_FINAL_FIRE_TIME, (Object)newTrigger.getFinalFireTime());
        trigger.put(TRIGGER_FIRE_INSTANCE_ID, (Object)newTrigger.getFireInstanceId());
        trigger.put("jobId", (Object)jobId);
        trigger.put("keyName", (Object)newTrigger.getKey().getName());
        trigger.put("keyGroup", (Object)newTrigger.getKey().getGroup());
        trigger.put(TRIGGER_MISFIRE_INSTRUCTION, (Object)newTrigger.getMisfireInstruction());
        trigger.put("nextFireTime", (Object)newTrigger.getNextFireTime());
        trigger.put(TRIGGER_PREVIOUS_FIRE_TIME, (Object)newTrigger.getPreviousFireTime());
        trigger.put(TRIGGER_PRIORITY, (Object)newTrigger.getPriority());
        trigger.put(TRIGGER_START_TIME, (Object)newTrigger.getStartTime());
        return trigger;
    }

    private OperableTrigger createNewInstance(Document triggerDoc) throws JobPersistenceException {
        String triggerClassName = triggerDoc.getString((Object)TRIGGER_CLASS);
        try {
            Class<?> triggerClass = this.getTriggerClassLoader().loadClass(triggerClassName);
            return (OperableTrigger)triggerClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new JobPersistenceException("Could not find trigger class " + triggerClassName);
        }
        catch (Exception e) {
            throw new JobPersistenceException("Could not instantiate trigger class " + triggerClassName);
        }
    }

    private ClassLoader getTriggerClassLoader() {
        return Job.class.getClassLoader();
    }

    private void loadCommonProperties(TriggerKey triggerKey, Document triggerDoc, OperableTrigger trigger) {
        trigger.setKey(triggerKey);
        trigger.setCalendarName(triggerDoc.getString((Object)TRIGGER_CALENDAR_NAME));
        trigger.setDescription(triggerDoc.getString((Object)TRIGGER_DESCRIPTION));
        trigger.setFireInstanceId(triggerDoc.getString((Object)TRIGGER_FIRE_INSTANCE_ID));
        trigger.setMisfireInstruction(triggerDoc.getInteger((Object)TRIGGER_MISFIRE_INSTRUCTION).intValue());
        trigger.setNextFireTime(triggerDoc.getDate((Object)"nextFireTime"));
        trigger.setPreviousFireTime(triggerDoc.getDate((Object)TRIGGER_PREVIOUS_FIRE_TIME));
        trigger.setPriority(triggerDoc.getInteger((Object)TRIGGER_PRIORITY).intValue());
    }

    private void loadStartAndEndTimes(Document triggerDoc, OperableTrigger trigger) {
        this.loadStartAndEndTime(triggerDoc, trigger);
        this.loadStartAndEndTime(triggerDoc, trigger);
    }

    private void loadStartAndEndTime(Document triggerDoc, OperableTrigger trigger) {
        try {
            trigger.setStartTime(triggerDoc.getDate((Object)TRIGGER_START_TIME));
            trigger.setEndTime(triggerDoc.getDate((Object)TRIGGER_END_TIME));
        }
        catch (IllegalArgumentException e) {
            log.warn("Trigger had illegal start / end time combination: {}", (Object)trigger.getKey(), (Object)e);
        }
    }
}

