/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.auth.token;

import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPlugin;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPluginLogoutExtension;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.platform.web.common.CookieHelper;
import org.nuxeo.ecm.tokenauth.service.TokenAuthenticationService;
import org.nuxeo.runtime.api.Framework;

public class TokenAuthenticator
implements NuxeoAuthenticationPlugin,
NuxeoAuthenticationPluginLogoutExtension {
    public static final String ALLOW_ANONYMOUS_KEY = "allowAnonymous";
    private static final Log log = LogFactory.getLog(TokenAuthenticator.class);
    protected static final String TOKEN_HEADER = "X-Authentication-Token";
    protected static final String TOKEN_PARAM = "token";
    protected boolean allowAnonymous = false;

    public Boolean handleLoginPrompt(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String baseURL) {
        return false;
    }

    public UserIdentificationInfo handleRetrieveIdentity(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        String token = this.getTokenFromRequest(httpRequest);
        if (token == null) {
            log.debug((Object)String.format("Found no '%s' header in the request.", TOKEN_HEADER));
            return null;
        }
        String userName = this.getUserByToken(token);
        if (userName == null) {
            log.debug((Object)String.format("No user bound to the token '%s' (maybe it has been revoked), returning null.", token));
            return null;
        }
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        if (userManager != null && userName.equals(userManager.getAnonymousUserId()) && !this.allowAnonymous) {
            log.debug((Object)"Anonymous user is not allowed to get authenticated by token, returning null.");
            return null;
        }
        Cookie cookie = CookieHelper.createCookie((HttpServletRequest)httpRequest, (String)TOKEN_HEADER, (String)token);
        httpResponse.addCookie(cookie);
        return new UserIdentificationInfo(userName, userName);
    }

    private String getTokenFromRequest(HttpServletRequest httpRequest) {
        Cookie cookie;
        String token = httpRequest.getHeader(TOKEN_HEADER);
        if (token == null) {
            token = httpRequest.getParameter(TOKEN_PARAM);
        }
        if (token == null && httpRequest.getCookies() != null && (cookie = this.getTokenCookie(httpRequest)) != null) {
            return cookie.getValue();
        }
        return token;
    }

    private Cookie getTokenCookie(HttpServletRequest httpRequest) {
        Cookie[] cookies = httpRequest.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(TOKEN_HEADER)) continue;
                return cookie;
            }
        }
        return null;
    }

    public Boolean needLoginPrompt(HttpServletRequest httpRequest) {
        return false;
    }

    public void initPlugin(Map<String, String> parameters) {
        if (parameters.containsKey(ALLOW_ANONYMOUS_KEY)) {
            this.allowAnonymous = Boolean.valueOf(parameters.get(ALLOW_ANONYMOUS_KEY));
        }
    }

    public List<String> getUnAuthenticatedURLPrefix() {
        return null;
    }

    protected String getUserByToken(String token) {
        TokenAuthenticationService tokenAuthService = (TokenAuthenticationService)Framework.getService(TokenAuthenticationService.class);
        return tokenAuthService.getUserName(token);
    }

    public Boolean handleLogout(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        Cookie cookie = this.getTokenCookie(httpRequest);
        if (cookie != null) {
            cookie.setValue("");
            httpResponse.addCookie(cookie);
        }
        return false;
    }
}

