/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.preview.io;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.AbstractJsonEnricher;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.platform.preview.helper.PreviewHelper;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class PreviewJsonEnricher
extends AbstractJsonEnricher<DocumentModel> {
    public static final String NAME = "preview";
    private static final String PREVIEW_URL_LABEL = "url";

    public PreviewJsonEnricher() {
        super(NAME);
    }

    public void write(JsonGenerator jg, DocumentModel document) throws IOException {
        String relativeUrl = PreviewHelper.getPreviewURL(document);
        jg.writeFieldName(NAME);
        jg.writeStartObject();
        if (relativeUrl != null && !relativeUrl.isEmpty()) {
            String url = this.ctx.getBaseUrl() + PreviewHelper.getPreviewURL(document);
            jg.writeStringField(PREVIEW_URL_LABEL, url);
        } else {
            jg.writeNullField(PREVIEW_URL_LABEL);
        }
        jg.writeEndObject();
    }
}

