/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common;

import java.io.File;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Environment {
    private static Log logger = LogFactory.getLog(Environment.class);
    public static final String JBOSS_HOST = "JBoss";
    public static final String NXSERVER_HOST = "NXServer";
    public static final String TOMCAT_HOST = "Tomcat";
    public static final String NUXEO_HOME_DIR = "nuxeo.home.dir";
    public static final String NUXEO_HOME = "nuxeo.home";
    public static final String NUXEO_RUNTIME_HOME = "nuxeo.runtime.home";
    public static final String NUXEO_DATA_DIR = "nuxeo.data.dir";
    public static final String DEFAULT_DATA_DIR = "data";
    public static final String NUXEO_LOG_DIR = "nuxeo.log.dir";
    public static final String DEFAULT_LOG_DIR = "log";
    public static final String NUXEO_PID_DIR = "nuxeo.pid.dir";
    public static final String NUXEO_TMP_DIR = "nuxeo.tmp.dir";
    public static final String DEFAULT_TMP_DIR = "tmp";
    public static final String NUXEO_CONFIG_DIR = "nuxeo.config.dir";
    public static final String DEFAULT_CONFIG_DIR = "config";
    public static final String NUXEO_WEB_DIR = "nuxeo.web.dir";
    public static final String DEFAULT_WEB_DIR = "web";
    public static final String NUXEO_MP_DIR = "nuxeo.mp.dir";
    public static final String DEFAULT_MP_DIR = "packages";
    public static final String NUXEO_CONTEXT_PATH = "org.nuxeo.ecm.contextPath";
    public static final String BUNDLES_DIR = "nuxeo.osgi.app.bundles";
    public static final String BUNDLES = "nuxeo.osgi.bundles";
    private static volatile Environment DEFAULT;
    protected final File home;
    protected File data;
    protected File log;
    protected File config;
    protected File web;
    protected File temp;
    protected final Properties properties;
    protected String[] args;
    protected boolean isAppServer;
    protected String hostAppName;
    protected String hostAppVersion;
    protected Iterable<URL> configProvider;
    private File serverHome = null;
    private File runtimeHome = null;
    public static final String SERVER_STATUS_KEY = "server.status.key";
    public static final String DISTRIBUTION_NAME = "org.nuxeo.distribution.name";
    public static final String DISTRIBUTION_VERSION = "org.nuxeo.distribution.version";
    public static final String DISTRIBUTION_SERVER = "org.nuxeo.distribution.server";
    public static final String DISTRIBUTION_DATE = "org.nuxeo.distribution.date";
    public static final String DISTRIBUTION_PACKAGE = "org.nuxeo.distribution.package";
    public static final String PRODUCT_NAME = "org.nuxeo.ecm.product.name";
    public static final String PRODUCT_VERSION = "org.nuxeo.ecm.product.version";
    public static final String NUXEO_HTTP_PROXY_HOST = "nuxeo.http.proxy.host";
    public static final String NUXEO_HTTP_PROXY_PORT = "nuxeo.http.proxy.port";
    public static final String NUXEO_HTTP_PROXY_LOGIN = "nuxeo.http.proxy.login";
    public static final String NUXEO_HTTP_PROXY_PASSWORD = "nuxeo.http.proxy.password";
    public static final String CRYPT_ALGO = "server.crypt.algorithm";
    public static final String CRYPT_KEY = "server.crypt.secretkey";
    public static final String CRYPT_KEYALIAS = "server.crypt.keyalias";
    public static final String CRYPT_KEYSTORE_PATH = "server.crypt.keystore.path";
    public static final String CRYPT_KEYSTORE_PASS = "server.crypt.keystore.pass";
    public static final String JAVA_DEFAULT_KEYSTORE = "javax.net.ssl.keyStore";
    public static final String JAVA_DEFAULT_KEYSTORE_PASS = "javax.net.ssl.keyStorePassword";

    public Environment(File home) {
        this(home, null);
    }

    public Environment(File home, Properties properties) {
        this.home = home.getAbsoluteFile();
        this.properties = new Properties();
        if (properties != null) {
            this.loadProperties(properties);
        }
    }

    public static synchronized void setDefault(Environment env) {
        DEFAULT = env;
    }

    public static Environment getDefault() {
        if (DEFAULT == null) {
            Environment.tryInitEnvironment();
        }
        return DEFAULT;
    }

    private static synchronized void tryInitEnvironment() {
        File home;
        String homeDir = System.getProperty(NUXEO_HOME);
        if (homeDir != null && (home = new File(homeDir)).isDirectory()) {
            DEFAULT = new Environment(home);
            DEFAULT.init();
        }
    }

    public File getHome() {
        return this.home;
    }

    public boolean isApplicationServer() {
        return this.isAppServer;
    }

    public void setIsApplicationServer(boolean isAppServer) {
        this.isAppServer = isAppServer;
    }

    public String getHostApplicationName() {
        return this.hostAppName;
    }

    public String getHostApplicationVersion() {
        return this.hostAppVersion;
    }

    public void setHostApplicationName(String name) {
        this.hostAppName = name;
    }

    public void setHostApplicationVersion(String version) {
        this.hostAppVersion = version;
    }

    public File getTemp() {
        if (this.temp == null) {
            this.setTemp(this.properties.getProperty(NUXEO_TMP_DIR, DEFAULT_TMP_DIR));
        }
        return this.temp;
    }

    public void setTemp(String temp) {
        this.setTemp(this.getServerHome().toPath().resolve(temp).toFile());
    }

    public void setTemp(File temp) {
        this.temp = temp.getAbsoluteFile();
        this.setProperty(NUXEO_TMP_DIR, temp.getAbsolutePath());
        temp.mkdirs();
    }

    public File getConfig() {
        if (this.config == null) {
            this.setConfig(this.properties.getProperty(NUXEO_CONFIG_DIR, DEFAULT_CONFIG_DIR));
        }
        return this.config;
    }

    public void setConfig(String config) {
        File configFile = this.getRuntimeHome().toPath().resolve(config).toFile();
        this.setConfig(configFile);
    }

    public void setConfig(File config) {
        this.config = config.getAbsoluteFile();
        this.setProperty(NUXEO_CONFIG_DIR, config.getAbsolutePath());
        config.mkdirs();
    }

    public File getLog() {
        if (this.log == null) {
            this.setLog(this.properties.getProperty(NUXEO_LOG_DIR, DEFAULT_LOG_DIR));
        }
        return this.log;
    }

    public void setLog(String log) {
        this.setLog(this.getServerHome().toPath().resolve(log).toFile());
    }

    public void setLog(File log) {
        this.log = log.getAbsoluteFile();
        this.setProperty(NUXEO_LOG_DIR, log.getAbsolutePath());
        log.mkdirs();
    }

    public File getData() {
        if (this.data == null) {
            this.setData(this.properties.getProperty(NUXEO_DATA_DIR, DEFAULT_DATA_DIR));
        }
        return this.data;
    }

    public void setData(String data) {
        this.setData(this.getRuntimeHome().toPath().resolve(data).toFile());
    }

    public void setData(File data) {
        this.data = data.getAbsoluteFile();
        this.setProperty(NUXEO_DATA_DIR, data.getAbsolutePath());
        data.mkdirs();
    }

    public File getWeb() {
        if (this.web == null) {
            this.setWeb(this.properties.getProperty(NUXEO_WEB_DIR, DEFAULT_WEB_DIR));
        }
        return this.web;
    }

    public void setWeb(String web) {
        this.setWeb(this.getRuntimeHome().toPath().resolve(web).toFile());
    }

    public void setWeb(File web) {
        this.web = web;
        this.setProperty(NUXEO_WEB_DIR, web.getAbsolutePath());
    }

    public File getRuntimeHome() {
        this.initRuntimeHome();
        return this.runtimeHome;
    }

    public void setRuntimeHome(File runtimeHome) {
        this.runtimeHome = runtimeHome.getAbsoluteFile();
        this.setProperty(NUXEO_RUNTIME_HOME, runtimeHome.getAbsolutePath());
    }

    public String[] getCommandLineArguments() {
        return this.args;
    }

    public void setCommandLineArguments(String[] args) {
        this.args = args;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        String val = this.properties.getProperty(key);
        return val == null ? defaultValue : val;
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void loadProperties(Properties props) {
        this.properties.putAll((Map<?, ?>)props);
    }

    public boolean isJBoss() {
        return JBOSS_HOST.equals(this.hostAppName);
    }

    public boolean isJetty() {
        return NXSERVER_HOST.equals(this.hostAppName);
    }

    public boolean isTomcat() {
        return TOMCAT_HOST.equals(this.hostAppName);
    }

    public void init() {
        String mpDir;
        String tmpDir;
        String logDir;
        String configDir;
        this.initServerHome();
        this.initRuntimeHome();
        String dataDir = System.getProperty(NUXEO_DATA_DIR);
        if (StringUtils.isNotEmpty((CharSequence)dataDir)) {
            this.setData(new File(dataDir));
        }
        if (StringUtils.isNotEmpty((CharSequence)(configDir = System.getProperty(NUXEO_CONFIG_DIR)))) {
            this.setConfig(new File(configDir));
        }
        if (StringUtils.isNotEmpty((CharSequence)(logDir = System.getProperty(NUXEO_LOG_DIR)))) {
            this.setLog(new File(logDir));
        }
        if (StringUtils.isNotEmpty((CharSequence)(tmpDir = System.getProperty(NUXEO_TMP_DIR)))) {
            this.setTemp(new File(tmpDir));
        }
        this.setPath(NUXEO_MP_DIR, StringUtils.isNotEmpty((CharSequence)(mpDir = System.getProperty(NUXEO_MP_DIR))) ? mpDir : DEFAULT_MP_DIR, this.getServerHome());
    }

    private void initRuntimeHome() {
        if (this.runtimeHome != null) {
            return;
        }
        String runtimeDir = System.getProperty(NUXEO_RUNTIME_HOME);
        if (runtimeDir != null && !runtimeDir.isEmpty()) {
            this.setRuntimeHome(new File(runtimeDir));
        } else {
            this.setRuntimeHome(this.home);
        }
    }

    public File getServerHome() {
        this.initServerHome();
        return this.serverHome;
    }

    public void setServerHome(File serverHome) {
        this.serverHome = serverHome.getAbsoluteFile();
        this.setProperty(NUXEO_HOME_DIR, serverHome.getAbsolutePath());
    }

    private void initServerHome() {
        if (this.serverHome != null) {
            return;
        }
        String homeDir = System.getProperty(NUXEO_HOME, System.getProperty(NUXEO_HOME_DIR));
        if (homeDir != null && !homeDir.isEmpty()) {
            this.setServerHome(new File(homeDir));
        } else {
            logger.warn((Object)String.format("Could not set the server home from %s or %s system properties, will use %s", NUXEO_HOME, NUXEO_HOME_DIR, this.home));
            this.setServerHome(this.home);
        }
        logger.debug((Object)this);
    }

    public void setConfigurationProvider(Iterable<URL> configProvider) {
        this.configProvider = configProvider;
    }

    public Iterable<URL> getConfigurationProvider() {
        return this.configProvider;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public void setPath(String key, File value, File baseDir) {
        this.setProperty(key, baseDir.toPath().resolve(value.toPath()).toFile().getAbsolutePath());
    }

    public void setPath(String key, String value, File baseDir) {
        this.setProperty(key, baseDir.toPath().resolve(value).toFile().getAbsolutePath());
    }

    public void setPath(String key, File value) {
        this.setPath(key, value, this.home);
    }

    public void setPath(String key, String value) {
        this.setPath(key, value, this.home);
    }

    public File getPath(String key) {
        return this.getPath(key, null);
    }

    public File getPath(String key, String defaultValue) {
        String path = this.properties.getProperty(key);
        if (path != null) {
            return new File(path);
        }
        if (defaultValue != null) {
            return this.getServerHome().toPath().resolve(defaultValue).toFile();
        }
        return null;
    }
}

