/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.function;

import org.nuxeo.common.function.FunctionUtils;
import org.nuxeo.common.function.ThrowableSupplier;

@FunctionalInterface
public interface ThrowableRunnable<E extends Throwable> {
    public void run() throws E;

    default public Runnable toRunnable() {
        return ThrowableRunnable.asRunnable(this);
    }

    default public ThrowableSupplier<Void, E> toThrowableSupplier() {
        return ThrowableRunnable.asThrowableSupplier(this);
    }

    public static <E extends Throwable> Runnable asRunnable(ThrowableRunnable<E> throwableRunnable) {
        return () -> {
            try {
                throwableRunnable.run();
            }
            catch (Throwable t) {
                FunctionUtils.sneakyThrow(t);
            }
        };
    }

    public static <E extends Throwable> ThrowableSupplier<Void, E> asThrowableSupplier(ThrowableRunnable<E> throwableRunnable) {
        return () -> {
            throwableRunnable.run();
            return null;
        };
    }
}

