/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.query.core;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderClassReplacerDefinition;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class PageProviderClassReplacerRegistry
extends ContributionFragmentRegistry<PageProviderClassReplacerDefinition> {
    private static final Log log = LogFactory.getLog(PageProviderClassReplacerRegistry.class);
    protected Map<String, Class<? extends PageProvider<?>>> replacerMap = new HashMap();

    public String getContributionId(PageProviderClassReplacerDefinition contrib) {
        return contrib.getPageProviderClassName();
    }

    public void contributionUpdated(String id, PageProviderClassReplacerDefinition desc, PageProviderClassReplacerDefinition newOrigContrib) {
        String name = desc.getPageProviderClassName();
        if (name == null) {
            log.error((Object)"Cannot register page provider class replacer without class name");
            return;
        }
        if (!desc.isEnabled()) {
            return;
        }
        log.debug((Object)("Registering page provider class replacer using " + name));
        Class<? extends PageProvider<?>> klass = this.getPageProviderClass(desc.getPageProviderClassName());
        for (String providerName : desc.getPageProviderNames()) {
            this.replacerMap.put(providerName, klass);
        }
    }

    public void contributionRemoved(String id, PageProviderClassReplacerDefinition origContrib) {
        log.debug((Object)("Unregistering page provider replacer for class " + id));
        for (String providerName : origContrib.getPageProviderNames()) {
            this.replacerMap.remove(providerName);
        }
    }

    public boolean isSupportingMerge() {
        return false;
    }

    public PageProviderClassReplacerDefinition clone(PageProviderClassReplacerDefinition orig) {
        throw new UnsupportedOperationException();
    }

    public void merge(PageProviderClassReplacerDefinition src, PageProviderClassReplacerDefinition dst) {
        throw new UnsupportedOperationException();
    }

    protected Class<? extends PageProvider<?>> getPageProviderClass(String className) {
        Class<?> ret;
        try {
            ret = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(String.format("Class %s not found", className));
        }
        if (!PageProvider.class.isAssignableFrom(ret)) {
            throw new IllegalStateException(String.format("Class %s does not implement PageProvider interface", className));
        }
        return ret;
    }

    public Class<? extends PageProvider<?>> getClassForPageProvider(String name) {
        return this.replacerMap.get(name);
    }

    public void dumpReplacerMap() {
        if (this.replacerMap.isEmpty()) {
            log.info((Object)"No page provider has been superseded");
            return;
        }
        StringBuilder out = new StringBuilder();
        out.append("List of page provider names that are superseded: \n");
        for (String name : this.replacerMap.keySet()) {
            out.append(String.format("  - %s: %s\n", name, this.replacerMap.get(name).getName()));
        }
        log.info((Object)out.toString());
    }
}

