/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.CharSequenceComparator;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.wire.FieldNumberParselet;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireParselet;
import net.openhft.chronicle.wire.WireParser;
import org.jetbrains.annotations.NotNull;

public class VanillaWireParser
implements WireParser {
    private final Map<CharSequence, WireParselet> namedConsumer = new TreeMap<CharSequence, WireParselet>((Comparator<CharSequence>)CharSequenceComparator.INSTANCE);
    private final WireParselet defaultConsumer;
    private final StringBuilder sb = new StringBuilder(128);
    private final StringBuilder lastEventName = new StringBuilder(128);
    private FieldNumberParselet fieldNumberParselet;
    private WireParselet lastParslet = null;
    private long lastStart = 0L;

    public VanillaWireParser(@NotNull WireParselet defaultConsumer, @NotNull FieldNumberParselet fieldNumberParselet) {
        this.defaultConsumer = defaultConsumer;
        this.lastEventName.appendCodePoint(65535);
        this.fieldNumberParselet = fieldNumberParselet;
    }

    private int peekCode(@NotNull WireIn wireIn) {
        return wireIn.bytes().peekUnsignedByte();
    }

    @Override
    public WireParselet getDefaultConsumer() {
        return this.defaultConsumer;
    }

    @Override
    public void parseOne(@NotNull WireIn wireIn) {
        WireParselet parslet;
        if (this.peekCode(wireIn) == 186) {
            this.fieldNumberParselet.readOne(wireIn.readEventNumber(), wireIn);
            return;
        }
        long start = wireIn.bytes().readPosition();
        ValueIn valueIn = wireIn.readEventName(this.sb);
        if (StringUtils.isEqual((StringBuilder)this.sb, (CharSequence)this.lastEventName)) {
            parslet = this.lastParslet;
        } else {
            parslet = this.lookup(this.sb);
            if (parslet == null) {
                if (this.sb.length() == 0) {
                    Jvm.warn().on(this.getClass(), "Attempt to read method name/id but not at the start of a method, the previous method name was " + this.lastEventName + "\n" + wireIn.bytes().toHexString(start, 1024L));
                    if (this.lastStart < start && this.lastStart + 1024L >= start) {
                        Jvm.warn().on(this.getClass(), "The previous message was\n" + wireIn.bytes().toHexString(this.lastStart, start - this.lastStart));
                    }
                }
                parslet = this.getDefaultConsumer();
            }
        }
        parslet.accept(this.sb, valueIn);
        this.lastEventName.setLength(0);
        this.lastEventName.append((CharSequence)this.sb);
        this.lastParslet = parslet;
        this.lastStart = start;
    }

    @Override
    @NotNull
    public VanillaWireParser register(@NotNull WireKey key, WireParselet valueInConsumer) {
        this.namedConsumer.put(key.name(), valueInConsumer);
        return this;
    }

    @Override
    public WireParselet lookup(CharSequence name) {
        return this.namedConsumer.get(name);
    }
}

