/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.EOFException;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.MethodWireKey;
import net.openhft.chronicle.wire.Sequence;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.WireCommon;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface WireOut
extends WireCommon,
MarshallableOut {
    public static final long TRY_WRITE_HEADER_FAILED = -1L;
    public static final int DEFAULT_SAFE_LENGTH = 0x40000000;

    @NotNull
    public ValueOut write();

    @NotNull
    default public ValueOut writeEventName(WireKey key) {
        return this.write(key);
    }

    default public ValueOut writeEventName(CharSequence key) {
        return this.write(key);
    }

    default public ValueOut writeEvent(Class expectedType, Object eventKey) {
        if (eventKey instanceof WireKey) {
            return this.writeEventName((WireKey)eventKey);
        }
        if (eventKey instanceof CharSequence) {
            return this.writeEventName((CharSequence)eventKey);
        }
        this.startEvent();
        this.getValueOut().object(expectedType, eventKey);
        this.endEvent();
        return this.getValueOut();
    }

    default public ValueOut writeEventId(int methodId) {
        return this.write(new MethodWireKey(null, methodId));
    }

    @NotNull
    public ValueOut write(WireKey var1);

    public ValueOut write(CharSequence var1);

    @NotNull
    public ValueOut getValueOut();

    public ObjectOutput objectOutput();

    @NotNull
    public WireOut writeComment(CharSequence var1);

    @NotNull
    public WireOut addPadding(int var1);

    @NotNull
    default public WireOut padToCacheAlign() {
        Bytes<?> bytes = this.bytes();
        try {
            int mod;
            long offset = bytes.writePosition();
            if (bytes.start() != 0L) {
                offset = bytes.addressForRead(offset);
            }
            if ((mod = (int)(offset & 0x3FL)) > 60) {
                this.addPadding(64 - mod);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return this;
    }

    @NotNull
    default public WireOut writeAlignTo(int alignment, int plus) {
        if (!1.$assertionsDisabled && Integer.bitCount(alignment) != 1) {
            throw new AssertionError();
        }
        long mod = this.bytes().writePosition() + (long)plus & (long)(alignment - 1);
        if (mod != 0L) {
            this.addPadding((int)((long)alignment - mod));
        }
        return this;
    }

    @Override
    public void clear();

    default public void writeDocument(boolean metaData, @NotNull WriteMarshallable writer) {
        WireInternal.writeData(this, metaData, false, writer);
    }

    @Override
    public DocumentContext writingDocument(boolean var1);

    @Override
    @NotNull
    default public DocumentContext writingDocument() {
        return this.writingDocument(false);
    }

    @Deprecated
    default public void writeNotCompleteDocument(boolean metaData, @NotNull WriteMarshallable writer) {
        WireInternal.writeData(this, metaData, true, writer);
    }

    default public long writeHeader(long timeout, TimeUnit timeUnit, @Nullable LongValue lastPosition, Sequence sequence) throws TimeoutException, EOFException {
        return this.writeHeaderOfUnknownLength(timeout, timeUnit, lastPosition, sequence);
    }

    default public void updateHeader(long position, boolean metaData) throws StreamCorruptedException {
        this.updateHeader(position, metaData, Wires.addMaskedTidToHeader(Integer.MIN_VALUE));
    }

    public void updateHeader(long var1, boolean var3, int var4) throws StreamCorruptedException;

    public long writeHeaderOfUnknownLength(int var1, long var2, TimeUnit var4, @Nullable LongValue var5, Sequence var6) throws TimeoutException, EOFException;

    default public long writeHeaderOfUnknownLength(long timeout, TimeUnit timeUnit, @Nullable LongValue lastPosition, Sequence sequence) throws TimeoutException, EOFException {
        return this.writeHeaderOfUnknownLength(0x40000000, timeout, timeUnit, lastPosition, sequence);
    }

    public long enterHeader(int var1);

    public boolean writeFirstHeader();

    public void updateFirstHeader();

    public void writeEndOfWire(long var1, TimeUnit var3, long var4);

    public void startEvent();

    public void endEvent();

    default public <K, V> void writeAllAsMap(Class<K> kClass, Class<V> vClass, @NotNull Map<K, V> map) {
        map.forEach((k, v) -> this.writeEvent(kClass, k).object(vClass, v));
    }

    @NotNull
    default public WireOut dropDefault(boolean dropDefault) {
        return this;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

