/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.AuthInfo;
import com.sun.jdmk.comm.ClientHandler;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.CommunicatorServer;
import com.sun.jdmk.comm.GenericHttpSocket;
import com.sun.jdmk.comm.HttpBody;
import com.sun.jdmk.comm.HttpRequest;
import com.sun.jdmk.comm.HttpResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Date;
import javax.management.MBeanServer;
import javax.management.ObjectName;

abstract class GenericHttpClientHandler
extends ClientHandler {
    private static final AuthInfo nullAuthInfo = new AuthInfo(){

        @Override
        public void setLogin(String login) {
            throw new IllegalArgumentException("unsupported operation");
        }

        @Override
        public void setPassword(String password) {
            throw new IllegalArgumentException("unsupported operation");
        }
    };
    private GenericHttpSocket sockClient = null;
    private static final String InterruptSysCallMsg = "Interrupted system call";

    public GenericHttpClientHandler(CommunicatorServer server, int id, GenericHttpSocket s, MBeanServer mbs, ObjectName name) {
        super(server, id, mbs, name);
        this.sockClient = s;
        this.thread.start();
    }

    protected abstract AuthInfo authenticateRequest(HttpRequest var1) throws IOException;

    protected abstract HttpResponse processPostRequest(HttpRequest var1) throws IOException;

    /*
     * Exception decompiling
     */
    @Override
    public void doRun() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected HttpResponse processRequest(HttpRequest request) throws IOException {
        if (this.logger.finerOn()) {
            this.logger.finer("processRequest", "Process the HTTP request");
        }
        HttpResponse response = null;
        AuthInfo authInfo = this.authenticateRequest(request);
        if (authInfo == null) {
            response = this.makeErrorResponse(401, "Unauthorized");
        } else if (request.method == 2) {
            response = this.processPostRequest(request);
        } else {
            if (this.logger.finestOn()) {
                this.logger.finest("processRequest", "Bad request: Request method not supported");
            }
            response = this.makeErrorResponse(400, "Bad Request");
        }
        return response;
    }

    protected HttpResponse makeOkResponse(byte[] data) {
        return this.makeResponse(200, "OK", data);
    }

    protected HttpResponse makeExceptionResponse(Exception exception) {
        ByteArrayOutputStream bOut = null;
        try {
            bOut = this.serialize("Exception", exception);
        }
        catch (IOException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("makeExceptionResponse", "Got IOException when serializing : " + e);
            }
            return this.makeErrorResponse(400, "Bad Request");
        }
        if (this.logger.finestOn()) {
            this.logger.finest("makeExceptionResponse", "Sending back Exception : " + exception);
        }
        return this.makeResponse(400, "Bad Request", bOut.toByteArray());
    }

    protected HttpResponse makeErrorResponse(int statusCode, String reasonPhrase) {
        return this.makeResponse(statusCode, reasonPhrase, null);
    }

    protected HttpResponse makeResponse(int statusCode, String reasonPhrase, byte[] contents) {
        HttpBody body = contents == null ? new HttpBody() : new HttpBody(contents);
        HttpResponse response = new HttpResponse(body);
        response.statusCode = statusCode;
        response.reasonPhrase = reasonPhrase;
        response.setHeader(1, "application/octet-stream");
        response.setHeader(2, new Date().toString());
        response.setHeader(4, this.getChallenge());
        return response;
    }

    protected AuthInfo makeNullAuthInfo() {
        return nullAuthInfo;
    }

    void closeClient() {
        if (this.logger.finerOn()) {
            this.logger.finer("closeClient", "Close client ...");
        }
        if (this.sockClient != null) {
            try {
                try {
                    this.sockClient.doDisconnect();
                }
                catch (IOException iOException) {
                    this.sockClient = null;
                }
                catch (CommunicationException communicationException) {
                    this.sockClient = null;
                }
            }
            finally {
                this.sockClient = null;
            }
        }
    }

    protected ByteArrayOutputStream serialize(String resultType, Object result) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ObjectOutputStream objOut = new ObjectOutputStream(bOut);
        objOut.writeObject(resultType);
        objOut.writeObject(result);
        return bOut;
    }

    protected abstract String getChallenge();
}

