/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.GenericHttpSocket;
import com.sun.jdmk.internal.ClassLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

class HttpsSocket
extends GenericHttpSocket {
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.comm.legacy.connector.https", "HttpsSocket");
    private int backlog = 10;
    private Socket sckAccept = null;
    private SSLSocket clientSocket = null;
    private InputStream inputStream = null;
    private OutputStream outputStream = null;
    private SSLServerSocket serverSocket = null;
    private SSLSocketFactory clientSocketFactory = null;
    private SSLServerSocketFactory serverSocketFactory = null;
    private boolean needClientAuth = true;

    public HttpsSocket() {
    }

    public HttpsSocket(int port) {
        this.port = port;
    }

    public HttpsSocket(int port, InetAddress bindAddr) {
        this.port = port;
        this.bindAddr = bindAddr;
    }

    public HttpsSocket(int port, InetAddress bindAddr, boolean needClientAuth) {
        this.port = port;
        this.bindAddr = bindAddr;
        this.needClientAuth = needClientAuth;
    }

    @Override
    public GenericHttpSocket createServerSocket(int port) {
        HttpsSocket newSocket = new HttpsSocket(port, null, this.needClientAuth);
        newSocket.setTimeout(this.getTimeout());
        return newSocket;
    }

    @Override
    public GenericHttpSocket createServerSocket(int port, InetAddress bindAddr) {
        HttpsSocket newSocket = new HttpsSocket(port, bindAddr, this.needClientAuth);
        newSocket.setTimeout(this.getTimeout());
        return newSocket;
    }

    @Override
    public GenericHttpSocket createClientSocket() {
        HttpsSocket newSocket = new HttpsSocket(0);
        newSocket.setTimeout(this.getTimeout());
        return newSocket;
    }

    @Override
    public String getProtocol() {
        return "https";
    }

    @Override
    public void doBind() throws IOException {
        String cipher_suite;
        int i;
        StringBuffer str_buffer;
        this.serverSocketFactory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
        this.serverSocket = this.bindAddr == null ? (SSLServerSocket)this.serverSocketFactory.createServerSocket(this.port, this.backlog) : (SSLServerSocket)this.serverSocketFactory.createServerSocket(this.port, this.backlog, this.bindAddr);
        this.serverSocket.setNeedClientAuth(this.needClientAuth);
        String[] supported_cs = this.serverSocket.getSupportedCipherSuites();
        if (logger.finerOn()) {
            logger.finer("doBind", "Supported Cipher Suites");
        }
        if (supported_cs != null) {
            str_buffer = new StringBuffer();
            i = 0;
            while (i < supported_cs.length) {
                str_buffer.append(supported_cs[i]);
                if (i + 1 < supported_cs.length) {
                    str_buffer.append(", ");
                }
                ++i;
            }
            if (logger.finerOn()) {
                logger.finer("doBind", "[" + str_buffer + "]");
            }
        } else if (logger.finerOn()) {
            logger.finer("doBind", "[]");
        }
        Vector<String> user_specified_cs_vector = new Vector<String>();
        i = 1;
        while ((cipher_suite = System.getProperty("jdmk.ssl.cipher.suite." + String.valueOf(i))) != null) {
            user_specified_cs_vector.addElement(cipher_suite);
            ++i;
        }
        if (logger.finerOn()) {
            logger.finer("doBind", "User Specified Cipher Suites");
            logger.finer("doBind", user_specified_cs_vector.toString());
        }
        Vector<String> supported_user_specified_cs_vector = new Vector<String>();
        if (user_specified_cs_vector != null && user_specified_cs_vector.size() > 0) {
            Enumeration e = user_specified_cs_vector.elements();
            block2: while (e.hasMoreElements()) {
                cipher_suite = (String)e.nextElement();
                if (supported_cs == null) continue;
                i = 0;
                while (i < supported_cs.length) {
                    if (supported_cs[i].equals(cipher_suite)) {
                        supported_user_specified_cs_vector.addElement(cipher_suite);
                        continue block2;
                    }
                    ++i;
                }
            }
        }
        if (logger.finerOn()) {
            logger.finer("doBind", "Supported User Specified Cipher Suites");
            logger.finer("doBind", supported_user_specified_cs_vector.toString());
        }
        if (supported_user_specified_cs_vector != null && supported_user_specified_cs_vector.size() > 0) {
            i = 0;
            String[] ecs = (String[])Array.newInstance(String.class, supported_user_specified_cs_vector.size());
            Enumeration e = supported_user_specified_cs_vector.elements();
            while (e.hasMoreElements()) {
                cipher_suite = (String)e.nextElement();
                Array.set(ecs, i, cipher_suite);
                ++i;
            }
            this.serverSocket.setEnabledCipherSuites(ecs);
        }
        String[] enabled_cs = this.serverSocket.getEnabledCipherSuites();
        if (logger.finerOn()) {
            logger.finer("doBind", "Enabled Cipher Suites");
        }
        if (enabled_cs != null) {
            str_buffer = new StringBuffer();
            i = 0;
            while (i < enabled_cs.length) {
                str_buffer.append(enabled_cs[i]);
                if (i + 1 < enabled_cs.length) {
                    str_buffer.append(", ");
                }
                ++i;
            }
            if (logger.finerOn()) {
                logger.finer("doBind", "[" + str_buffer + "]");
            }
        } else if (logger.finerOn()) {
            logger.finer("doBind", "[]");
        }
    }

    @Override
    public void doUnbind() throws IOException {
        this.serverSocket.close();
    }

    @Override
    public void doConnect(String serverName, int serverPort) throws UnknownHostException, IOException, CommunicationException {
        String cipher_suite;
        int i;
        StringBuffer str_buffer;
        this.clientSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        this.clientSocket = (SSLSocket)this.clientSocketFactory.createSocket(serverName, serverPort);
        this.clientSocket.setSoTimeout(this.getTimeout());
        String[] supported_cs = this.clientSocket.getSupportedCipherSuites();
        if (logger.finerOn()) {
            logger.finer("doConnect", "Supported Cipher Suites");
        }
        if (supported_cs != null) {
            str_buffer = new StringBuffer();
            i = 0;
            while (i < supported_cs.length) {
                str_buffer.append(supported_cs[i]);
                if (i + 1 < supported_cs.length) {
                    str_buffer.append(", ");
                }
                ++i;
            }
            if (logger.finerOn()) {
                logger.finer("doConnect", "[" + str_buffer + "]");
            }
        } else if (logger.finerOn()) {
            logger.finer("doConnect", "[]");
        }
        Vector<String> user_specified_cs_vector = new Vector<String>();
        i = 1;
        while ((cipher_suite = System.getProperty("jdmk.ssl.cipher.suite." + String.valueOf(i))) != null) {
            user_specified_cs_vector.addElement(cipher_suite);
            ++i;
        }
        if (logger.finerOn()) {
            logger.finer("doConnect", "User Specified Cipher Suites");
            logger.finer("doConnect", user_specified_cs_vector.toString());
        }
        Vector<String> supported_user_specified_cs_vector = new Vector<String>();
        if (user_specified_cs_vector != null && user_specified_cs_vector.size() > 0) {
            Enumeration e = user_specified_cs_vector.elements();
            block2: while (e.hasMoreElements()) {
                cipher_suite = (String)e.nextElement();
                if (supported_cs == null) continue;
                i = 0;
                while (i < supported_cs.length) {
                    if (supported_cs[i].equals(cipher_suite)) {
                        supported_user_specified_cs_vector.addElement(cipher_suite);
                        continue block2;
                    }
                    ++i;
                }
            }
        }
        if (logger.finerOn()) {
            logger.finer("doConnect", "Supported User Specified Cipher Suites");
            logger.finer("doConnect", supported_user_specified_cs_vector.toString());
        }
        if (supported_user_specified_cs_vector != null && supported_user_specified_cs_vector.size() > 0) {
            i = 0;
            String[] ecs = (String[])Array.newInstance(String.class, supported_user_specified_cs_vector.size());
            Enumeration e = supported_user_specified_cs_vector.elements();
            while (e.hasMoreElements()) {
                cipher_suite = (String)e.nextElement();
                Array.set(ecs, i, cipher_suite);
                ++i;
            }
            this.clientSocket.setEnabledCipherSuites(ecs);
        }
        String[] enabled_cs = this.clientSocket.getEnabledCipherSuites();
        if (logger.finerOn()) {
            logger.finer("doConnect", "Enabled Cipher Suites");
        }
        if (enabled_cs != null) {
            str_buffer = new StringBuffer();
            i = 0;
            while (i < enabled_cs.length) {
                str_buffer.append(enabled_cs[i]);
                if (i + 1 < enabled_cs.length) {
                    str_buffer.append(", ");
                }
                ++i;
            }
            if (logger.finerOn()) {
                logger.finer("doConnect", "[" + str_buffer + "]");
            }
        } else if (logger.finerOn()) {
            logger.finer("doConnect", "[]");
        }
    }

    @Override
    public void doDisconnect() throws IOException, CommunicationException {
        if (this.serverSocket != null) {
            this.sckAccept.close();
            this.sckAccept = null;
        } else if (this.clientSocket != null) {
            this.clientSocket.close();
            this.clientSocket = null;
        }
    }

    @Override
    public void doSend(String header, byte[] content) throws IOException {
        this.outputStream = this.serverSocket != null ? this.sckAccept.getOutputStream() : this.clientSocket.getOutputStream();
        this.outputStream.write(header.getBytes());
        if (content != null) {
            this.outputStream.write(content);
        }
        this.outputStream.flush();
    }

    @Override
    public InputStream doReceive() throws IOException {
        if (this.serverSocket != null) {
            this.sckAccept = this.serverSocket.accept();
            this.sckAccept.setSoTimeout(this.getTimeout());
            this.inputStream = this.sckAccept.getInputStream();
        } else {
            this.inputStream = this.clientSocket.getInputStream();
        }
        return this.inputStream;
    }

    @Override
    public InputStream doGetInputStream() throws IOException {
        this.inputStream = this.serverSocket != null ? this.sckAccept.getInputStream() : this.clientSocket.getInputStream();
        return this.inputStream;
    }

    @Override
    public OutputStream doGetOutputStream() throws IOException {
        this.outputStream = this.serverSocket != null ? this.sckAccept.getOutputStream() : this.clientSocket.getOutputStream();
        return this.outputStream;
    }

    @Override
    public InetAddress getLocalAddress() {
        if (this.serverSocket != null) {
            return this.serverSocket.getInetAddress();
        }
        return this.clientSocket.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        if (this.serverSocket != null) {
            return this.serverSocket.getLocalPort();
        }
        return this.clientSocket.getLocalPort();
    }

    @Override
    public InetAddress getRemoteAddress() {
        if (this.serverSocket != null) {
            return this.sckAccept.getInetAddress();
        }
        return this.clientSocket.getInetAddress();
    }

    @Override
    public int getRemotePort() {
        if (this.serverSocket != null) {
            return this.sckAccept.getPort();
        }
        return this.clientSocket.getPort();
    }

    public String toString() {
        return this.serverSocket.toString();
    }
}

