/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.OperationContext;
import com.sun.jdmk.ProxyMBeanInstantiationException;
import com.sun.jdmk.comm.ClientNotificationDispatcher;
import com.sun.jdmk.comm.ClientNotificationHandlerInternal;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.ConnectorAddress;
import com.sun.jdmk.comm.DefaultMapper;
import com.sun.jdmk.comm.HeartBeatClientHandler;
import com.sun.jdmk.comm.HeartBeatClientHandlerImpl;
import com.sun.jdmk.comm.HeartBeatInternalClientHandler;
import com.sun.jdmk.comm.Mapper;
import com.sun.jdmk.comm.RemoteMBeanServer;
import com.sun.jdmk.comm.RemoteRuntimeException;
import com.sun.jdmk.comm.RmiConnectorAddress;
import com.sun.jdmk.comm.RmiConnectorServer;
import com.sun.jdmk.comm.RmiConnectorServerObject;
import com.sun.jdmk.comm.RmiConnectorServerObjectV2;
import com.sun.jdmk.comm.RmiNotificationReceiverImpl;
import com.sun.jdmk.comm.RmiNotificationReceiverImplV2;
import com.sun.jdmk.comm.TimedRmiSocketFactory;
import com.sun.jdmk.internal.ClassLogger;
import java.io.IOException;
import java.net.InetAddress;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.ServerRuntimeException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.util.Hashtable;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

public class RmiConnectorClient
implements RemoteMBeanServer,
HeartBeatClientHandler {
    private String localClassName;
    private String dbgTag;
    private final ClassLogger logger;
    private OperationContext operationContext;
    private transient boolean isConnected;
    private transient RmiConnectorAddress connectorAddress;
    private transient RmiConnectorServerObject connectorServerV1;
    private transient RmiConnectorServerObjectV2 connectorServerV2;
    private transient String MBeanServerId;
    private transient ClassLoader classLoader;
    private transient Mapper mapper;
    private transient Mapper defaultMapper;
    private ClientNotificationDispatcher notificationClientHandler;
    private RmiNotificationReceiverImpl rmiNotificationReceiver;
    private RmiNotificationReceiverImplV2 rmiNotificationReceiverV2;
    private HeartBeatClientHandlerImpl heartbeatClientHandler;
    private transient Hashtable proxyHandles;
    private transient Hashtable genericHandles;
    private String localHost;
    private RMIClientSocketFactory csf;

    public RmiConnectorClient(RMIClientSocketFactory csf) {
        this.dbgTag = this.localClassName = "com.sun.jdmk.comm.RmiConnectorClient";
        this.logger = new ClassLogger("com.sun.jdmk.comm.legacy.connector.rmi", this.makeDebugTag());
        this.operationContext = null;
        this.isConnected = false;
        this.connectorAddress = null;
        this.connectorServerV1 = null;
        this.connectorServerV2 = null;
        this.MBeanServerId = null;
        this.classLoader = null;
        this.mapper = null;
        this.defaultMapper = null;
        this.notificationClientHandler = null;
        this.rmiNotificationReceiver = null;
        this.rmiNotificationReceiverV2 = null;
        this.heartbeatClientHandler = null;
        this.proxyHandles = new Hashtable();
        this.genericHandles = new Hashtable();
        this.localHost = null;
        this.csf = null;
        this.csf = csf;
        if (System.getProperty("jdmk.hostname") != null) {
            this.localHost = System.getProperty("jdmk.hostname");
        } else {
            try {
                this.localHost = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                this.localHost = "localhost";
            }
        }
        if (this.logger.finerOn()) {
            this.logger.finer("RmiConnectorClient", "localHost=" + this.localHost);
        }
        this.Initialize();
    }

    public RmiConnectorClient() {
        this.dbgTag = this.localClassName = "com.sun.jdmk.comm.RmiConnectorClient";
        this.logger = new ClassLogger("com.sun.jdmk.comm.legacy.connector.rmi", this.makeDebugTag());
        this.operationContext = null;
        this.isConnected = false;
        this.connectorAddress = null;
        this.connectorServerV1 = null;
        this.connectorServerV2 = null;
        this.MBeanServerId = null;
        this.classLoader = null;
        this.mapper = null;
        this.defaultMapper = null;
        this.notificationClientHandler = null;
        this.rmiNotificationReceiver = null;
        this.rmiNotificationReceiverV2 = null;
        this.heartbeatClientHandler = null;
        this.proxyHandles = new Hashtable();
        this.genericHandles = new Hashtable();
        this.localHost = null;
        this.csf = null;
        if (System.getProperty("jdmk.hostname") != null) {
            this.localHost = System.getProperty("jdmk.hostname");
        } else {
            try {
                this.localHost = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                this.localHost = "localhost";
            }
        }
        if (this.logger.finerOn()) {
            this.logger.finer("RmiConnectorClient", "localHost=" + this.localHost);
        }
        this.Initialize();
    }

    public RmiConnectorClient(InetAddress addr) {
        this.dbgTag = this.localClassName = "com.sun.jdmk.comm.RmiConnectorClient";
        this.logger = new ClassLogger("com.sun.jdmk.comm.legacy.connector.rmi", this.makeDebugTag());
        this.operationContext = null;
        this.isConnected = false;
        this.connectorAddress = null;
        this.connectorServerV1 = null;
        this.connectorServerV2 = null;
        this.MBeanServerId = null;
        this.classLoader = null;
        this.mapper = null;
        this.defaultMapper = null;
        this.notificationClientHandler = null;
        this.rmiNotificationReceiver = null;
        this.rmiNotificationReceiverV2 = null;
        this.heartbeatClientHandler = null;
        this.proxyHandles = new Hashtable();
        this.genericHandles = new Hashtable();
        this.localHost = null;
        this.csf = null;
        try {
            this.localHost = addr == null ? (System.getProperty("jdmk.hostname") != null ? System.getProperty("jdmk.hostname") : InetAddress.getLocalHost().getHostAddress()) : addr.getHostAddress();
        }
        catch (Exception e) {
            this.localHost = "localhost";
        }
        if (this.logger.finerOn()) {
            this.logger.finer("RmiConnectorClient", "localHost=" + this.localHost);
        }
        this.Initialize();
    }

    public RmiConnectorClient(InetAddress add, int commTimeout) {
        this.dbgTag = this.localClassName = "com.sun.jdmk.comm.RmiConnectorClient";
        this.logger = new ClassLogger("com.sun.jdmk.comm.legacy.connector.rmi", this.makeDebugTag());
        this.operationContext = null;
        this.isConnected = false;
        this.connectorAddress = null;
        this.connectorServerV1 = null;
        this.connectorServerV2 = null;
        this.MBeanServerId = null;
        this.classLoader = null;
        this.mapper = null;
        this.defaultMapper = null;
        this.notificationClientHandler = null;
        this.rmiNotificationReceiver = null;
        this.rmiNotificationReceiverV2 = null;
        this.heartbeatClientHandler = null;
        this.proxyHandles = new Hashtable();
        this.genericHandles = new Hashtable();
        this.localHost = null;
        this.csf = null;
        try {
            this.localHost = add == null ? (System.getProperty("jdmk.hostname") != null ? System.getProperty("jdmk.hostname") : InetAddress.getLocalHost().getHostAddress()) : add.getHostAddress();
        }
        catch (Exception e) {
            this.localHost = "localhost";
        }
        try {
            RMISocketFactory.setSocketFactory(new TimedRmiSocketFactory(commTimeout));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.Initialize();
    }

    public void setTimeout(int timeout) {
        try {
            RMISocketFactory.setSocketFactory(new TimedRmiSocketFactory(timeout));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public RmiConnectorClient(String addr) {
        this.dbgTag = this.localClassName = "com.sun.jdmk.comm.RmiConnectorClient";
        this.logger = new ClassLogger("com.sun.jdmk.comm.legacy.connector.rmi", this.makeDebugTag());
        this.operationContext = null;
        this.isConnected = false;
        this.connectorAddress = null;
        this.connectorServerV1 = null;
        this.connectorServerV2 = null;
        this.MBeanServerId = null;
        this.classLoader = null;
        this.mapper = null;
        this.defaultMapper = null;
        this.notificationClientHandler = null;
        this.rmiNotificationReceiver = null;
        this.rmiNotificationReceiverV2 = null;
        this.heartbeatClientHandler = null;
        this.proxyHandles = new Hashtable();
        this.genericHandles = new Hashtable();
        this.localHost = null;
        this.csf = null;
        if (addr != null) {
            this.localHost = addr;
        } else {
            try {
                this.localHost = System.getProperty("jdmk.hostname") != null ? System.getProperty("jdmk.hostname") : InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                this.localHost = "localhost";
            }
        }
        if (this.logger.finerOn()) {
            this.logger.finer("RmiConnectorClient", "localHost=" + this.localHost);
        }
        this.Initialize();
    }

    private void Initialize() {
        this.mapper = this.defaultMapper = new DefaultMapper();
        this.notificationClientHandler = new ClientNotificationDispatcher(new NotificationHandlerInternal(this));
        this.heartbeatClientHandler = new HeartBeatClientHandlerImpl(new HeartBeatInternalClientHandlerImpl(this), this.notificationClientHandler);
    }

    Object[] remoteRequest(int opType, Object[] params) throws Exception {
        this.stopIfNotConnected("createMBean(className,name)");
        if (this.logger.finerOn()) {
            this.logger.finest("remoteRequest(opType,params)", "");
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.remoteRequest(opType, params, this.operationContext);
            }
            return this.connectorServerV1.remoteRequest(opType, params);
        }
        catch (ServerRuntimeException e) {
            e.detail.fillInStackTrace();
            if (e.detail instanceof RuntimeOperationsException) {
                throw (RuntimeOperationsException)e.detail;
            }
            if (e.detail instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)e.detail;
            }
            if (e.detail instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e.detail;
            }
            throw e;
        }
        catch (RemoteException e) {
            throw new CommunicationException(e);
        }
    }

    ConnectorAddress startPush() {
        this.stopIfNotConnected("startPush()");
        if (this.rmiNotificationReceiver == null && this.rmiNotificationReceiverV2 == null) {
            try {
                if (this.logger.finestOn()) {
                    this.logger.finest("startPush", "Create new RmiNotificationReceiverImpl");
                }
                try {
                    Object[] r = this.remoteRequest(13, null);
                    this.rmiNotificationReceiverV2 = new RmiNotificationReceiverImplV2(this, this.connectorAddress, this.notificationClientHandler);
                    this.rmiNotificationReceiverV2.startListening();
                }
                catch (JMRuntimeException jmr) {
                    this.rmiNotificationReceiverV2 = null;
                    this.rmiNotificationReceiver = new RmiNotificationReceiverImpl(this, this.connectorAddress, this.notificationClientHandler);
                    this.rmiNotificationReceiver.startListening();
                }
            }
            catch (ServerRuntimeException e) {
                throw (JMRuntimeException)e.detail;
            }
            catch (RemoteException e) {
                throw new CommunicationException(e);
            }
            catch (Exception e) {
                throw new CommunicationException(e);
            }
        }
        if (this.rmiNotificationReceiverV2 != null) {
            return this.rmiNotificationReceiverV2.getAddress();
        }
        return this.rmiNotificationReceiver.getAddress();
    }

    void stopPush() {
        this.stopIfNotConnected("stopPush()");
        if (this.rmiNotificationReceiver != null) {
            this.rmiNotificationReceiver.stopListening();
            this.rmiNotificationReceiver = null;
        } else if (this.rmiNotificationReceiverV2 != null) {
            this.rmiNotificationReceiverV2.stopListening();
            this.rmiNotificationReceiverV2 = null;
        }
    }

    @Override
    public void setMode(int mode) throws IllegalArgumentException {
        this.stopIfNotConnected("setMode()");
        this.notificationClientHandler.setMode(mode);
    }

    @Override
    public int getMode() {
        this.stopIfNotConnected("getMode()");
        return this.notificationClientHandler.getMode();
    }

    @Override
    public void getNotifications() {
        this.stopIfNotConnected("getNotifications()");
        this.notificationClientHandler.getNotifications();
    }

    @Override
    public void clearCache() {
        this.stopIfNotConnected("clearCache()");
        this.notificationClientHandler.clearCache();
    }

    @Override
    public void setPeriod(int period) {
        this.stopIfNotConnected("setPeriod()");
        this.notificationClientHandler.setPeriod(period);
    }

    @Override
    public int getPeriod() {
        this.stopIfNotConnected("getPeriod()");
        return this.notificationClientHandler.getPeriod();
    }

    @Override
    public int setCacheSize(int size, boolean discardOverflow) {
        this.stopIfNotConnected("setCacheSize()");
        return this.notificationClientHandler.setCacheSize(size, discardOverflow);
    }

    @Override
    public int getCacheSize() {
        this.stopIfNotConnected("getCacheSize()");
        return this.notificationClientHandler.getCacheSize();
    }

    @Override
    public void setOverflowCount(int count) {
        this.stopIfNotConnected("setOverflowCount()");
        this.notificationClientHandler.setOverflowCount(count);
    }

    @Override
    public int getOverflowCount() {
        this.stopIfNotConnected("getOverflowCount()");
        return this.notificationClientHandler.getOverflowCount();
    }

    @Override
    public void setOverflowMode(int of) throws IllegalArgumentException {
        this.stopIfNotConnected("setOverflowMode()");
        this.notificationClientHandler.setOverflowMode(of);
    }

    @Override
    public int getOverflowMode() {
        this.stopIfNotConnected("getOverflowMode()");
        return this.notificationClientHandler.getOverflowMode();
    }

    @Override
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.stopIfNotConnected("addNotificationListener()");
        this.notificationClientHandler.addNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.stopIfNotConnected("removeNotificationListener()");
        this.notificationClientHandler.removeNotificationListener(name, listener);
    }

    String pingHeartBeatServer(String sessionId, int period, int nretries, Long notifSessionId) {
        if (this.logger.finerOn()) {
            this.logger.finest("pingHeartBeatServer", "pingHeartBeatServer");
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.pingHeartBeatServer(sessionId, period, nretries, notifSessionId, this.operationContext);
            }
            return this.connectorServerV1.pingHeartBeatServer(sessionId, period, nretries, notifSessionId);
        }
        catch (ServerRuntimeException e) {
            throw (JMRuntimeException)e.detail;
        }
        catch (RemoteException e) {
            throw new CommunicationException(e);
        }
    }

    @Override
    public int getHeartBeatPeriod() {
        if (this.logger.finerOn()) {
            this.logger.finer("getHeartBeatPeriod", "getHeartBeatPeriod");
        }
        return this.heartbeatClientHandler.getHeartBeatPeriod();
    }

    @Override
    public void setHeartBeatPeriod(int period) {
        if (this.logger.finerOn()) {
            this.logger.finer("setHeartBeatPeriod", "setHeartBeatPeriod");
        }
        this.heartbeatClientHandler.setHeartBeatPeriod(period);
    }

    @Override
    public int getHeartBeatRetries() {
        if (this.logger.finerOn()) {
            this.logger.finer("getHeartBeatRetries", "getHeartBeatRetries");
        }
        return this.heartbeatClientHandler.getHeartBeatRetries();
    }

    @Override
    public void setHeartBeatRetries(int nretries) {
        if (this.logger.finerOn()) {
            this.logger.finer("setHeartBeatRetries", "setHeartBeatRetries");
        }
        this.heartbeatClientHandler.setHeartBeatRetries(nretries);
    }

    @Override
    public void addHeartBeatNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        if (this.logger.finerOn()) {
            this.logger.finer("addHeartBeatNotificationListener", "addHeartBeatNotificationListener");
        }
        this.heartbeatClientHandler.addHeartBeatNotificationListener(listener, filter, handback);
    }

    @Override
    public void removeHeartBeatNotificationListener(NotificationListener listener) {
        if (this.logger.finerOn()) {
            this.logger.finer("removeHeartBeatNotificationListener", "removeHeartBeatNotificationListener");
        }
        this.heartbeatClientHandler.removeHeartBeatNotificationListener(listener);
    }

    @Override
    public void setOperationContext(OperationContext c) {
        try {
            if (c != null) {
                c = (OperationContext)c.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            throw new CommunicationException(e);
        }
        this.operationContext = c;
    }

    @Override
    public OperationContext getOperationContext() {
        return this.operationContext;
    }

    @Override
    public String connect(ConnectorAddress MBeanServerAddress) {
        Registry r;
        if (!(MBeanServerAddress instanceof RmiConnectorAddress)) {
            String msg = "Invalid ConnectorAddress class: Expected '" + RmiConnectorAddress.class + "', got'" + MBeanServerAddress.getClass().getName() + "'";
            if (this.logger.finerOn()) {
                this.logger.finer("connect", msg);
            }
            throw new IllegalArgumentException(msg);
        }
        if (this.isConnected) {
            String msg = "ConnectorClient already connected to RemoteMBeanServer";
            if (this.logger.finerOn()) {
                this.logger.finer("connect", "ConnectorClient already connected to RemoteMBeanServer");
            }
            throw new CommunicationException("ConnectorClient already connected to RemoteMBeanServer");
        }
        this.connectorAddress = (RmiConnectorAddress)MBeanServerAddress;
        String host = this.connectorAddress.getHost();
        int port = this.connectorAddress.getPort();
        String name = this.connectorAddress.getName();
        Object connectorName = null;
        try {
            r = LocateRegistry.getRegistry(host, port, this.csf);
        }
        catch (Exception e) {
            String msg = "Can't contact RMI registry at " + host + ":" + port;
            if (this.logger.finerOn()) {
                this.logger.finer("connect", msg);
            }
            throw new CommunicationException(e, msg);
        }
        try {
            try {
                String v2name = RmiConnectorServer.serviceNameForVersion(name, 2);
                this.connectorServerV2 = (RmiConnectorServerObjectV2)r.lookup(v2name);
            }
            catch (NotBoundException e) {
                String v1name = RmiConnectorServer.serviceNameForVersion(name, 1);
                this.connectorServerV1 = (RmiConnectorServerObject)r.lookup(v1name);
            }
        }
        catch (Exception e) {
            String msg = "Can't contact RMI Connector Server with name " + name;
            if (this.logger.finerOn()) {
                this.logger.finer("connect", msg);
            }
            throw new CommunicationException(e, msg);
        }
        String currentMBeanServerId = null;
        try {
            ObjectName delegateName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
            currentMBeanServerId = this.connectorServerV2 != null ? (String)this.connectorServerV2.getAttribute(delegateName, "MBeanServerId", this.operationContext) : (String)this.connectorServerV1.getAttribute(delegateName, "MBeanServerId");
        }
        catch (CommunicationException e) {
            String msg = "Can't contact RMI Connector Server to get MBeanServerId";
            if (this.logger.finerOn()) {
                this.logger.finer("connect", "Can't contact RMI Connector Server to get MBeanServerId");
            }
            throw e;
        }
        catch (Exception e) {
            String msg = "Can't contact RMI Connector Server to get MBeanServerId";
            if (this.logger.finerOn()) {
                this.logger.finer("connect", "Can't contact RMI Connector Server to get MBeanServerId");
            }
            throw new CommunicationException(e, "Can't contact RMI Connector Server to get MBeanServerId");
        }
        if (this.MBeanServerId != null && !this.MBeanServerId.equals(currentMBeanServerId)) {
            String msg = "Invalid MBeanServerId";
            if (this.logger.finerOn()) {
                this.logger.finer("connect", "Invalid MBeanServerId");
            }
            throw new IllegalArgumentException("Invalid MBeanServerId");
        }
        this.MBeanServerId = currentMBeanServerId;
        this.isConnected = true;
        this.dbgTag = this.makeDebugTag();
        this.heartbeatClientHandler.notifyConnectionEstablished();
        this.heartbeatClientHandler.startPinging();
        if (this.logger.finerOn()) {
            this.logger.finer("connect", "Connection Ok");
        }
        return this.MBeanServerId;
    }

    @Override
    public void disconnect() {
        this.disconnect(false);
    }

    public void disconnect(boolean local) {
        if (this.isConnected) {
            this.stopPush();
            this.notificationClientHandler.stopListening(local);
            this.heartbeatClientHandler.stopPinging(-1, local);
            this.heartbeatClientHandler.notifyConnectionTerminated();
            this.connectorServerV1 = null;
            this.connectorServerV2 = null;
            this.connectorAddress = null;
            this.dbgTag = this.localClassName;
            if (this.logger.finerOn()) {
                this.logger.finer("connect", "Disconnection Ok");
            }
            this.isConnected = false;
        }
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    @Override
    public ConnectorAddress getMBeanServerAddress() {
        return this.connectorAddress;
    }

    @Override
    public String getMBeanServerId() {
        return this.MBeanServerId;
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        ObjectInstance result;
        this.stopIfNotConnected("createMBean(className,name)");
        if (this.logger.finerOn()) {
            this.logger.finer("createMBean(className,name)", "MBean class name = " + className + " ; MBean name = " + name);
        }
        try {
            result = this.connectorServerV2 != null ? this.connectorServerV2.createMBean(className, name, this.operationContext) : this.connectorServerV1.createMBean(className, name);
        }
        catch (ServerRuntimeException e) {
            throw (JMRuntimeException)e.detail;
        }
        catch (RemoteException e) {
            throw new CommunicationException(e);
        }
        return result;
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        ObjectInstance result;
        this.stopIfNotConnected("createMBean(className,name,loaderName)");
        if (this.logger.finerOn()) {
            this.logger.finer("createMBean(className,name,loaderName)", "MBean class name = " + className + " ; MBean name = " + name);
        }
        try {
            result = this.connectorServerV2 != null ? this.connectorServerV2.createMBean(className, name, loaderName, this.operationContext) : this.connectorServerV1.createMBean(className, name, loaderName);
        }
        catch (ServerRuntimeException e) {
            throw (JMRuntimeException)e.detail;
        }
        catch (RemoteException e) {
            throw new CommunicationException(e);
        }
        return result;
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        ObjectInstance result;
        this.stopIfNotConnected("createMBean(className,name,params,signature)");
        if (this.logger.finerOn()) {
            this.logger.finer("createMBean(className,name,params,signature)", "MBean class name = " + className + " ; MBean name = " + name);
        }
        try {
            result = this.connectorServerV2 != null ? this.connectorServerV2.createMBean(className, name, params, signature, this.operationContext) : this.connectorServerV1.createMBean(className, name, params, signature);
        }
        catch (ServerRuntimeException e) {
            throw (JMRuntimeException)e.detail;
        }
        catch (RemoteException e) {
            throw new CommunicationException(e);
        }
        return result;
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        ObjectInstance result;
        this.stopIfNotConnected("createMBean(className,name,loaderName,params,signature)");
        if (this.logger.finerOn()) {
            this.logger.finer("createMBean(className,name,loaderName,params,signature)", "MBean class name = " + className + " ; MBean name = " + name);
        }
        try {
            result = this.connectorServerV2 != null ? this.connectorServerV2.createMBean(className, name, loaderName, params, signature, this.operationContext) : this.connectorServerV1.createMBean(className, name, loaderName, params, signature);
        }
        catch (ServerRuntimeException e) {
            throw (JMRuntimeException)e.detail;
        }
        catch (RemoteException e) {
            throw new CommunicationException(e);
        }
        return result;
    }

    @Override
    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        this.stopIfNotConnected("unregisterMBean(name)");
        if (this.logger.finerOn()) {
            this.logger.finer("unregisterMBean", "Remove ProxyMBean and GenericProxy, if required, for name " + name);
        }
        if (this.logger.finerOn()) {
            this.logger.finer("unregisterMBean(name)", "Remove MBean with name " + name);
        }
        try {
            if (this.connectorServerV2 != null) {
                this.connectorServerV2.unregisterMBean(name, this.operationContext);
            } else {
                this.connectorServerV1.unregisterMBean(name);
            }
        }
        catch (ServerRuntimeException e) {
            throw (JMRuntimeException)e.detail;
        }
        catch (RemoteException e) {
            throw new CommunicationException(e);
        }
        this.proxyHandles.remove(name);
        this.genericHandles.remove(name);
    }

    @Override
    public boolean isRegistered(ObjectName name) {
        this.stopIfNotConnected("isRegistered(name)");
        if (this.logger.finerOn()) {
            this.logger.finer("isRegistered(name)", "Call remote MBean server");
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.isRegistered(name, this.operationContext);
            }
            return this.connectorServerV1.isRegistered(name);
        }
        catch (ServerRuntimeException e) {
            throw (JMRuntimeException)e.detail;
        }
        catch (RemoteException e) {
            throw new CommunicationException(e);
        }
    }

    @Override
    public Set queryNames(ObjectName name, QueryExp query) {
        this.stopIfNotConnected("queryNames(name,query)");
        if (this.logger.finerOn()) {
            this.logger.finer("queryNames(name,query)", "Call remote MBean server");
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.queryNames(name, query, this.operationContext);
            }
            return this.connectorServerV1.queryNames(name, query);
        }
        catch (ServerRuntimeException e) {
            throw (JMRuntimeException)e.detail;
        }
        catch (RemoteException e) {
            throw new CommunicationException(e);
        }
    }

    @Override
    public Set queryMBeans(ObjectName name, QueryExp query) {
        this.stopIfNotConnected("queryMBeans(name,query)");
        if (this.logger.finerOn()) {
            this.logger.finer("queryMBeans(name,query)", "MBean name = " + name);
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.queryMBeans(name, query, this.operationContext);
            }
            return this.connectorServerV1.queryMBeans(name, query);
        }
        catch (ServerRuntimeException e) {
            throw (JMRuntimeException)e.detail;
        }
        catch (RemoteException e) {
            throw new CommunicationException(e);
        }
    }

    @Override
    public Integer getMBeanCount() {
        this.stopIfNotConnected("getMBeanCount()");
        if (this.logger.finerOn()) {
            this.logger.finer("getMBeanCount()", "");
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.getMBeanCount(this.operationContext);
            }
            return this.connectorServerV1.getMBeanCount();
        }
        catch (ServerRuntimeException e) {
            throw (JMRuntimeException)e.detail;
        }
        catch (RemoteException e) {
            throw new CommunicationException(e);
        }
    }

    @Override
    public String getDefaultDomain() {
        this.stopIfNotConnected("getDefaultDomain()");
        if (this.logger.finerOn()) {
            this.logger.finer("getDefaultDomain()", "");
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.getDefaultDomain(this.operationContext);
            }
            return this.connectorServerV1.getDefaultDomain();
        }
        catch (ServerRuntimeException e) {
            throw (JMRuntimeException)e.detail;
        }
        catch (RemoteException e) {
            throw new CommunicationException(e);
        }
    }

    @Override
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        this.stopIfNotConnected("isInstanceOf(name)");
        if (this.logger.finerOn()) {
            this.logger.finer("isInstanceOf(name)", "MBean object name = " + name + " class name = " + className);
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.isInstanceOf(name, className, this.operationContext);
            }
            String msg = "isInstanceOf unsupported with this server";
            throw new IllegalArgumentException("isInstanceOf unsupported with this server");
        }
        catch (ServerRuntimeException e) {
            throw (JMRuntimeException)e.detail;
        }
        catch (RemoteException e) {
            throw new CommunicationException(e);
        }
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        this.stopIfNotConnected("getObjectInstance(name)");
        if (this.logger.finerOn()) {
            this.logger.finer("getObjectInstance(name)", "MBean object name = " + name);
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.getObjectInstance(name, this.operationContext);
            }
            return this.connectorServerV1.getObjectInstance(name);
        }
        catch (ServerRuntimeException e) {
            throw (JMRuntimeException)e.detail;
        }
        catch (RemoteException e) {
            throw new CommunicationException(e);
        }
    }

    @Override
    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        this.stopIfNotConnected("getAttribute(name,attribute)");
        if (this.logger.finerOn()) {
            this.logger.finer("getAttribute(name,attribute)", "MBean object name = " + name + " ; attribute name = " + attribute);
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.getAttribute(name, attribute, this.operationContext);
            }
            return this.connectorServerV1.getAttribute(name, attribute);
        }
        catch (ServerRuntimeException e) {
            throw (JMRuntimeException)e.detail;
        }
        catch (RemoteException e) {
            throw new CommunicationException(e);
        }
    }

    @Override
    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        this.stopIfNotConnected("getAttributes(name,attributes)");
        if (this.logger.finerOn()) {
            this.logger.finer("getAttribute(name,attributes)", "MBean object name = " + name);
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.getAttributes(name, attributes, this.operationContext);
            }
            return this.connectorServerV1.getAttributes(name, attributes);
        }
        catch (ServerRuntimeException e) {
            throw (JMRuntimeException)e.detail;
        }
        catch (RemoteException e) {
            throw new CommunicationException(e);
        }
    }

    @Override
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.stopIfNotConnected("setAttribute(name,attribute)");
        if (this.logger.finerOn() && attribute != null) {
            this.logger.finer("setAttribute(name,attribute)", "MBean object name = " + name + " ; attribute name = " + attribute.getName());
        }
        try {
            if (this.connectorServerV2 != null) {
                this.connectorServerV2.setAttribute(name, attribute, this.operationContext);
            } else {
                this.connectorServerV1.setAttribute(name, attribute);
            }
        }
        catch (ServerRuntimeException e) {
            throw (JMRuntimeException)e.detail;
        }
        catch (RemoteException e) {
            throw new CommunicationException(e);
        }
    }

    @Override
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        this.stopIfNotConnected("setAttributes(name,attributes)");
        if (this.logger.finerOn()) {
            this.logger.finer("setAttribute(name,attributes)", "MBean object name = " + name);
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.setAttributes(name, attributes, this.operationContext);
            }
            return this.connectorServerV1.setAttributes(name, attributes);
        }
        catch (ServerRuntimeException e) {
            throw (JMRuntimeException)e.detail;
        }
        catch (RemoteException e) {
            throw new CommunicationException(e);
        }
    }

    @Override
    public Object invoke(ObjectName name, String methodName, Object[] arguments, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        this.stopIfNotConnected("invoke(name,methodName,arguments,signature)");
        if (this.logger.finerOn()) {
            this.logger.finer("invoke(name,methodName,arguments,signature)", "");
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.invoke(name, methodName, arguments, signature, this.operationContext);
            }
            return this.connectorServerV1.invoke(name, methodName, arguments, signature);
        }
        catch (ServerRuntimeException e) {
            throw (JMRuntimeException)e.detail;
        }
        catch (RemoteException e) {
            throw new CommunicationException(e);
        }
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        this.stopIfNotConnected("getMBeanInfo(name)");
        if (this.logger.finerOn()) {
            this.logger.finer("getMBeanInfo(name)", "");
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.getMBeanInfo(name, this.operationContext);
            }
            return this.connectorServerV1.getMBeanInfo(name);
        }
        catch (ServerRuntimeException e) {
            throw (JMRuntimeException)e.detail;
        }
        catch (RemoteException e) {
            throw new CommunicationException(e);
        }
    }

    @Override
    public String getClassForProxyMBean(ObjectInstance instance) throws ProxyMBeanInstantiationException {
        if (instance == null) {
            throw new IllegalArgumentException("ObjectInstance cannot be null");
        }
        return this.mapper.getClassForProxyMBean(instance);
    }

    String getHost() {
        return this.localHost;
    }

    private void stopIfNotConnected(String methodName) throws CommunicationException {
        if (!this.isConnected) {
            if (this.logger.finerOn()) {
                this.logger.finer("methodName", " Not connected");
            }
            throw new CommunicationException("ConnectorClient not connected to RMI Connector Server");
        }
    }

    private String makeDebugTag() {
        if (this.connectorAddress != null) {
            return String.valueOf(this.localClassName) + "[" + this.connectorAddress.getPort() + ":" + this.connectorAddress.getName() + "]";
        }
        return this.localClassName;
    }

    private class HeartBeatInternalClientHandlerImpl
    implements HeartBeatInternalClientHandler {
        private RmiConnectorClient connector;

        public HeartBeatInternalClientHandlerImpl(RmiConnectorClient connector) {
            this.connector = connector;
        }

        @Override
        public RemoteMBeanServer getRemoteMBeanServer() {
            return this.connector;
        }

        @Override
        public String pingHeartBeatServer(String sessionId, int period, int nretries, Long notifSessionId) {
            return this.connector.pingHeartBeatServer(sessionId, period, nretries, notifSessionId);
        }
    }

    private class NotificationHandlerInternal
    implements ClientNotificationHandlerInternal {
        private RmiConnectorClient connector;

        public NotificationHandlerInternal(RmiConnectorClient connector) {
            this.connector = connector;
        }

        @Override
        public Object[] remoteRequest(int opType, Object[] params) throws CommunicationException, Exception {
            return this.connector.remoteRequest(opType, params);
        }

        @Override
        public ConnectorAddress startPush() throws CommunicationException, RemoteRuntimeException {
            return this.connector.startPush();
        }

        @Override
        public void stopPush(ConnectorAddress address) {
            this.connector.stopPush();
        }
    }
}

