/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.internal;

import com.sun.jdmk.tasks.Task;
import com.sun.jdmk.tasks.TaskServer;
import java.util.ArrayList;

public class ThreadService
implements TaskServer {
    private ArrayList jobList = new ArrayList(0);
    private ExecutorThread[] threadList;
    private int minThreads = 1;
    private int currThreds = 0;
    private int idle = 0;
    private boolean terminated = false;
    private int priority;
    private ThreadGroup threadGroup = new ThreadGroup("ThreadService");
    private ClassLoader cloader;
    private static long counter = 0L;
    private int addedJobs = 1;
    private int doneJobs = 1;

    public ThreadService(int threadNumber) {
        if (threadNumber <= 0) {
            throw new IllegalArgumentException("The thread number should bigger than zero.");
        }
        this.minThreads = threadNumber;
        this.threadList = new ExecutorThread[threadNumber];
        this.priority = Thread.currentThread().getPriority();
        this.cloader = Thread.currentThread().getContextClassLoader();
    }

    @Override
    public void submitTask(Task task) throws IllegalArgumentException {
        this.submitTask((Runnable)task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitTask(Runnable task) throws IllegalArgumentException {
        this.stateCheck();
        if (task == null) {
            throw new IllegalArgumentException("No task specified.");
        }
        ArrayList arrayList = this.jobList;
        synchronized (arrayList) {
            this.jobList.add(this.jobList.size(), task);
            this.jobList.notify();
        }
        this.createThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable removeTask(Runnable task) {
        this.stateCheck();
        Runnable removed = null;
        ArrayList arrayList = this.jobList;
        synchronized (arrayList) {
            int lg = this.jobList.indexOf(task);
            if (lg >= 0) {
                removed = (Runnable)this.jobList.remove(lg);
            }
        }
        if (removed != null && removed instanceof Task) {
            ((Task)removed).cancel();
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Object[] jobs;
        this.stateCheck();
        ArrayList arrayList = this.jobList;
        synchronized (arrayList) {
            jobs = this.jobList.toArray();
            this.jobList.clear();
        }
        int len = jobs.length;
        int i = 0;
        while (i < len) {
            Object o = jobs[i];
            if (o != null && o instanceof Task) {
                ((Task)o).cancel();
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        if (this.terminated) {
            return;
        }
        this.terminated = true;
        ArrayList arrayList = this.jobList;
        synchronized (arrayList) {
            this.jobList.notifyAll();
        }
        this.removeAll();
        int i = 0;
        while (i < this.currThreds) {
            try {
                this.threadList[i].interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        this.threadList = null;
    }

    private void stateCheck() throws IllegalStateException {
        if (this.terminated) {
            throw new IllegalStateException("The thread service has been terminated.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createThread() {
        if (this.idle >= 1) return;
        ExecutorThread[] executorThreadArray = this.threadList;
        synchronized (this.threadList) {
            if (this.jobList.size() <= 0 || this.currThreds >= this.minThreads) return;
            ExecutorThread et = new ExecutorThread();
            et.start();
            this.threadList[this.currThreds++] = et;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private class ExecutorThread
    extends Thread {
        public ExecutorThread() {
            ThreadGroup threadGroup = ThreadService.this.threadGroup;
            StringBuilder stringBuilder = new StringBuilder("ThreadService-");
            long l = counter;
            counter = l + 1L;
            super(threadGroup, stringBuilder.append(l).toString());
            this.setDaemon(true);
            this.setPriority(ThreadService.this.priority);
            this.setContextClassLoader(ThreadService.this.cloader);
            ThreadService threadService2 = ThreadService.this;
            threadService2.idle = threadService2.idle + 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!ThreadService.this.terminated) {
                block15: {
                    Runnable job = null;
                    ArrayList arrayList = ThreadService.this.jobList;
                    synchronized (arrayList) {
                        if (ThreadService.this.jobList.size() > 0) {
                            job = (Runnable)ThreadService.this.jobList.remove(0);
                            if (ThreadService.this.jobList.size() > 0) {
                                ThreadService.this.jobList.notify();
                            }
                        } else {
                            try {
                                ThreadService.this.jobList.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                    if (job != null) {
                        try {
                            try {
                                ThreadService threadService = ThreadService.this;
                                threadService.idle = threadService.idle - 1;
                                job.run();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                ThreadService threadService = ThreadService.this;
                                threadService.idle = threadService.idle + 1;
                                break block15;
                            }
                        }
                        catch (Throwable throwable) {
                            ThreadService threadService = ThreadService.this;
                            threadService.idle = threadService.idle + 1;
                            throw throwable;
                        }
                        ThreadService threadService = ThreadService.this;
                        threadService.idle = threadService.idle + 1;
                    }
                }
                this.setPriority(ThreadService.this.priority);
                ExecutorThread.interrupted();
                this.setContextClassLoader(ThreadService.this.cloader);
            }
        }
    }
}

