/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.remote.cascading;

import com.sun.jdmk.defaults.Utils;
import com.sun.jdmk.remote.cascading.CascadingAgentMBean;
import com.sun.jdmk.remote.cascading.MBeanServerConnectionFactory;
import java.io.IOException;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.remote.JMXConnectionNotification;

public abstract class CascadingAgent
implements MBeanRegistration,
NotificationEmitter,
CascadingAgentMBean {
    public static final ObjectName MBSDelegateObjectName;
    private static final String[] jmxConnectionNotificationTypes;
    private static final MBeanNotificationInfo jmxConnectionNotificationInfo;
    private final MBeanServerConnectionFactory connectionFactory;
    private final ObjectName sourcePattern;
    private final QueryExp sourceQuery;
    private final String targetPath;
    private final MBeanServer targetMBS;
    private final NotificationBroadcasterSupport emitter;
    private ConnectionListener connectionListener;
    private MBeanServer myMBS;

    static {
        try {
            MBSDelegateObjectName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        }
        catch (MalformedObjectNameException e) {
            throw new UnsupportedOperationException(e.getMessage());
        }
        jmxConnectionNotificationTypes = new String[]{"jmx.remote.connection.opened", "jmx.remote.connection.closed", "jmx.remote.connection.failed", "jmx.remote.connection.notifs.lost"};
        jmxConnectionNotificationInfo = new MBeanNotificationInfo(jmxConnectionNotificationTypes, JMXConnectionNotification.class.getName(), "Notifications relating to the underlying JMX Remote Connection.");
    }

    protected CascadingAgent(MBeanServerConnectionFactory sourceConnection, ObjectName sourcePattern, QueryExp sourceQuery, String targetPath, MBeanServer targetMBS) {
        block4: {
            this.myMBS = null;
            if (targetPath != null && targetPath.length() != 0) {
                try {
                    if (ObjectName.getInstance(String.valueOf(targetPath) + "/D:k=v").isPattern()) {
                        throw new IllegalArgumentException("targetPath `" + targetPath + "' contains reserved " + "`*' or `?' " + "characters");
                    }
                    break block4;
                }
                catch (MalformedObjectNameException x) {
                    IllegalArgumentException iae = new IllegalArgumentException("targetPath `" + targetPath + "' is not valid");
                    throw (IllegalArgumentException)Utils.initCause(iae, x);
                }
            }
            targetPath = null;
        }
        this.connectionFactory = sourceConnection;
        this.emitter = new NotificationBroadcasterSupport(){

            @Override
            protected void handleNotification(NotificationListener listener, Notification notif, Object handback) {
                CascadingAgent.this.handleNotification(listener, notif, handback);
            }
        };
        this.sourcePattern = sourcePattern;
        this.sourceQuery = sourceQuery;
        this.targetPath = targetPath;
        this.targetMBS = targetMBS;
    }

    protected synchronized void enableConnectionNotifications() throws IOException {
        ConnectionListener l = new ConnectionListener();
        this.connectionFactory.addConnectionNotificationListener(l, null, null);
        this.connectionListener = l;
        this.connectionListener.enable();
    }

    protected synchronized void disableConnectionNotifications() throws IOException {
        try {
            ConnectionListener l = this.connectionListener;
            if (l == null) {
                return;
            }
            this.connectionListener = null;
            l.disable();
            this.connectionFactory.removeConnectionNotificationListener(l, null, null);
        }
        catch (ListenerNotFoundException listenerNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public final String getTargetPath() {
        return this.targetPath;
    }

    @Override
    public int getCascadedMBeanCount() {
        return this.getCascadedMBeans().size();
    }

    @Override
    public abstract Set getCascadedMBeans();

    @Override
    public abstract void start() throws IOException;

    @Override
    public abstract void start(boolean var1) throws IOException, InstanceAlreadyExistsException;

    @Override
    public abstract void stop() throws IOException;

    @Override
    public abstract boolean isActive();

    @Override
    public abstract String getDescription();

    protected abstract void handleJMXConnectionNotification(Notification var1, Object var2);

    @Override
    public final ObjectName getPattern() {
        return this.sourcePattern;
    }

    @Override
    public final QueryExp getQuery() {
        return this.sourceQuery;
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.emitter.addNotificationListener(listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(listener);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(listener, filter, handback);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] info = new MBeanNotificationInfo[]{jmxConnectionNotificationInfo};
        return info;
    }

    protected void sendNotification(Notification notification) {
        this.emitter.sendNotification(notification);
    }

    protected void handleNotification(NotificationListener listener, Notification notif, Object handback) {
        listener.handleNotification(notif, handback);
    }

    public final MBeanServer getTargetMBeanServer() {
        return this.targetMBS != null ? this.targetMBS : this.myMBS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (name == null) {
            throw new IllegalArgumentException("Illegal ObjectName: null");
        }
        CascadingAgent cascadingAgent = this;
        synchronized (cascadingAgent) {
            if (this.targetMBS == null && this.myMBS != null && this.myMBS != server) {
                throw new IllegalArgumentException("Already registered");
            }
            this.myMBS = server;
        }
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
        this.myMBS = null;
    }

    public final MBeanServerConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    private class ConnectionListener
    implements NotificationListener {
        private boolean enabled = false;

        private ConnectionListener() {
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            if (this.enabled()) {
                CascadingAgent.this.handleJMXConnectionNotification(notification, handback);
            }
        }

        public synchronized void enable() {
            this.enabled = true;
        }

        public synchronized void disable() {
            this.enabled = false;
        }

        public synchronized boolean enabled() {
            return this.enabled;
        }
    }
}

