/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.api.document;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.query.sql.model.OrderByExprs;
import org.nuxeo.ecm.core.query.sql.model.Predicates;
import org.nuxeo.ecm.core.query.sql.model.QueryBuilder;
import org.nuxeo.ecm.platform.audit.api.AuditQueryBuilder;
import org.nuxeo.ecm.platform.audit.api.AuditReader;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.api.document.AdditionalDocumentAuditParams;
import org.nuxeo.ecm.platform.audit.api.document.SourceDocumentResolver;
import org.nuxeo.runtime.api.Framework;

public class DocumentAuditHelper {
    public static AdditionalDocumentAuditParams getAuditParamsForUUID(String uuid, CoreSession session) {
        AdditionalDocumentAuditParams result;
        IdRef ref = new IdRef(uuid);
        if (!session.exists((DocumentRef)ref)) {
            return null;
        }
        DocumentModel doc = session.getDocument((DocumentRef)ref);
        if (!doc.isProxy() && !doc.isVersion()) {
            return null;
        }
        SourceDocumentResolver resolver = new SourceDocumentResolver(session, doc);
        resolver.runUnrestricted();
        if (resolver.sourceDocument == null) {
            return null;
        }
        String targetUUID = resolver.sourceDocument.getId();
        QueryBuilder builder = new AuditQueryBuilder().predicate(Predicates.eq((String)"docUUID", (Object)uuid)).and(Predicates.eq((String)"eventId", (Object)"documentCreated"));
        AuditReader reader = (AuditReader)Framework.getService(AuditReader.class);
        List<LogEntry> entries = reader.queryLogs(builder);
        if (entries != null && entries.size() > 0) {
            result = new AdditionalDocumentAuditParams();
            result.maxDate = entries.get(0).getEventDate();
            result.targetUUID = targetUUID;
            result.eventId = entries.get(0).getId();
        } else {
            if (doc.getPropertyValue("dc:modified") == null) {
                return null;
            }
            result = new AdditionalDocumentAuditParams();
            Calendar estimatedDate = (Calendar)doc.getPropertyValue("dc:modified");
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(targetUUID);
            if (doc.isVersion()) {
                session.getProxies(doc.getRef(), null).stream().map(DocumentModel::getId).forEach(ids::add);
            }
            estimatedDate.add(14, -500);
            AuditQueryBuilder dateBuilder = new AuditQueryBuilder();
            dateBuilder.predicate(Predicates.in((String)"docUUID", ids)).and(Predicates.in((String)"eventId", (Object)"documentCreated", (Object[])new String[]{"documentCheckedIn"})).and(Predicates.gte((String)"eventDate", (Object)estimatedDate.getTime()));
            dateBuilder.order(OrderByExprs.asc((String)"eventId"));
            dateBuilder.offset(0L).limit(20L);
            List<LogEntry> dateEntries = reader.queryLogs(dateBuilder);
            if (dateEntries.size() > 0) {
                result.targetUUID = targetUUID;
                GregorianCalendar maxDate = new GregorianCalendar();
                maxDate.setTime(dateEntries.get(0).getEventDate());
                ((Calendar)maxDate).add(14, -500);
                result.maxDate = maxDate.getTime();
            } else {
                result.targetUUID = targetUUID;
                result.maxDate = ((Calendar)doc.getPropertyValue("dc:modified")).getTime();
            }
        }
        return result;
    }
}

